/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.elements;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.elements.DomainElement;
import org.eclipse.ocl.examples.domain.elements.DomainTemplateParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainTypeParameters {
    @NonNull
    public static final DomainTypeParameters EMPTY_LIST = new DomainTypeParameters(new DomainTemplateParameter[0]);
    @NonNull
    private final DomainElement[] typeParameters;
    private final int hashCode;

    public DomainTypeParameters(DomainTemplateParameter ... typeParameters) {
        this.typeParameters = typeParameters;
        int hash = 0;
        int i = 0;
        while (i < typeParameters.length) {
            hash = 111 * hash + typeParameters[i].hashCode();
            ++i;
        }
        this.hashCode = hash;
    }

    public DomainTypeParameters(@NonNull List<? extends DomainElement> parameters) {
        this.typeParameters = new DomainElement[parameters.size()];
        int hash = 0;
        int i = 0;
        while (i < this.typeParameters.length) {
            DomainElement parameter = parameters.get(i);
            hash = 111 * hash + parameter.hashCode();
            this.typeParameters[i] = parameter;
            ++i;
        }
        this.hashCode = hash;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof DomainTypeParameters)) {
            return false;
        }
        DomainTypeParameters that = (DomainTypeParameters)o;
        if (this.hashCode != that.hashCode) {
            return false;
        }
        int iMax = this.typeParameters.length;
        if (iMax != that.typeParameters.length) {
            return false;
        }
        int i = 0;
        while (i < iMax) {
            DomainElement thisParameter = this.typeParameters[i];
            DomainElement thatParameter = that.typeParameters[i];
            if (thisParameter != null) {
                if (thatParameter == null) return false;
                if (!thisParameter.equals(thatParameter)) {
                    return false;
                }
            } else if (thatParameter != null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @NonNull
    public DomainElement get(int i) {
        return this.typeParameters[i];
    }

    public int hashCode() {
        return this.hashCode;
    }

    public int parametersSize() {
        return this.typeParameters.length;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append('(');
        int i = 0;
        while (i < this.typeParameters.length) {
            if (i > 0) {
                s.append(',');
            }
            s.append(String.valueOf(this.typeParameters[i]));
            ++i;
        }
        s.append(')');
        return s.toString();
    }
}

