/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.infra.browser.core.InstancesForMetaclass;
import org.eclipse.gmt.modisco.infra.browser.editors.BrowserConfiguration;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.util.EMFUtil;
import org.eclipse.gmt.modisco.infra.common.core.internal.adapters.instances.MetaclassInstances;
import org.eclipse.gmt.modisco.infra.common.core.internal.adapters.instances.ModelChangeListener;
import org.eclipse.gmt.modisco.infra.common.core.internal.utils.ModelUtils;
import org.eclipse.gmt.modisco.infra.facet.Facet;
import org.eclipse.gmt.modisco.infra.facet.core.FacetContext;
import org.eclipse.gmt.modisco.infra.facet.core.FacetContextListener;
import org.eclipse.gmt.modisco.infra.facet.core.adapters.instances.MetaclassInstancesAdapterFactoryWithFacet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstancesForMetaclasses
implements FacetContextListener,
ModelChangeListener {
    private final TreeMap<EClass, InstancesForMetaclass> modelElements;
    private final ArrayList<InstancesForMetaclass> rootMetaclasses = new ArrayList();
    private final BrowserConfiguration browserConfiguration;
    private final Set<Resource> fResources;
    private final List<MetaclassesChangeListener> listeners = new ArrayList<MetaclassesChangeListener>();

    public InstancesForMetaclasses(BrowserConfiguration browserConfiguration, Set<Resource> resources) {
        this.browserConfiguration = browserConfiguration;
        this.fResources = new HashSet<Resource>();
        this.modelElements = new TreeMap(new Comparator<EClass>(){

            @Override
            public int compare(EClass e1, EClass e2) {
                String q1 = ModelUtils.getMetaclassQualifiedName((EClassifier)e1);
                String q2 = ModelUtils.getMetaclassQualifiedName((EClassifier)e2);
                if (q1 == null) {
                    return -1;
                }
                return q1.compareTo(q2);
            }
        });
        FacetContext facetContext = browserConfiguration.getAppearanceConfiguration().getFacetContext();
        MetaclassInstancesAdapterFactoryWithFacet.getInstance().setFacetContext(facetContext);
        for (Resource resource : resources) {
            this.internalWatchResource(resource);
        }
        this.computeModelElements();
        facetContext.addListener((FacetContextListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeModelElements() {
        ArrayList<Resource> resources;
        Set<Resource> set = this.fResources;
        synchronized (set) {
            resources = new ArrayList<Resource>(this.fResources);
        }
        Collection allClasses = EMFUtil.findAllClasses(resources);
        for (EClass eClass : allClasses) {
            TreeMap<EClass, InstancesForMetaclass> treeMap = this.modelElements;
            synchronized (treeMap) {
                if (!this.modelElements.containsKey(eClass)) {
                    InstancesForMetaclass instancesForMetaclass = new InstancesForMetaclass(eClass, this, this.browserConfiguration, this.fResources);
                    this.modelElements.put(eClass, instancesForMetaclass);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void watchResource(Resource resource) {
        boolean contained;
        Set<Resource> set = this.fResources;
        synchronized (set) {
            contained = this.fResources.contains(resource);
        }
        if (!contained) {
            FacetContext facetContext = this.browserConfiguration.getAppearanceConfiguration().getFacetContext();
            MetaclassInstancesAdapterFactoryWithFacet.getInstance().setFacetContext(facetContext);
            this.internalWatchResource(resource);
            this.computeModelElements();
            this.buildDerivationTree();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalWatchResource(Resource resource) {
        MetaclassInstances instances = (MetaclassInstances)MetaclassInstancesAdapterFactoryWithFacet.getInstance().adapt((Notifier)resource, MetaclassInstances.class);
        instances.addListener((ModelChangeListener)this);
        Set<Resource> set = this.fResources;
        synchronized (set) {
            this.fResources.add(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unwatchResource(Resource resource) {
        boolean contained;
        Set<Resource> set = this.fResources;
        synchronized (set) {
            contained = this.fResources.contains(resource);
        }
        if (contained) {
            MetaclassInstancesAdapterFactoryWithFacet.getInstance().setFacetContext(this.browserConfiguration.getAppearanceConfiguration().getFacetContext());
            MetaclassInstances instances = (MetaclassInstances)MetaclassInstancesAdapterFactoryWithFacet.getInstance().adapt((Notifier)resource, MetaclassInstances.class);
            this.browserConfiguration.getAppearanceConfiguration().touch();
            instances.removeListener((ModelChangeListener)this);
            Set<Resource> set2 = this.fResources;
            synchronized (set2) {
                this.fResources.remove(resource);
            }
            this.computeModelElements();
            this.buildDerivationTree();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstancesForMetaclass[] getInstancesForMetaclasses() {
        TreeMap<EClass, InstancesForMetaclass> treeMap = this.modelElements;
        synchronized (treeMap) {
            Collection<InstancesForMetaclass> instancesForMetaclasses = this.modelElements.values();
            return instancesForMetaclasses.toArray(new InstancesForMetaclass[instancesForMetaclasses.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstancesForMetaclass getInstancesForMetaclass(EClass eClass) {
        TreeMap<EClass, InstancesForMetaclass> treeMap = this.modelElements;
        synchronized (treeMap) {
            return this.modelElements.get(eClass);
        }
    }

    public void buildDerivationTree() {
        InstancesForMetaclass instancesForMetaclass;
        InstancesForMetaclass[] instancesByMetaclass = this.getInstancesForMetaclasses();
        this.rootMetaclasses.clear();
        InstancesForMetaclass[] instancesForMetaclassArray = instancesByMetaclass;
        int n = instancesByMetaclass.length;
        int n2 = 0;
        while (n2 < n) {
            instancesForMetaclass = instancesForMetaclassArray[n2];
            instancesForMetaclass.clearSubclasses();
            ++n2;
        }
        instancesForMetaclassArray = instancesByMetaclass;
        n = instancesByMetaclass.length;
        n2 = 0;
        while (n2 < n) {
            instancesForMetaclass = instancesForMetaclassArray[n2];
            instancesForMetaclass.buildParentsSubclasses();
            if (instancesForMetaclass.getEClass().getESuperTypes().isEmpty()) {
                this.rootMetaclasses.add(instancesForMetaclass);
            }
            ++n2;
        }
    }

    public InstancesForMetaclass[] getRootMetaclasses() {
        return this.rootMetaclasses.toArray(new InstancesForMetaclass[this.rootMetaclasses.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void facetAdded(Facet facet) {
        ArrayList<Resource> resources;
        Set<Resource> set = this.fResources;
        synchronized (set) {
            resources = new ArrayList<Resource>(this.fResources);
        }
        InstancesForMetaclass instancesForMetaclass = new InstancesForMetaclass((EClass)facet, this, this.browserConfiguration, resources);
        TreeMap<EClass, InstancesForMetaclass> treeMap = this.modelElements;
        synchronized (treeMap) {
            this.modelElements.put((EClass)facet, instancesForMetaclass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void facetsCleared() {
        TreeMap<EClass, InstancesForMetaclass> treeMap = this.modelElements;
        synchronized (treeMap) {
            Iterator<EClass> iterator = this.modelElements.keySet().iterator();
            while (iterator.hasNext()) {
                EClass eClass = iterator.next();
                if (!(eClass instanceof Facet)) continue;
                iterator.remove();
            }
        }
    }

    public void addListener(MetaclassesChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(MetaclassesChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void notifyChanged() {
        for (MetaclassesChangeListener listener : this.listeners) {
            listener.modelChanged();
        }
    }

    public void modelChanged(Notification msg) {
        if (msg != null && msg.getEventType() == 9) {
            this.computeModelElements();
            this.buildDerivationTree();
        }
        this.notifyChanged();
    }

    public static interface MetaclassesChangeListener {
        public void modelChanged();
    }
}

