/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.monitoring.traceanalyser;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.polarsys.chess.monitoring.traceanalyser.Event;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TraceReader {
    private int time_Stamp_Column = 0;
    private int event_ID_Column = 1;
    private int thread_ID_Column = 2;
    private double clockrate = 1.0;
    private String traceFileName;
    private ArrayList<ArrayList<Event>> threadSpecificEvents;
    private ArrayList<String> threadIDs;
    private String analysisContext;

    public TraceReader(IFile traceFile, IFile threadIDsFile, String delimiter) {
        this.traceFileName = traceFile.getLocation().toOSString();
        this.analysisContext = this.GetAnalysisContext(threadIDsFile.getLocation().toOSString());
        this.threadIDs = new ArrayList();
        this.threadIDs = this.GetThreadIDs(threadIDsFile.getLocation().toOSString());
        if (this.threadIDs.size() == 0) {
            System.out.println("Error: No thread ID to analyze.");
            System.exit(0);
        }
        this.threadSpecificEvents = new ArrayList();
        int i = 0;
        while (i < this.threadIDs.size()) {
            this.threadSpecificEvents.add(new ArrayList());
            ++i;
        }
        this.ReadTraceFile(delimiter);
    }

    private String GetAnalysisContext(String fileName) {
        String analContext = null;
        try {
            File fXmlFile = new File(fileName);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(fXmlFile);
            doc.getDocumentElement().normalize();
            NodeList contexts = doc.getElementsByTagName("analysisContext");
            Node context = contexts.item(0);
            if (context.getNodeType() == 1) {
                Element elem = (Element)context;
                analContext = elem.getAttribute("name");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return analContext;
    }

    private ArrayList<String> GetThreadIDs(String fileName) {
        ArrayList<String> threadNames = new ArrayList<String>();
        try {
            File fXmlFile = new File(fileName);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(fXmlFile);
            doc.getDocumentElement().normalize();
            NodeList contexts = doc.getElementsByTagName("analysisContext");
            Node context = contexts.item(0);
            if (context.getNodeType() == 1) {
                Element elem = (Element)context;
                this.analysisContext = elem.getAttribute("name");
            }
            NodeList allthreads = doc.getElementsByTagName("ThreadNames");
            int i = 0;
            while (i < allthreads.getLength()) {
                Node thread = allthreads.item(i);
                if (thread.getNodeType() == 1) {
                    Element eElement = (Element)thread;
                    threadNames.add(eElement.getAttribute("name"));
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return threadNames;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void ReadTraceFile(String delimiter) {
        try {
            FileReader file = new FileReader(this.traceFileName);
            BufferedReader br = new BufferedReader(file);
            String strLine = br.readLine();
            boolean bl = true;
            do {
                String[] strEvent;
                if (bl && !(bl = false)) {
                    if (strLine == null) continue;
                    strEvent = (strLine = strLine.trim()).split(delimiter);
                    if (strEvent.length == 2 && strEvent[0].equals("clockrate")) {
                        this.clockrate = Double.parseDouble(strEvent[1]);
                        if (true) continue;
                    }
                    System.out.println("Error: clockrate is not specified in the trace file.");
                    br.close();
                    return;
                }
                if ((strEvent = (strLine = strLine.trim()).split(delimiter)).length != 3) {
                    System.out.println("Error: Some events do not follow the expected trace format.");
                    br.close();
                    return;
                }
                Event event = new Event(Long.parseLong(strEvent[this.time_Stamp_Column]), Integer.parseInt(strEvent[this.event_ID_Column]), strEvent[this.thread_ID_Column]);
                if (!this.threadIDs.contains(event.GetThreadID())) continue;
                this.threadSpecificEvents.get(this.threadIDs.indexOf(event.GetThreadID())).add(event);
            } while ((strLine = br.readLine()) != null);
            br.close();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void PrintThreadSpecificEvents(String tid) {
        int indexOfThread = this.threadIDs.indexOf(tid);
        System.out.println("Time Stamp \t EventID \t ThreadID");
        for (Event event : this.threadSpecificEvents.get(indexOfThread)) {
            System.out.println(String.valueOf(event.GetTimeStamp()) + "\t" + event.GetEventID() + "\t" + event.GetThreadID());
        }
    }

    public void WriteThreadSpecificEventsIntoFile(String tid) {
        int indexOfThread = this.threadIDs.indexOf(tid);
        try {
            FileWriter filewrite = new FileWriter(tid.concat(".txt"), false);
            BufferedWriter out = new BufferedWriter(filewrite);
            for (Event event : this.threadSpecificEvents.get(indexOfThread)) {
                out.write(String.valueOf(event.GetTimeStamp()) + "\t" + event.GetEventID() + "\t" + event.GetThreadID() + "\n");
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ArrayList<String> GetThreadIDs() {
        return this.threadIDs;
    }

    public String GetAnalysisContext() {
        return this.analysisContext;
    }

    public ArrayList<ArrayList<Event>> GetThreadSpecificEvents() {
        return this.threadSpecificEvents;
    }

    public String GetThreadIdOfGivenEvents(ArrayList<ArrayList<Integer>> eventsList) {
        if (this.threadSpecificEvents.contains(eventsList)) {
            return this.threadIDs.get(this.threadSpecificEvents.indexOf(eventsList));
        }
        return null;
    }

    public int GetThreadIDColumn() {
        return this.thread_ID_Column;
    }

    public int GetEventIDColumn() {
        return this.event_ID_Column;
    }

    public int GetTimeStampColumn() {
        return this.time_Stamp_Column;
    }

    public double GetClockRate() {
        return this.clockrate;
    }
}

