/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.stereotype.edition.editpolicies;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.SetNodeVisibilityCommand;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.GMFUnsafe;
import org.eclipse.papyrus.uml.appearance.helper.AppliedStereotypeHelper;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AppliedStereotypeNodeLabelDisplayEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.figure.node.IPapyrusNodeUMLElementFigure;
import org.eclipse.papyrus.uml.diagram.stereotype.edition.command.CreateAppliedStereotypeViewCommand;
import org.eclipse.papyrus.uml.diagram.stereotype.edition.editpart.AppliedStereotypeCompartmentEditPart;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;

public class AppliedStereotypeCompartmentEditPolicy
extends AppliedStereotypeNodeLabelDisplayEditPolicy {
    public void activate() {
        super.activate();
        Element umlElement = this.getUMLElement();
        if (umlElement != null) {
            for (EObject appliedstereotype : umlElement.getStereotypeApplications()) {
                this.createAppliedStereotypeCompartment(appliedstereotype);
            }
        }
    }

    protected boolean hasToDisplayCompartment(EObject applicationOfStereotype) {
        String stereotypesPropertiesToDisplay = AppliedStereotypeHelper.getAppliedStereotypesPropertiesToDisplay((EModelElement)((View)this.getHost().getModel()));
        String stereotypesLocalizationToDisplay = AppliedStereotypeHelper.getAppliedStereotypesPropertiesLocalization((EModelElement)((View)this.getHost().getModel()));
        if (!stereotypesLocalizationToDisplay.equals("Compartment")) {
            return false;
        }
        HashSet<Stereotype> stereoSet = new HashSet<Stereotype>();
        ArrayList<String> stPropList = new ArrayList<String>();
        StringTokenizer propStringTokenizer = new StringTokenizer(stereotypesPropertiesToDisplay, ",");
        while (propStringTokenizer.hasMoreElements()) {
            String propertyQN = propStringTokenizer.nextToken();
            String stereotypeQN = propertyQN.substring(0, propertyQN.indexOf("."));
            Stereotype stereotype = this.hostSemanticElement.getAppliedStereotype(stereotypeQN);
            if (stereotype != null) {
                stereoSet.add(stereotype);
            }
            stPropList.add(propertyQN);
        }
        for (Stereotype stereotype : stereoSet) {
            if (stereotype == null || !applicationOfStereotype.equals(this.hostSemanticElement.getStereotypeApplication(stereotype))) continue;
            return true;
        }
        return false;
    }

    protected void executeAppliedStereotypeCompatmentCreation(final GraphicalEditPart editPart, final EObject appliedstereotype) {
        try {
            editPart.getEditingDomain().runExclusive(new Runnable(){

                public void run() {
                    Display.getCurrent().syncExec(new Runnable(){

                        public void run() {
                            CreateAppliedStereotypeViewCommand command = new CreateAppliedStereotypeViewCommand(editPart.getEditingDomain(), editPart.getNotationView(), appliedstereotype, AppliedStereotypeCompartmentEditPolicy.this.hasToDisplayCompartment(appliedstereotype));
                            try {
                                GMFUnsafe.write((TransactionalEditingDomain)editPart.getEditingDomain(), (Command)command);
                            }
                            catch (Exception e) {
                                Activator.log.error((Throwable)e);
                            }
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
    }

    public void notifyChanged(Notification notification) {
        int eventType = notification.getEventType();
        if (eventType == 20) {
            this.getDiagramEventBroker().addNotificationListener((EObject)notification.getNewValue(), (NotificationListener)this);
            this.createAppliedStereotypeCompartment((EObject)notification.getNewValue());
        } else if (eventType == 21) {
            this.getDiagramEventBroker().removeNotificationListener((EObject)notification.getOldValue(), (NotificationListener)this);
            this.cleanStereotypeDisplayInEAnnotation();
            this.removeAppliedStereotypeCompartment((EObject)notification.getNewValue());
        }
        if (notification.getNotifier() instanceof Node && notification.getEventType() == 3 && notification.getNewValue() instanceof EAnnotation && "Stereotype_Annotation" == ((EAnnotation)notification.getNewValue()).getSource()) {
            this.refreshDisplay();
        }
        if (notification.getNotifier() instanceof EAnnotation && notification.getEventType() == 3 && "Stereotype_Annotation" == ((EAnnotation)notification.getNotifier()).getSource()) {
            this.refreshDisplay();
        }
    }

    public void createAppliedStereotypeCompartment(EObject stereotypeApplication) {
        GraphicalEditPart editPart = (GraphicalEditPart)this.getHost();
        View node = editPart.getNotationView();
        View correspondedAppliedStereotype = this.getCoresspondedStereotypeApplication(stereotypeApplication, node);
        if (correspondedAppliedStereotype == null) {
            this.executeAppliedStereotypeCompatmentCreation(editPart, stereotypeApplication);
        }
    }

    protected void setVisivility(final View view, final boolean isVisible) {
        try {
            final GraphicalEditPart editPart = (GraphicalEditPart)this.getHost();
            editPart.getEditingDomain().runExclusive(new Runnable(){

                public void run() {
                    SetNodeVisibilityCommand setCommand = new SetNodeVisibilityCommand(editPart.getEditingDomain(), view, Boolean.valueOf(isVisible));
                    try {
                        GMFUnsafe.write((TransactionalEditingDomain)editPart.getEditingDomain(), (Command)setCommand);
                    }
                    catch (Exception e) {
                        Activator.log.error((Throwable)e);
                    }
                }
            });
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
    }

    protected View getCoresspondedStereotypeApplication(EObject stereotypeApplication, View node) {
        Node correspondedAppliedStereotype = null;
        int i = 0;
        while (correspondedAppliedStereotype == null && i < node.getChildren().size()) {
            if (node.getChildren().get(i) instanceof Node && stereotypeApplication.equals(((Node)node.getChildren().get(i)).getElement())) {
                correspondedAppliedStereotype = (Node)node.getChildren().get(i);
            }
            ++i;
        }
        return correspondedAppliedStereotype;
    }

    public void removeAppliedStereotypeCompartment(EObject stereotypeApplication) {
        if (stereotypeApplication == null) {
            return;
        }
        final GraphicalEditPart editPart = (GraphicalEditPart)this.getHost();
        View node = editPart.getNotationView();
        try {
            int i = 0;
            while (i < node.getChildren().size()) {
                if (node.getChildren().get(i) instanceof Node) {
                    final Node currentNode = (Node)node.getChildren().get(i);
                    if (stereotypeApplication.equals(currentNode.getElement())) {
                        editPart.getEditingDomain().runExclusive(new Runnable(){

                            public void run() {
                                DeleteCommand command = new DeleteCommand((View)currentNode);
                                try {
                                    GMFUnsafe.write((TransactionalEditingDomain)editPart.getEditingDomain(), (ICommand)command);
                                }
                                catch (Exception e) {
                                    Activator.log.error((Throwable)e);
                                }
                            }
                        });
                    }
                    if (currentNode.getType().equals(AppliedStereotypeCompartmentEditPart.ID) && !(currentNode.getElement() instanceof DynamicEObjectImpl)) {
                        editPart.getEditingDomain().runExclusive(new Runnable(){

                            public void run() {
                                if (currentNode != null && editPart.getEditingDomain() != null) {
                                    DeleteCommand command = new DeleteCommand(editPart.getEditingDomain(), (View)currentNode);
                                    try {
                                        GMFUnsafe.write((TransactionalEditingDomain)editPart.getEditingDomain(), (ICommand)command);
                                    }
                                    catch (Exception e) {
                                        Activator.log.error((Throwable)e);
                                    }
                                }
                            }
                        });
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
    }

    protected void refreshAppliedStereotypesPropertiesInCompartment(String stereotypesPropertiesToDisplay, IPapyrusNodeUMLElementFigure figure) {
        boolean displayInCompartment = AppliedStereotypeHelper.hasAppliedStereotypesPropertiesToDisplay((EModelElement)((View)this.getHost().getModel()), (String)"Compartment");
        GraphicalEditPart editPart = (GraphicalEditPart)this.getHost();
        View node = editPart.getNotationView();
        int i = 0;
        while (i < node.getChildren().size()) {
            Node currentNode;
            if (node.getChildren().get(i) instanceof Node && (currentNode = (Node)node.getChildren().get(i)).getType().equals(AppliedStereotypeCompartmentEditPart.ID)) {
                EObject stereotypeApplication = currentNode.getElement();
                Stereotype stereotype = UMLUtil.getStereotype((EObject)stereotypeApplication);
                if (stereotype != null && stereotypesPropertiesToDisplay.contains(stereotype.getQualifiedName())) {
                    this.setVisivility((View)currentNode, displayInCompartment);
                } else {
                    this.setVisivility((View)currentNode, false);
                }
            }
            ++i;
        }
    }
}

