/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.handlers;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternLanguagePackage;
import org.eclipse.incquery.tooling.core.project.ProjectGenerationHelper;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.xbase.lib.Pair;

class NatureUpdaterJob
extends Job {
    private IProject project;
    @Inject
    private IResourceDescriptions index;

    public NatureUpdaterJob(IProject project) {
        super(String.format("Updating project %s", project.getName()));
        this.project = project;
    }

    private void repairErroneousBuilderEntry(IProject project) throws CoreException {
        IProjectDescription desc = project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals("org.eclipse.incquery.tooling.ui.projectbuilder")) {
                commands[i].setBuilderName("org.eclipse.incquery.tooling.core.projectbuilder");
            }
            ++i;
        }
        desc.setBuildSpec(commands);
        project.setDescription(desc, null);
    }

    private void reorderBuilderEntries(IProject project) throws CoreException {
        IProjectDescription desc = project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        int xtextIndex = -1;
        ICommand xtextCommand = null;
        int iqIndex = -1;
        ICommand iqCommand = null;
        int commandListSize = commands.length;
        int i = 0;
        while (i < commandListSize) {
            String id = commands[i].getBuilderName();
            if ("org.eclipse.incquery.tooling.core.projectbuilder".equals(id)) {
                iqIndex = i;
                iqCommand = commands[i];
            } else if ("org.eclipse.xtext.ui.shared.xtextBuilder".equals(id)) {
                xtextIndex = i;
                xtextCommand = commands[i];
            }
            ++i;
        }
        if (iqIndex < 0) {
            ++commandListSize;
            iqCommand = desc.newCommand();
            iqCommand.setBuilderName("org.eclipse.incquery.tooling.core.projectbuilder");
        }
        if (xtextIndex < 0) {
            ++commandListSize;
            xtextCommand = desc.newCommand();
            xtextCommand.setBuilderName("org.eclipse.xtext.ui.shared.xtextBuilder");
        }
        ICommand[] newCommands = new ICommand[commandListSize];
        newCommands[0] = iqCommand;
        newCommands[1] = xtextCommand;
        int commandIndex = 2;
        int i2 = 0;
        while (i2 < commands.length) {
            if (i2 != xtextIndex && i2 != iqIndex) {
                newCommands[commandIndex] = commands[i2];
                ++commandIndex;
            }
            ++i2;
        }
        desc.setBuildSpec(newCommands);
        project.setDescription(desc, null);
    }

    private void removeGlobalEiq(IProject project) throws CoreException {
        IResource globalEiqFile = project.findMember("queries/globalEiqModel.xmi");
        if (globalEiqFile != null) {
            IContainer parent = globalEiqFile.getParent();
            globalEiqFile.delete(true, null);
            if (parent.members().length == 0) {
                parent.delete(true, null);
            }
        }
    }

    public void removeExpressionExtensions(IProject project) throws CoreException {
        final IJavaProject javaProject = JavaCore.create((IProject)project);
        final ArrayList removableExtensions = Lists.newArrayList();
        project.accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (resource instanceof IContainer) {
                    IJavaElement element = JavaCore.create((IResource)resource, (IJavaProject)javaProject);
                    return element != null;
                }
                if ("eiq".equals(resource.getFileExtension())) {
                    IResourceDescription desc = NatureUpdaterJob.this.index.getResourceDescription(URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)true));
                    Iterable extensionHeaders = Iterables.transform((Iterable)desc.getExportedObjectsByType(PatternLanguagePackage.Literals.PATTERN), (Function)new Function<IEObjectDescription, Pair<String, String>>(){

                        public Pair<String, String> apply(IEObjectDescription desc) {
                            return new Pair((Object)desc.getQualifiedName().toString(), (Object)"org.eclipse.incquery.runtime.xexpressionevaluator");
                        }
                    });
                    removableExtensions.addAll(Lists.newArrayList((Iterable)extensionHeaders));
                }
                return false;
            }
        });
        ProjectGenerationHelper.removeAllExtension((IProject)project, (Collection)removableExtensions);
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            ImmutableList oldIDs;
            this.repairErroneousBuilderEntry(this.project);
            this.reorderBuilderEntries(this.project);
            ImmutableList newIDs = this.project.hasNature("org.eclipse.incquery.projectnature") ? ImmutableList.of() : ImmutableList.of((Object)"org.eclipse.incquery.projectnature");
            ImmutableList immutableList = oldIDs = this.project.hasNature("org.eclipse.viatra2.emf.incquery.projectnature") ? ImmutableList.of((Object)"org.eclipse.viatra2.emf.incquery.projectnature") : ImmutableList.of();
            if (newIDs.size() + oldIDs.size() > 0) {
                ProjectGenerationHelper.updateNatures((IProject)this.project, (Collection)newIDs, (Collection)oldIDs, (IProgressMonitor)monitor);
            }
            this.removeGlobalEiq(this.project);
            this.removeExpressionExtensions(this.project);
            ProjectGenerationHelper.ensurePackageImports((IProject)this.project, (List)ImmutableList.of((Object)"org.apache.log4j"));
        }
        catch (CoreException e) {
            return new Status(4, "org.eclipse.incquery.tooling.ui", "Error updating project natures", (Throwable)e);
        }
        return Status.OK_STATUS;
    }
}

