/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.fla.launch;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.notation.impl.DiagramImpl;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.sysml.diagram.internalblock.edit.part.InternalBlockDiagramEditPart;
import org.eclipse.papyrus.uml.diagram.clazz.part.UMLDiagramEditor;
import org.eclipse.papyrus.uml.diagram.composite.edit.parts.CompositeStructureDiagramEditPart;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.UMLPackage;
import org.polarsys.chess.core.notifications.ResourceNotification;
import org.polarsys.chess.core.util.CHESSProjectSupport;
import org.polarsys.chess.core.util.uml.ResourceUtils;
import org.polarsys.chess.core.views.DiagramStatus;
import org.polarsys.chess.fla.impl.FlaAnalysisRunner;
import org.polarsys.chess.fla.launch.Activator;
import org.polarsys.chess.service.utils.CHESSEditorUtils;

public class FlaAnalysisCommand
extends AbstractHandler {
    private IFile modelFile;
    private URI modelURI;
    protected List<IFile> files;
    List<? extends Object> arguments;
    private Model umlModel = null;
    private IContainer targetFolder;
    protected UMLDiagramEditor diagramEditor = null;
    protected DiagramEditPart diagramEditPart;
    protected PapyrusMultiDiagramEditor papyrusEditor;
    private static final String DI_SUFFIX = ".di";
    private static final String UML_SUFFIX = ".uml";
    public static final String COMMAND_ID = "org.polarsys.chess.fla.analysis.command";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        long startTime;
        block10: {
            DiagramStatus ds;
            PapyrusMultiDiagramEditor editor = CHESSEditorUtils.getCHESSEditor();
            Classifier rootComponent = this.getCurrentComponent(editor, ds = CHESSEditorUtils.getDiagramStatus((PapyrusMultiDiagramEditor)editor));
            if (rootComponent == null) {
                Status status = new Status(4, "org.polarsys.chess.fla", "Cannot identify root component");
                Activator.getDefault().getLog().log((IStatus)status);
                throw new ExecutionException("Error during FLA analysis");
            }
            IFileEditorInput input = (IFileEditorInput)editor.getEditorInput();
            IFile file = input.getFile();
            IProject activeProject = file.getProject();
            Path path = new Path(String.valueOf(activeProject.getName()) + "/" + this.changeSuffix(input.getFile().getName(), DI_SUFFIX, UML_SUFFIX));
            this.modelURI = URI.createPlatformResourceURI((String)this.changeSuffix(input.getFile().getFullPath().toString(), DI_SUFFIX, UML_SUFFIX), (boolean)true);
            this.modelFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            startTime = System.currentTimeMillis();
            Shell shell = new Shell();
            try {
                ds.setUserAction(false);
                ProgressMonitorDialog pmDialog = new ProgressMonitorDialog(shell);
                FlaAnalysisRunner analysisRunner = new FlaAnalysisRunner();
                analysisRunner.setModelURI(this.modelURI);
                this.targetFolder = this.modelFile.getProject().getFolder("FLA_Analysis");
                analysisRunner.setTargetFolder(this.targetFolder);
                analysisRunner.setDiagramEditPart(this.diagramEditPart);
                Resource resource = ResourceUtils.getUMLResource((ServicesRegistry)editor.getServicesRegistry());
                this.umlModel = (Model)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)UMLPackage.Literals.MODEL);
                analysisRunner.setRootComponent(rootComponent.getQualifiedName());
                analysisRunner.setChessResource(resource);
                pmDialog.run(true, true, (IRunnableWithProgress)analysisRunner);
                activeProject.refreshLocal(2, null);
            }
            catch (InvocationTargetException e) {
                Status status = new Status(4, "org.polarsys.chess.fla", e.getMessage(), (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
                throw new ExecutionException("Error during FLA analysis", (Throwable)e);
            }
            catch (CoreException e) {
                Status status = new Status(4, "org.polarsys.chess.fla", e.getMessage(), (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
                throw new ExecutionException("Error during FLA analysis", (Throwable)e);
            }
            catch (InterruptedException e) {
                Status status = new Status(4, "org.polarsys.chess.fla", e.getMessage(), (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
                ds.setUserAction(true);
                break block10;
            }
            catch (ServiceException e) {
                try {
                    Status status = new Status(4, "org.polarsys.chess.fla", e.getMessage(), (Throwable)e);
                    Activator.getDefault().getLog().log((IStatus)status);
                    break block10;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    ds.setUserAction(true);
                }
            }
            ds.setUserAction(true);
        }
        long endTime = System.currentTimeMillis();
        CHESSProjectSupport.printlnToCHESSConsole((String)("*** Elapsed time " + (double)(endTime - startTime) / 1000.0 + " s ***"));
        return null;
    }

    private String changeSuffix(String string, String oldSuffix, String newSuffix) {
        String newString = string;
        if (newString.endsWith(oldSuffix)) {
            newString = newString.substring(0, newString.length() - oldSuffix.length());
            newString = String.valueOf(newString) + newSuffix;
        }
        return newString;
    }

    private Classifier getCurrentComponent(PapyrusMultiDiagramEditor editor, DiagramStatus ds) {
        if (editor == null || ds == null) {
            return null;
        }
        Classifier rootComponent = null;
        try {
            DiagramEditPart csd_ep;
            Object editPart = this.getEditPart();
            if (editPart == null || !(editPart instanceof CompositeStructureDiagramEditPart) && !(editPart instanceof InternalBlockDiagramEditPart)) {
                throw new Exception("FLA analysis cannot be performed on this element");
            }
            this.diagramEditPart = csd_ep = (DiagramEditPart)editPart;
            DiagramImpl diagram = (DiagramImpl)csd_ep.getModel();
            rootComponent = (Classifier)diagram.getElement();
        }
        catch (Exception e) {
            e.printStackTrace();
            ResourceNotification.showInfo((String)e.getMessage());
        }
        return rootComponent;
    }

    private Object getEditPart() {
        Object ep = null;
        try {
            ep = CHESSEditorUtils.getDiagramGraphicalViewer().getRootEditPart().getChildren().get(0);
        }
        catch (Exception exception) {
            return null;
        }
        return ep;
    }
}

