/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.emf.validation.validity.ui.view;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.ocl.examples.emf.validation.validity.AbstractNode;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ValidityModel;
import org.eclipse.ocl.examples.emf.validation.validity.ui.view.ValidityView;
import org.eclipse.swt.widgets.Tree;

public class ValidityViewRefreshJob
extends Job {
    private Set<AbstractNode> refreshQueue = new HashSet<AbstractNode>();
    private ValidityView validityView = null;
    private CheckboxTreeViewer validatableNodesViewer = null;
    private CheckboxTreeViewer constrainingNodesViewer = null;
    private DisplayRefresh displayRefresh = null;

    public ValidityViewRefreshJob() {
        super("Validation View Refresh");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@Nullable AbstractNode node) {
        Set<AbstractNode> set = this.refreshQueue;
        synchronized (set) {
            if (this.refreshQueue.isEmpty()) {
                this.schedule(250L);
            }
            if (node != null) {
                this.refreshQueue.add(node);
            }
        }
    }

    public void initViewers(@NonNull ValidityView validityView, @NonNull CheckboxTreeViewer validatableNodesViewer, @NonNull CheckboxTreeViewer constrainingNodesViewer) {
        this.validityView = validityView;
        this.validatableNodesViewer = validatableNodesViewer;
        this.constrainingNodesViewer = constrainingNodesViewer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        if (this.displayRefresh != null) {
            return Status.CANCEL_STATUS;
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (this.validatableNodesViewer == null || this.constrainingNodesViewer == null) {
            return Status.CANCEL_STATUS;
        }
        ValidityModel model = this.validityView.getValidityManager().getModel();
        if (model == null) {
            return Status.CANCEL_STATUS;
        }
        Set<AbstractNode> set = this.refreshQueue;
        synchronized (set) {
            this.refreshQueue.clear();
        }
        ArrayList<AbstractNode> grayedValidatableNodes = new ArrayList<AbstractNode>();
        ArrayList<AbstractNode> grayedConstrainingNodes = new ArrayList<AbstractNode>();
        model.refreshModel(grayedValidatableNodes, grayedConstrainingNodes);
        this.displayRefresh = new DisplayRefresh(monitor, grayedValidatableNodes, grayedConstrainingNodes);
        Tree tree = this.validatableNodesViewer.getTree();
        if (!tree.isDisposed()) {
            tree.getDisplay().asyncExec((Runnable)this.displayRefresh);
        }
        return Status.OK_STATUS;
    }

    private class DisplayRefresh
    implements Runnable {
        @Nullable
        protected final IProgressMonitor monitor;
        @Nullable
        private final AbstractNode[] grayedValidatableNodes;
        @Nullable
        private final AbstractNode[] grayedConstrainingNodes;

        public DisplayRefresh(@Nullable IProgressMonitor monitor, @Nullable List<AbstractNode> grayedValidatableNodes, List<AbstractNode> grayedConstrainingNodes) {
            this.monitor = monitor;
            this.grayedValidatableNodes = grayedValidatableNodes != null ? grayedValidatableNodes.toArray(new AbstractNode[grayedValidatableNodes.size()]) : null;
            this.grayedConstrainingNodes = grayedConstrainingNodes != null ? grayedConstrainingNodes.toArray(new AbstractNode[grayedConstrainingNodes.size()]) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            assert (this.monitor != null);
            try {
                Monitor emfMonitor = BasicMonitor.toMonitor((IProgressMonitor)this.monitor);
                if (!emfMonitor.isCanceled()) {
                    ValidityViewRefreshJob.this.constrainingNodesViewer.refresh();
                }
                if (!emfMonitor.isCanceled()) {
                    ValidityViewRefreshJob.this.validatableNodesViewer.refresh();
                }
                if (!emfMonitor.isCanceled() && this.grayedConstrainingNodes != null) {
                    ValidityViewRefreshJob.this.constrainingNodesViewer.setGrayedElements((Object[])this.grayedConstrainingNodes);
                }
                if (!emfMonitor.isCanceled() && this.grayedValidatableNodes != null) {
                    ValidityViewRefreshJob.this.validatableNodesViewer.setGrayedElements((Object[])this.grayedValidatableNodes);
                }
            }
            catch (Throwable throwable) {
                ValidityViewRefreshJob.this.displayRefresh = null;
                Set set = ValidityViewRefreshJob.this.refreshQueue;
                synchronized (set) {
                    if (!ValidityViewRefreshJob.this.refreshQueue.isEmpty()) {
                        ValidityViewRefreshJob.this.schedule(2500L);
                    }
                }
                throw throwable;
            }
            ValidityViewRefreshJob.this.displayRefresh = null;
            Set set = ValidityViewRefreshJob.this.refreshQueue;
            synchronized (set) {
                if (!ValidityViewRefreshJob.this.refreshQueue.isEmpty()) {
                    ValidityViewRefreshJob.this.schedule(2500L);
                }
            }
        }
    }
}

