/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.emf.validation.validity.ui.view;

import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.emf.validation.validity.AbstractNode;
import org.eclipse.ocl.examples.emf.validation.validity.ConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.Result;
import org.eclipse.ocl.examples.emf.validation.validity.Severity;
import org.eclipse.ocl.examples.emf.validation.validity.ValidatableNode;
import org.eclipse.ocl.examples.emf.validation.validity.ui.plugin.ValidityUIPlugin;
import org.eclipse.ocl.examples.emf.validation.validity.ui.view.IDEValidityManager;
import org.eclipse.ocl.examples.emf.validation.validity.ui.view.SideBySideImageDecorator;
import org.eclipse.swt.graphics.Image;

public class SeveritiesDecorator
extends SideBySideImageDecorator {
    @NonNull
    protected final IDEValidityManager validityManager;

    public static Object getSeverityImage(Object element) {
        String imageName = "query.gif";
        Result worstResult = ((AbstractNode)element).getWorstResult();
        Severity worst = worstResult != null ? worstResult.getSeverity() : Severity.UNKNOWN;
        switch (worst) {
            case UNKNOWN: {
                imageName = "disabled_ovr.gif";
                break;
            }
            case OK: {
                imageName = "success_ovr.gif";
                break;
            }
            case INFO: {
                imageName = "info_ovr.gif";
                break;
            }
            case WARNING: {
                imageName = "warning_ovr.gif";
                break;
            }
            case ERROR: {
                imageName = "error_ovr.gif";
                break;
            }
            case FATAL: {
                imageName = "failed_ovr.gif";
                break;
            }
            default: {
                imageName = "unknown_ovr.gif";
            }
        }
        Object image2 = ValidityUIPlugin.INSTANCE.getImage(imageName);
        return image2;
    }

    public SeveritiesDecorator(@NonNull IDEValidityManager validityManager) {
        super(1);
        this.validityManager = validityManager;
    }

    public Image decorateImage(Image image, Object element) {
        Object image2 = SeveritiesDecorator.getSeverityImage(element);
        return this.composeImages(image, image2);
    }

    public List<Result> getResults(Object element) {
        if (element instanceof ConstrainingNode) {
            return this.validityManager.getConstrainingNodeResults((ConstrainingNode)element);
        }
        if (element instanceof ValidatableNode) {
            return this.validityManager.getValidatableNodeResults((ValidatableNode)element);
        }
        return Collections.emptyList();
    }
}

