/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.emf.validation.validity.ui.actions;

import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ocl.examples.emf.validation.validity.RootNode;
import org.eclipse.ocl.examples.emf.validation.validity.export.IValidityExporter;
import org.eclipse.ocl.examples.emf.validation.validity.export.IValidityExporterDescriptor;
import org.eclipse.ocl.examples.emf.validation.validity.export.ValidityExporterRegistry;
import org.eclipse.ocl.examples.emf.validation.validity.ui.messages.ValidityUIMessages;
import org.eclipse.ocl.examples.emf.validation.validity.ui.plugin.ValidityUIPlugin;
import org.eclipse.ocl.examples.emf.validation.validity.ui.view.IDEValidityManager;
import org.eclipse.ocl.examples.emf.validation.validity.ui.view.ValidityView;
import org.eclipse.ocl.examples.emf.validation.validity.ui.wizards.ExportValidationResultsFileWizard;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public final class ExportValidationResultAction
extends Action
implements IMenuCreator {
    @NonNull
    private final IDEValidityManager validityManager;
    @NonNull
    private final ValidityView validityView;
    private MenuManager menuManager = new MenuManager();

    public ExportValidationResultAction(@NonNull IDEValidityManager validityManager, @NonNull ValidityView validityView) {
        super(ValidityUIMessages.ValidityView_Action_ExportResult_Title);
        this.validityManager = validityManager;
        this.validityView = validityView;
        URL image = (URL)ValidityUIPlugin.INSTANCE.getImage(ValidityUIMessages.ValidityView_Action_ExportResult_ImageLocation);
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)image));
        if (ValidityExporterRegistry.INSTANCE.getRegisteredExtensions().isEmpty()) {
            this.setToolTipText(ValidityUIMessages.ValidityView_Action_ExportResult_ToolTipText_NoExporter);
        } else {
            this.setToolTipText(ValidityUIMessages.ValidityView_Action_ExportResult_ToolTipText_NeedsRun);
            this.setMenuCreator(this);
        }
    }

    public void dispose() {
        if (this.menuManager.getMenu() != null) {
            this.menuManager.getMenu().dispose();
        }
        this.menuManager.dispose();
    }

    public Menu getMenu(Control parent) {
        if (this.menuManager.getMenu() == null) {
            this.menuManager.createContextMenu(parent);
        } else {
            this.menuManager.removeAll();
        }
        for (IValidityExporterDescriptor descriptor : ValidityExporterRegistry.INSTANCE.getRegisteredExtensions()) {
            if (descriptor == null) continue;
            SpecificExportResultsAction exportAction = new SpecificExportResultsAction(descriptor);
            this.menuManager.add((IContributionItem)new ActionContributionItem((IAction)exportAction));
        }
        return this.menuManager.getMenu();
    }

    public Menu getMenu(Menu parent) {
        if (this.menuManager.getMenu() != null) {
            return this.menuManager.getMenu();
        }
        return null;
    }

    private final class SpecificExportResultsAction
    extends Action {
        @NonNull
        private final IValidityExporterDescriptor exportDescriptor;

        public SpecificExportResultsAction(IValidityExporterDescriptor exportDescriptor) {
            super(ValidityUIMessages.ValidityView_Action_ExportResult_Title, 2);
            this.exportDescriptor = exportDescriptor;
            this.setText(exportDescriptor.getExporterType());
            this.setToolTipText(ValidityUIMessages.ValidityView_Action_ExportResult_ToolTipText);
        }

        public void run() {
            ISelection selection2;
            ISelectionProvider selectionProvider;
            IWorkbenchPage page = ExportValidationResultAction.this.validityView.getSite().getPage();
            IStructuredSelection selection = null;
            IEditorPart editorPart = page.getActiveEditor();
            if (editorPart.getSite() != null && (selectionProvider = editorPart.getSite().getSelectionProvider()) != null && !(selection2 = selectionProvider.getSelection()).isEmpty() && selection2 instanceof IStructuredSelection) {
                selection = (IStructuredSelection)selection2;
            }
            if (selection != null) {
                try {
                    this.openExportWizard(selection);
                }
                catch (CoreException e) {
                    ValidityUIPlugin.getPlugin().getLog().log(e.getStatus());
                }
            }
        }

        private void openExportWizard(final @NonNull IStructuredSelection currentSelection) throws CoreException {
            final IWorkbenchWindow window = ExportValidationResultAction.this.validityView.getSite().getWorkbenchWindow();
            Shell shell = window.getShell();
            if (shell != null && !shell.isDisposed() && window.getWorkbench() != null) {
                Display display = shell.getDisplay();
                final IWorkbench workbench = window.getWorkbench();
                final RootNode rootNode = ExportValidationResultAction.this.validityManager.getRootNode();
                if (display != null && workbench != null && rootNode != null) {
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            IValidityExporter exporter = SpecificExportResultsAction.this.exportDescriptor.getExporter();
                            if (exporter == null) {
                                return;
                            }
                            Shell shell = window.getShell();
                            if (shell.isDisposed()) {
                                return;
                            }
                            ExportValidationResultsFileWizard wizard = new ExportValidationResultsFileWizard(workbench, currentSelection, rootNode, exporter);
                            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                            if (dialog.open() != 0) {
                                return;
                            }
                        }
                    });
                }
            }
        }
    }
}

