/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.emf.validation.validity.ui.actions;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.emf.validation.validity.AbstractNode;
import org.eclipse.ocl.examples.emf.validation.validity.RootNode;
import org.eclipse.ocl.examples.emf.validation.validity.ui.actions.AbstractFilterAction;
import org.eclipse.ocl.examples.emf.validation.validity.ui.messages.ValidityUIMessages;
import org.eclipse.ocl.examples.emf.validation.validity.ui.view.ValidityView;

public final class EnableDisableAllNodesAction
extends AbstractFilterAction {
    private final boolean enableAll;

    public EnableDisableAllNodesAction(@NonNull ValidityView validityView, boolean enableAll, boolean isValidatableFilterAction) {
        super(enableAll ? ValidityUIMessages.ValidityView_Action_SelectAllNodes_Title : ValidityUIMessages.ValidityView_Action_DeselectAllNodes_Title, 0, validityView, isValidatableFilterAction);
        this.enableAll = enableAll;
        this.setToolTipText(isValidatableFilterAction ? (enableAll ? ValidityUIMessages.ValidityView_Action_SelectAllValidatableNodes_ToolTipText : ValidityUIMessages.ValidityView_Action_DeselectAllValidatableNodes_ToolTipText) : (enableAll ? ValidityUIMessages.ValidityView_Action_SelectAllConstrainingNodes_ToolTipText : ValidityUIMessages.ValidityView_Action_DeselectAllConstrainingNodes_ToolTipText));
        this.setImage(enableAll ? ValidityUIMessages.ValidityView_Action_SelectAllNodes_ImageLocation : ValidityUIMessages.ValidityView_Action_DeselectAllNodes_ImageLocation);
    }

    public void run() {
        RootNode rootNode;
        if (this.isEnabled() && (rootNode = this.validityView.getValidityManager().getRootNode()) != null) {
            this.updateAll((Iterable<? extends AbstractNode>)(this.isValidatableAction ? rootNode.getValidatableNodes() : rootNode.getConstrainingNodes()));
            this.validityView.redraw();
        }
    }

    protected void updateAll(@NonNull Iterable<? extends AbstractNode> nodes) {
        for (AbstractNode abstractNode : nodes) {
            abstractNode.setEnabled(this.enableAll);
            this.updateAll((Iterable<? extends AbstractNode>)abstractNode.getChildren());
        }
    }
}

