/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.multicore.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.papyrus.MARTE.MARTE_DesignModel.HLAM.CallConcurrencyKind;
import org.eclipse.papyrus.MARTE.MARTE_DesignModel.HRM.HwLogical.HwDevice.HwDevice;
import org.eclipse.papyrus.MARTE.MARTE_Foundations.Alloc.Assign;
import org.eclipse.papyrus.MARTE.MARTE_Foundations.NFPs.NfpConstraint;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.CallOperationAction;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.polarsys.chess.chessmlprofile.ComponentModel.ComponentImplementation;
import org.polarsys.chess.chessmlprofile.ComponentModel.FunctionalPartition;
import org.polarsys.chess.chessmlprofile.Core.CHESS;
import org.polarsys.chess.chessmlprofile.Core.CHGaResourcePlatform;
import org.polarsys.chess.chessmlprofile.Core.FunctionalPartitions;
import org.polarsys.chess.chessmlprofile.Predictability.DeploymentConfiguration.HardwareBaseline.CH_HwProcessor;
import org.polarsys.chess.chessmlprofile.Predictability.RTComponentModel.CHRtPortSlot;
import org.polarsys.chess.chessmlprofile.Predictability.RTComponentModel.CHRtSpecification;
import org.polarsys.chess.core.profiles.CHESSProfileManager;
import org.polarsys.chess.core.util.uml.ModelError;
import org.polarsys.chess.core.util.uml.UMLUtils;
import org.polarsys.chess.multicore.model.CHCore;
import org.polarsys.chess.multicore.model.CHTask;
import org.polarsys.chess.multicore.utils.InstanceQuery;
import org.polarsys.chess.validator.constraints.StringParser;

public class QueryUtils {
    private static final String MARTE_ASSIGN = "MARTE::MARTE_Foundations::Alloc::Assign";
    private static final String MARTE_NFPCONSTRAINT = "MARTE::MARTE_Foundations::NFPs::NfpConstraint";
    public static final int COMPONENT_TO_PARTITION = 0;
    public static final int PARTITION_TO_CORE = 1;
    public static final int COMPONENT_TO_CORE = 2;
    public static final int TASK_TO_CORE = 3;

    public static CHESS getCHESS(Model umlModel) {
        return (CHESS)UMLUtils.getStereotypeApplication((Element)umlModel, CHESS.class);
    }

    public static CommandStack getCommandStack(Model umlModel) {
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)umlModel);
        return editingDomain.getCommandStack();
    }

    public static Component getPartitionsComponent(Model umlModel) throws ModelError {
        CHESS chess = QueryUtils.getCHESS(umlModel);
        Package componentViewP = chess.getComponentView().getBase_Package();
        for (Element el : componentViewP.allOwnedElements()) {
            if (!(el instanceof Component)) continue;
            Component c = (Component)el;
            boolean b = c.getName().equalsIgnoreCase("Partitions");
            boolean bl = b = b || UMLUtils.getStereotypeApplication((Element)el, FunctionalPartitions.class) != null;
            if (!b) continue;
            return c;
        }
        throw new ModelError("Partitions component not found.");
    }

    public static LinkedHashSet<Object> getComponentsAssigned2Partition(InstanceSpecification partition, EList<Assign> assignments) {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        for (Assign theAssignment : assignments) {
            if (theAssignment == null) continue;
            try {
                if (!theAssignment.getTo().contains((Object)partition) || !QueryUtils.elementIsComponentInstance((Element)theAssignment.getFrom().get(0))) continue;
                result.add(theAssignment.getFrom().get(0));
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public static void deleteAssociations(Component parent, int associationType) {
        Object[] objectArray = parent.getOwnedComments().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object el = objectArray[n2];
            if (el instanceof Comment) {
                Comment assignComment = (Comment)el;
                Assign assign = (Assign)UMLUtils.getStereotypeApplication((Element)assignComment, Assign.class);
                try {
                    if (assign != null && associationType == 1 && QueryUtils.elementIsPartitionInstance((Element)assign.getFrom().get(0)) || assign != null && associationType == 2 && QueryUtils.elementIsComponentInstance((Element)assign.getFrom().get(0)) && QueryUtils.elementIsProcessorInstance((Element)assign.getTo().get(0)) || assign != null && associationType == 3 && QueryUtils.elementIsSlotInstance((Element)assign.getFrom().get(0)) && QueryUtils.elementIsProcessorInstance((Element)assign.getTo().get(0)) || assign != null && associationType == 0 && QueryUtils.elementIsComponentInstance((Element)assign.getFrom().get(0)) && QueryUtils.elementIsPartitionInstance((Element)assign.getTo().get(0))) {
                        if (assign != null && assign.getImpliedConstraint().size() > 0) {
                            Object[] objectArray2 = assign.getImpliedConstraint().toArray();
                            int n3 = objectArray2.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                Object c = objectArray2[n4];
                                if (c instanceof NfpConstraint) {
                                    NfpConstraint n5 = (NfpConstraint)c;
                                    n5.getBase_Constraint().destroy();
                                }
                                ++n4;
                            }
                        }
                        assignComment.destroy();
                    }
                }
                catch (Exception exception) {
                    assignComment.destroy();
                }
            }
            ++n2;
        }
    }

    public static CHTask getTaskFromSlot(Element element) {
        if (!(element instanceof Slot)) {
            return null;
        }
        Slot slot = (Slot)element;
        CHRtPortSlot chSlot = (CHRtPortSlot)UMLUtils.getStereotypeApplication((Element)slot, CHRtPortSlot.class);
        if (chSlot == null) {
            return null;
        }
        EList chSpecs = chSlot.getCH_RtSpecification();
        for (CHRtSpecification chRtSpecification : chSpecs) {
            String occKind = chRtSpecification.getOccKind();
            if (occKind == null || !QueryUtils.isOccKindSporadicOrPeriodic(occKind)) continue;
            return new CHTask(chSlot, chRtSpecification);
        }
        return null;
    }

    private static EList<CHTask> getAllTasksFromSlot(Element element) {
        BasicEList chTaskList = new BasicEList();
        if (!(element instanceof Slot)) {
            return chTaskList;
        }
        Slot slot = (Slot)element;
        CHRtPortSlot chSlot = (CHRtPortSlot)UMLUtils.getStereotypeApplication((Element)slot, CHRtPortSlot.class);
        if (chSlot == null) {
            return chTaskList;
        }
        EList chSpecs = chSlot.getCH_RtSpecification();
        for (CHRtSpecification chRtSpecification : chSpecs) {
            String occKind = chRtSpecification.getOccKind();
            if (occKind == null || !QueryUtils.isOccKindSporadicOrPeriodic(occKind)) continue;
            chTaskList.add((Object)new CHTask(chSlot, chRtSpecification));
        }
        return chTaskList;
    }

    public static boolean elementIsSlotInstance(Element element) {
        return element instanceof Slot;
    }

    public static void buildComponent2PartitionAssignment(Component parent, Map<InstanceSpecification, LinkedHashSet<Object>> result) {
        System.out.println(parent.getQualifiedName());
        for (InstanceSpecification partitionInst : result.keySet()) {
            System.out.println(partitionInst.getName());
            for (Object e : result.get(partitionInst)) {
                if (!(e instanceof InstanceSpecification)) continue;
                InstanceSpecification componentInst = (InstanceSpecification)e;
                System.out.println(componentInst.getName());
                Comment c = parent.createOwnedComment();
                UMLUtils.applyStereotype((Element)c, (String)MARTE_ASSIGN);
                Assign assign = (Assign)UMLUtils.getStereotypeApplication((Element)c, Assign.class);
                assign.getFrom().add((Object)componentInst);
                assign.getTo().add((Object)partitionInst);
            }
        }
    }

    public static String buildCoreName(int coreNumber) {
        return "core" + coreNumber;
    }

    public static void buildPartition2CoreAssignments(Component parent, Map<CHCore, LinkedHashSet<Object>> result) {
        for (CHCore core : result.keySet()) {
            for (Object e : result.get(core)) {
                if (!(e instanceof InstanceSpecification)) continue;
                InstanceSpecification partitionInst = (InstanceSpecification)e;
                Comment c = parent.createOwnedComment();
                UMLUtils.applyStereotype((Element)c, (String)MARTE_ASSIGN);
                Assign assign = (Assign)UMLUtils.getStereotypeApplication((Element)c, Assign.class);
                assign.getFrom().add((Object)partitionInst);
                assign.getTo().add((Object)core.getProcessorInstance());
                Constraint n = parent.createOwnedRule(core.getName());
                UMLUtils.applyStereotype((Element)n, (String)MARTE_NFPCONSTRAINT);
                NfpConstraint rule = (NfpConstraint)UMLUtils.getStereotypeApplication((Element)n, NfpConstraint.class);
                ValueSpecification valueSpec = n.createSpecification("core", null, UMLPackage.Literals.LITERAL_STRING);
                LiteralString value = (LiteralString)valueSpec;
                value.setValue(core.getName());
                assign.getImpliedConstraint().add((Object)rule);
            }
        }
    }

    public static Package getOneResourcePlatformPackage(Package cmpv) {
        LinkedList<Package> breadthFirstList = new LinkedList<Package>();
        breadthFirstList.addFirst(cmpv);
        while (!breadthFirstList.isEmpty()) {
            Package candidate = (Package)breadthFirstList.poll();
            CHGaResourcePlatform a = (CHGaResourcePlatform)UMLUtils.getStereotypeApplication((Element)candidate, CHGaResourcePlatform.class);
            if (a != null) {
                return candidate;
            }
            for (Package p : candidate.getNestedPackages()) {
                breadthFirstList.addLast(p);
            }
        }
        return null;
    }

    @Deprecated
    public static Package getResourcePlatformPackage(Package cmpv) {
        LinkedList<Package> breadthFirstList = new LinkedList<Package>();
        breadthFirstList.addFirst(cmpv);
        while (!breadthFirstList.isEmpty()) {
            Package candidate = (Package)breadthFirstList.poll();
            CHGaResourcePlatform a = (CHGaResourcePlatform)UMLUtils.getStereotypeApplication((Element)candidate, CHGaResourcePlatform.class);
            if (a != null) {
                return candidate;
            }
            for (Package p : candidate.getNestedPackages()) {
                breadthFirstList.addLast(p);
            }
        }
        return null;
    }

    public static EList<Package> getResourcePlatformPackages(Model umlModel, String viewName) throws ModelError {
        Package pack = CHESSProfileManager.getViewByStereotype((Model)umlModel, (String)viewName);
        if (pack == null) {
            throw new ModelError(String.valueOf(viewName) + " not found.");
        }
        BasicEList result = new BasicEList();
        LinkedList<Package> breadthFirstList = new LinkedList<Package>();
        breadthFirstList.addFirst(pack);
        while (!breadthFirstList.isEmpty()) {
            Package candidate = (Package)breadthFirstList.poll();
            CHGaResourcePlatform a = (CHGaResourcePlatform)UMLUtils.getStereotypeApplication((Element)candidate, CHGaResourcePlatform.class);
            if (a != null) {
                result.add((Object)candidate);
            }
            for (Package p : candidate.getNestedPackages()) {
                breadthFirstList.addLast(p);
            }
        }
        return result;
    }

    public static List<Package> getResourcePlatformPackages(Package cmpv) {
        ArrayList<Package> candidates = new ArrayList<Package>();
        LinkedList<Package> breadthFirstList = new LinkedList<Package>();
        breadthFirstList.addFirst(cmpv);
        while (!breadthFirstList.isEmpty()) {
            Package candidate = (Package)breadthFirstList.poll();
            CHGaResourcePlatform a = (CHGaResourcePlatform)UMLUtils.getStereotypeApplication((Element)candidate, CHGaResourcePlatform.class);
            if (a != null) {
                candidates.add(candidate);
            }
            for (Package p : candidate.getNestedPackages()) {
                breadthFirstList.addLast(p);
            }
        }
        return candidates;
    }

    public static Component getResourcePlatformComponent(Model umlModel, String viewName) throws ModelError {
        Package parent = CHESSProfileManager.getViewByStereotype((Model)umlModel, (String)viewName);
        if (parent == null) {
            throw new ModelError(String.valueOf(viewName) + " not found.");
        }
        LinkedList<Element> breadthFirstList = new LinkedList<Element>();
        breadthFirstList.addAll((Collection<Element>)parent.getOwnedElements());
        while (!breadthFirstList.isEmpty()) {
            Component candidate;
            CHGaResourcePlatform a;
            Element t = (Element)breadthFirstList.poll();
            if (t instanceof Component && (a = (CHGaResourcePlatform)UMLUtils.getStereotypeApplication((Element)(candidate = (Component)t), CHGaResourcePlatform.class)) != null) {
                return candidate;
            }
            for (Element e : t.getOwnedElements()) {
                breadthFirstList.addLast(e);
            }
        }
        throw new ModelError("CHGaResourcePlatform not found in " + viewName + " view.");
    }

    public static boolean isPartitionInstance(InstanceSpecification e) {
        for (Classifier c : e.getClassifiers()) {
            if (UMLUtils.getStereotypeApplication((Element)c, FunctionalPartition.class) == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isComponentInstance(InstanceSpecification e) {
        for (Classifier c : e.getClassifiers()) {
            if (UMLUtils.getStereotypeApplication((Element)c, ComponentImplementation.class) == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isGuarded(CHRtSpecification spec) {
        return spec.getProtection().getName().equals(CallConcurrencyKind.GUARDED.getName());
    }

    public static boolean isOccKindSporadicOrPeriodic(String occKind) {
        if (occKind == null) {
            return false;
        }
        return QueryUtils.isOccKindSporadic(occKind) || QueryUtils.isOccKindPeriodic(occKind);
    }

    public static boolean isOccKindSporadic(String occKind) {
        String t = occKind.toLowerCase();
        return t.matches(".*sporadic.*");
    }

    public static boolean isOccKindPeriodic(String occKind) {
        String t = occKind.toLowerCase();
        return t.matches(".*periodic.*");
    }

    public static OccKindInfo getOccKindInfo(String occKind) {
        StringParser sp = new StringParser();
        OccKindInfo info = new OccKindInfo();
        if (QueryUtils.isOccKindSporadic(occKind)) {
            info.value = sp.getValuePattern(occKind, "minInterarrival");
            info.type = "sporadic";
            info.unit = sp.getUnitPattern(occKind, "minInterarrival");
        } else if (occKind.toLowerCase().matches(".*periodic.*")) {
            info.value = sp.getValuePattern(occKind, "period");
            info.unit = sp.getUnitPattern(occKind, "period");
            info.type = "periodic";
        } else {
            return null;
        }
        return info;
    }

    public static Map<InstanceSpecification, Set<CHRtSpecification>> buildPartitionComponentMap(Model umlModel, Package parent) throws ModelError {
        HashMap<InstanceSpecification, Set<CHRtSpecification>> map = new HashMap<InstanceSpecification, Set<CHRtSpecification>>();
        EList assignmentList = UMLUtils.getComponent2PartitionAssignments((Model)umlModel, (String)"ComponentView");
        if (!assignmentList.isEmpty()) {
            for (Assign assign : assignmentList) {
                if (assign == null) continue;
                for (Element i : assign.getFrom()) {
                    if (!(i instanceof InstanceSpecification)) continue;
                    InstanceSpecification ii = (InstanceSpecification)i;
                    QueryUtils.processComponentInstance(map, assign, ii);
                }
            }
        }
        return map;
    }

    public static Map<String, Set<InstanceSpecification>> buildPartitionCoreMap(Model umlModel) throws ModelError {
        HashMap<String, Set<InstanceSpecification>> map = new HashMap<String, Set<InstanceSpecification>>();
        EList assignmentList = UMLUtils.getPartition2CoreAssignments((Model)umlModel, (String)"DeploymentView");
        if (!assignmentList.isEmpty()) {
            for (Assign assign : assignmentList) {
                for (Element i : assign.getFrom()) {
                    if (!(i instanceof InstanceSpecification)) continue;
                    QueryUtils.processPartitionInstance(map, assign);
                }
            }
        }
        return map;
    }

    private static void processPartitionInstance(Map<String, Set<InstanceSpecification>> map, Assign assign) {
        try {
            if (assign.getImpliedConstraint().size() > 0) {
                Object[] objectArray = assign.getImpliedConstraint().toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ValueSpecification x;
                    Object c = objectArray[n2];
                    if (c instanceof NfpConstraint && (x = ((NfpConstraint)c).getBase_Constraint().getSpecification()) instanceof LiteralString) {
                        LiteralString s = (LiteralString)x;
                        String coreName = String.valueOf(((NamedElement)assign.getTo().get(0)).getName()) + s.getValue();
                        InstanceSpecification part = (InstanceSpecification)assign.getFrom().get(0);
                        Set<InstanceSpecification> value = map.get(coreName);
                        if (value == null) {
                            value = new HashSet<InstanceSpecification>();
                        }
                        value.add(part);
                        map.put(coreName, value);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void processComponentInstance(Map<InstanceSpecification, Set<CHRtSpecification>> map, Assign assign, InstanceSpecification instanceSpec) {
        for (Element element : instanceSpec.getOwnedElements()) {
            Slot slot;
            CHRtPortSlot chSlot;
            if (!(element instanceof Slot) || (chSlot = (CHRtPortSlot)UMLUtils.getStereotypeApplication((Element)(slot = (Slot)element), CHRtPortSlot.class)) == null) continue;
            EList chSpecs = chSlot.getCH_RtSpecification();
            QueryUtils.addToMap(map, (EList<Element>)assign.getTo(), (EList<CHRtSpecification>)chSpecs);
        }
    }

    private static void addToMap(Map<InstanceSpecification, Set<CHRtSpecification>> map, EList<Element> to, EList<CHRtSpecification> chSpecs) {
        for (Element partition : to) {
            if (!(partition instanceof InstanceSpecification)) continue;
            InstanceSpecification p = (InstanceSpecification)partition;
            for (CHRtSpecification chRtSpecification : chSpecs) {
                String occKind = chRtSpecification.getOccKind();
                if (occKind == null || !QueryUtils.isOccKindSporadicOrPeriodic(occKind)) continue;
                QueryUtils.addToMap(map, p, chRtSpecification);
            }
        }
    }

    private static void addToMap(Map<InstanceSpecification, Set<CHRtSpecification>> map, InstanceSpecification p, CHRtSpecification chRtSpecification) {
        Set<CHRtSpecification> value = map.get(p);
        if (value == null) {
            value = new HashSet<CHRtSpecification>();
        }
        value.add(chRtSpecification);
        map.put(p, value);
    }

    public static boolean isProcessorInstance(InstanceSpecification e) {
        for (Classifier c : e.getClassifiers()) {
            if (UMLUtils.getStereotypeApplication((Element)c, CH_HwProcessor.class) == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isDeviceInstance(InstanceSpecification instSpec) {
        Classifier classifier = (Classifier)instSpec.getClassifiers().get(0);
        EList stereotypeList = classifier.getAppliedStereotypes();
        for (Stereotype theStereo : stereotypeList) {
            EObject object = classifier.getStereotypeApplication(theStereo);
            if (!(object instanceof HwDevice)) continue;
            return true;
        }
        return false;
    }

    public static CH_HwProcessor getOneProcessor(Model umlModel) {
        Package depv = CHESSProfileManager.getViewByStereotype((Model)umlModel, (String)"DeploymentView");
        if ((depv = QueryUtils.getOneResourcePlatformPackage(depv)) != null) {
            EList all = depv.allOwnedElements();
            for (Element element : all) {
                InstanceSpecification e;
                if (!(element instanceof InstanceSpecification) || (e = (InstanceSpecification)element).getQualifiedName() == null || !QueryUtils.isProcessorInstance(e)) continue;
                CH_HwProcessor t = (CH_HwProcessor)UMLUtils.getStereotypeApplication((Element)e, CH_HwProcessor.class);
                return t;
            }
        }
        return null;
    }

    public static EList<CH_HwProcessor> getAllProcessorInstances(Model umlModel) throws ModelError {
        BasicEList processors = new BasicEList();
        Package depv = CHESSProfileManager.getViewByStereotype((Model)umlModel, (String)"DeploymentView");
        if (depv == null) {
            throw new ModelError("Deployment view not found.");
        }
        List<Package> platformPackages = QueryUtils.getResourcePlatformPackages(depv);
        if (platformPackages.isEmpty()) {
            throw new ModelError("CHGaResourcePlatform not found in Deployment view.");
        }
        for (Package pp : platformPackages) {
            EList all = pp.allOwnedElements();
            for (Element element : all) {
                InstanceSpecification e;
                if (!(element instanceof InstanceSpecification) || (e = (InstanceSpecification)element).getQualifiedName() == null || !QueryUtils.isProcessorInstance(e)) continue;
                CH_HwProcessor t = (CH_HwProcessor)UMLUtils.getStereotypeApplication((Element)e, CH_HwProcessor.class);
                processors.add((Object)t);
            }
        }
        if (processors.size() == 0) {
            throw new ModelError("Processors not found.");
        }
        return processors;
    }

    public static EList<CH_HwProcessor> getAllProcessorInstancesInPackage(Package thePackage) throws ModelError {
        BasicEList processors = new BasicEList();
        EList all = thePackage.allOwnedElements();
        for (Element element : all) {
            InstanceSpecification e;
            if (!(element instanceof InstanceSpecification) || (e = (InstanceSpecification)element).getQualifiedName() == null || !QueryUtils.isProcessorInstance(e)) continue;
            CH_HwProcessor t = (CH_HwProcessor)UMLUtils.getStereotypeApplication((Element)e, CH_HwProcessor.class);
            processors.add((Object)t);
        }
        if (processors.size() == 0) {
            throw new ModelError("Processors not found.");
        }
        return processors;
    }

    public static EList<CH_HwProcessor> filterMultiCoreProcessors(EList<CH_HwProcessor> processors) {
        BasicEList candidates = new BasicEList();
        for (CH_HwProcessor processor : processors) {
            if (QueryUtils.getCores(processor).size() <= 1) continue;
            candidates.add((Object)processor);
        }
        return candidates;
    }

    public static EList<CHCore> getCores(CH_HwProcessor processor) {
        InstanceSpecification processorBaseInst = processor.getBase_InstanceSpecification();
        Component processorComponent = (Component)processorBaseInst.getClassifiers().get(0);
        Stereotype chHwProcessorStereo = processorComponent.getAppliedStereotype("CHESS::Predictability::DeploymentConfiguration::HardwareBaseline::CH_HwProcessor");
        CH_HwProcessor chHwProc = (CH_HwProcessor)processorComponent.getStereotypeApplication(chHwProcessorStereo);
        String coreNumber = null;
        coreNumber = chHwProc.getNbCores();
        int icoreNumber = 1;
        try {
            icoreNumber = Integer.parseInt(coreNumber);
        }
        catch (Exception exception) {
            icoreNumber = 1;
        }
        BasicEList cores = new BasicEList();
        int i = 0;
        while (i < icoreNumber) {
            cores.add((Object)new CHCore(processor, QueryUtils.buildCoreName(i)));
            ++i;
        }
        return cores;
    }

    public static EList<InstanceSpecification> getAllPartitionInstances(Model umlModel) throws ModelError {
        Package cmpv = CHESSProfileManager.getViewByStereotype((Model)umlModel, (String)"ComponentView");
        if (cmpv == null) {
            throw new ModelError("Component view not found.");
        }
        if ((cmpv = QueryUtils.getOneResourcePlatformPackage(cmpv)) == null) {
            throw new ModelError("CHGaResourcePlatform not found in Component View.");
        }
        EList all = cmpv.allOwnedElements();
        BasicEList partitions = new BasicEList();
        for (Element element : all) {
            InstanceSpecification is;
            if (!(element instanceof InstanceSpecification) || (is = (InstanceSpecification)element).getQualifiedName() == null || !QueryUtils.isPartitionInstance(is)) continue;
            partitions.add((Object)is);
        }
        if (partitions.size() == 0) {
            throw new ModelError("Partition Instances not found.");
        }
        return partitions;
    }

    public static EList<InstanceSpecification> getAllComponentInstances(Model umlModel) throws ModelError {
        Package cmpv = CHESSProfileManager.getViewByStereotype((Model)umlModel, (String)"ComponentView");
        if (cmpv == null) {
            throw new ModelError("Component view not found.");
        }
        if ((cmpv = QueryUtils.getOneResourcePlatformPackage(cmpv)) == null) {
            throw new ModelError("CHGaResourcePlatform not found in Component View.");
        }
        EList all = cmpv.allOwnedElements();
        BasicEList components = new BasicEList();
        for (Element element : all) {
            InstanceSpecification is;
            if (!(element instanceof InstanceSpecification) || (is = (InstanceSpecification)element).getQualifiedName() == null || !QueryUtils.isComponentInstance(is)) continue;
            components.add((Object)is);
        }
        if (components.size() == 0) {
            throw new ModelError("Component Instances not found.");
        }
        return components;
    }

    public static EList<CHTask> getAllTaskInstances(Model umlModel) throws ModelError {
        BasicEList tasks = new BasicEList();
        EList<InstanceSpecification> x = QueryUtils.getAllComponentInstances(umlModel);
        for (InstanceSpecification instanceSpecification : x) {
            for (Element element1 : instanceSpecification.getOwnedElements()) {
                Slot slot;
                CHRtPortSlot chSlot;
                if (!(element1 instanceof Slot) || (chSlot = (CHRtPortSlot)UMLUtils.getStereotypeApplication((Element)(slot = (Slot)element1), CHRtPortSlot.class)) == null) continue;
                EList chSpecs = chSlot.getCH_RtSpecification();
                for (CHRtSpecification chRtSpecification : chSpecs) {
                    tasks.add((Object)new CHTask(chSlot, chRtSpecification));
                }
            }
        }
        if (tasks.size() == 0) {
            throw new ModelError("Tasks Instances not found.");
        }
        return tasks;
    }

    public static void deleteTask2CoreAssociations(Component hwSystem) {
        QueryUtils.deleteAssociations(hwSystem, 3);
    }

    public static void deleteComponent2CoreAssociations(Component hwSystem) {
        QueryUtils.deleteAssociations(hwSystem, 2);
    }

    public static void deletePartition2CoreAssociations(Component hwSystem) {
        QueryUtils.deleteAssociations(hwSystem, 1);
    }

    public static void buildInstance2CoreAssignments(Component hwSystem, Map<CHCore, LinkedHashSet<Object>> result) {
        for (CHCore core : result.keySet()) {
            for (Object e : result.get(core)) {
                if (!(e instanceof InstanceSpecification)) continue;
                InstanceSpecification componentInst = (InstanceSpecification)e;
                Comment c = hwSystem.createOwnedComment();
                UMLUtils.applyStereotype((Element)c, (String)MARTE_ASSIGN);
                Assign assign = (Assign)UMLUtils.getStereotypeApplication((Element)c, Assign.class);
                assign.getFrom().add((Object)componentInst);
                assign.getTo().add((Object)core.getProcessorInstance());
                Constraint n = hwSystem.createOwnedRule(core.getName());
                UMLUtils.applyStereotype((Element)n, (String)MARTE_NFPCONSTRAINT);
                NfpConstraint rule = (NfpConstraint)UMLUtils.getStereotypeApplication((Element)n, NfpConstraint.class);
                ValueSpecification valueSpec = n.createSpecification("core", null, UMLPackage.Literals.LITERAL_STRING);
                LiteralString value = (LiteralString)valueSpec;
                value.setValue(core.getName());
                assign.getImpliedConstraint().add((Object)rule);
            }
        }
    }

    public static Set<CHRtSpecification> getCHRTSpecFromInstances(EList<InstanceSpecification> instances) {
        HashSet<CHRtSpecification> result = new HashSet<CHRtSpecification>();
        for (InstanceSpecification is : instances) {
            for (Element el : is.getOwnedElements()) {
                Slot slot;
                CHRtPortSlot chSlot;
                if (!(el instanceof Slot) || (chSlot = (CHRtPortSlot)UMLUtils.getStereotypeApplication((Element)(slot = (Slot)el), CHRtPortSlot.class)) == null) continue;
                EList chSpecs = chSlot.getCH_RtSpecification();
                for (CHRtSpecification chRtSpecification : chSpecs) {
                    String occKind = chRtSpecification.getOccKind();
                    if (occKind == null || !QueryUtils.isOccKindSporadicOrPeriodic(occKind)) continue;
                    result.add(chRtSpecification);
                }
            }
        }
        return result;
    }

    public static Map<CHRtSpecification, Slot> getCHTasks(EList<InstanceSpecification> instances) {
        HashMap<CHRtSpecification, Slot> result = new HashMap<CHRtSpecification, Slot>();
        for (InstanceSpecification is : instances) {
            for (Element el : is.getOwnedElements()) {
                Slot slot;
                CHRtPortSlot chSlot;
                if (!(el instanceof Slot) || (chSlot = (CHRtPortSlot)UMLUtils.getStereotypeApplication((Element)(slot = (Slot)el), CHRtPortSlot.class)) == null) continue;
                EList chSpecs = chSlot.getCH_RtSpecification();
                for (CHRtSpecification chRtSpecification : chSpecs) {
                    String occKind = chRtSpecification.getOccKind();
                    if (occKind == null || !QueryUtils.isOccKindSporadicOrPeriodic(occKind)) continue;
                    result.put(chRtSpecification, slot);
                }
            }
        }
        return result;
    }

    public static EList<CHTask> getCHTasksList(EList<InstanceSpecification> instances) {
        BasicEList result = new BasicEList();
        for (InstanceSpecification is : instances) {
            for (Element el : is.getOwnedElements()) {
                Slot slot;
                CHRtPortSlot chSlot;
                if (!(el instanceof Slot) || (chSlot = (CHRtPortSlot)UMLUtils.getStereotypeApplication((Element)(slot = (Slot)el), CHRtPortSlot.class)) == null) continue;
                EList chSpecs = chSlot.getCH_RtSpecification();
                for (CHRtSpecification chRtSpecification : chSpecs) {
                    String occKind = chRtSpecification.getOccKind();
                    if (occKind == null || !QueryUtils.isOccKindSporadicOrPeriodic(occKind)) continue;
                    result.add((Object)new CHTask(chSlot, chRtSpecification));
                }
            }
        }
        return result;
    }

    public static void buildTask2CoreAssignments(Component hwSystem, InstanceSpecification processor, Map<String, LinkedHashSet<CHRtSpecification>> coresToCHRtSpec, Map<CHRtSpecification, InstanceSpecification> mapCHRtSpecToInstances) {
    }

    public static HashMap<CHTask, EList<CHTask>> getOperationChain(Model umlModel, EList<CHTask> chtasks) throws ModelError {
        Package instPkg = InstanceQuery.getInstanceSpecPackage(umlModel);
        if (instPkg == null) {
            throw new ModelError("Instance package not in the model: use the create instance command to create this package");
        }
        HashMap<CHTask, EList<CHTask>> map = new HashMap<CHTask, EList<CHTask>>();
        for (CHTask dOp : chtasks) {
            System.out.println(dOp.getCHRtSpecification().getContext().getName());
            BasicEList list = new BasicEList();
            CHRtPortSlot chRtPortSlot = InstanceQuery.getCHRtPortSlot(instPkg, dOp.getCHRtSpecification());
            QueryUtils.slot2EndToEndWorkFlow(instPkg, chRtPortSlot, dOp.getCHRtSpecification(), (EList<CHTask>)list);
            map.put(dOp, (EList<CHTask>)list);
        }
        return map;
    }

    public static HashMap<CHRtSpecification, EList<CHTask>> getOperationChain2(Model umlModel, Set<CHRtSpecification> chtasks) throws ModelError {
        Package instPkg = InstanceQuery.getInstanceSpecPackage(umlModel);
        if (instPkg == null) {
            throw new ModelError("Instance package not in the model: use the create instance command to create this package");
        }
        HashMap<CHRtSpecification, EList<CHTask>> map = new HashMap<CHRtSpecification, EList<CHTask>>();
        for (CHRtSpecification dOp : chtasks) {
            System.out.println(dOp.getContext().getName());
            BasicEList list = new BasicEList();
            CHRtPortSlot chRtPortSlot = InstanceQuery.getCHRtPortSlot(instPkg, dOp);
            QueryUtils.slot2EndToEndWorkFlow(instPkg, chRtPortSlot, dOp, (EList<CHTask>)list);
            map.put(dOp, (EList<CHTask>)list);
        }
        return map;
    }

    private static void slot2EndToEndWorkFlow(Package instPkg, CHRtPortSlot currentChSlot, CHRtSpecification dOp, EList<CHTask> list) throws ModelError {
        InstanceSpecification owningInstance = currentChSlot.getBase_Slot().getOwningInstance();
        Activity method = InstanceQuery.getMethod(dOp);
        if (method == null) {
            return;
        }
        for (ActivityNode node : method.getNodes()) {
            if (!(node instanceof CallOperationAction)) continue;
            CallOperationAction callOp = (CallOperationAction)node;
            EList<Slot> riSlot = InstanceQuery.getSlotFromPort(callOp, owningInstance);
            for (Slot slot : riSlot) {
                Slot usedPiSlot = InstanceQuery.getOppositeSlot(slot);
                CHRtSpecification usedCH = InstanceQuery.getCHFromSlot(usedPiSlot, callOp.getOperation());
                CHRtPortSlot ch = (CHRtPortSlot)UMLUtils.getStereotypeApplication((Element)usedPiSlot, CHRtPortSlot.class);
                if (InstanceQuery.isDeferred(usedCH)) continue;
                list.add((Object)new CHTask(ch, usedCH));
                QueryUtils.slot2EndToEndWorkFlow(instPkg, ch, usedCH, list);
            }
        }
    }

    private static int wcetUnit(String wcetSpec, String theUnit) {
        int ret = -1;
        if (wcetSpec == null) {
            return ret;
        }
        StringParser sp = new StringParser();
        double value = sp.getValueNFP(wcetSpec);
        String unit = sp.getUnitNFP(wcetSpec);
        if (value == -1.0) {
            return ret;
        }
        int intValue = QueryUtils.unitConversion(value, unit, theUnit);
        return intValue;
    }

    public static float unitConversionFloat(double value, String fromUnit, String toUnit) {
        int toFactor = 1000000;
        if (toUnit.equalsIgnoreCase("s")) {
            toFactor = 1000000000;
        } else if (toUnit.equalsIgnoreCase("ms")) {
            toFactor = 1000000;
        } else if (toUnit.equalsIgnoreCase("us")) {
            toFactor = 1000;
        } else if (toUnit.equalsIgnoreCase("ns")) {
            toFactor = 1;
        }
        int fromFactor = 1000000;
        if (fromUnit.equalsIgnoreCase("s")) {
            fromFactor = 1000000000;
        } else if (fromUnit.equalsIgnoreCase("ms")) {
            fromFactor = 1000000;
        } else if (fromUnit.equalsIgnoreCase("us")) {
            fromFactor = 1000;
        } else if (fromUnit.equalsIgnoreCase("ns")) {
            fromFactor = 1;
        }
        float ratio = (float)fromFactor / (float)toFactor;
        float intValue = (float)(value * (double)ratio);
        return intValue;
    }

    private static float wcetUnitFloat(String wcetSpec, String theUnit) {
        int ret = -1;
        if (wcetSpec == null) {
            return ret;
        }
        StringParser sp = new StringParser();
        double value = sp.getValueNFP(wcetSpec);
        String unit = sp.getUnitNFP(wcetSpec);
        if (value == -1.0) {
            return ret;
        }
        return QueryUtils.unitConversionFloat(value, unit, theUnit);
    }

    public static int unitConversion(double value, String fromUnit, String toUnit) {
        int toFactor = 1000000;
        if (toUnit.equalsIgnoreCase("s")) {
            toFactor = 1000000000;
        } else if (toUnit.equalsIgnoreCase("ms")) {
            toFactor = 1000000;
        } else if (toUnit.equalsIgnoreCase("us")) {
            toFactor = 1000;
        } else if (toUnit.equalsIgnoreCase("ns")) {
            toFactor = 1;
        }
        int fromFactor = 1000000;
        if (fromUnit.equalsIgnoreCase("s")) {
            fromFactor = 1000000000;
        } else if (fromUnit.equalsIgnoreCase("ms")) {
            fromFactor = 1000000;
        } else if (fromUnit.equalsIgnoreCase("us")) {
            fromFactor = 1000;
        } else if (fromUnit.equalsIgnoreCase("ns")) {
            fromFactor = 1;
        }
        double ratio = (double)fromFactor / (double)toFactor;
        int intValue = (int)Math.round(value * ratio);
        return intValue;
    }

    public static float getWCETunitFloat(CHRtSpecification chRtSpecification, String unitOfMeasure) throws ModelError {
        new StringParser();
        String wcet = chRtSpecification.getLocalWCET();
        float intValue = QueryUtils.wcetUnitFloat(wcet, unitOfMeasure);
        if (intValue != -1.0f) {
            return intValue;
        }
        wcet = chRtSpecification.getWCET();
        intValue = QueryUtils.wcetUnit(wcet, unitOfMeasure);
        if (intValue != -1.0f) {
            return intValue;
        }
        throw new ModelError("WCET for %s is not set correctly", new Object[]{chRtSpecification.getContext().getName()});
    }

    public static int getWCETunit(CHRtSpecification chRtSpecification, String unitOfMeasure) throws ModelError {
        new StringParser();
        String wcet = chRtSpecification.getLocalWCET();
        int intValue = QueryUtils.wcetUnit(wcet, unitOfMeasure);
        if (intValue != -1) {
            return intValue;
        }
        wcet = chRtSpecification.getWCET();
        intValue = QueryUtils.wcetUnit(wcet, unitOfMeasure);
        if (intValue != -1) {
            return intValue;
        }
        throw new ModelError("WCET for %s is not set correctly", new Object[]{chRtSpecification.getContext().getName()});
    }

    public static double getWCET(CHRtSpecification chRtSpecification) throws ModelError {
        StringParser sp = new StringParser();
        double x = -1.0;
        String wcet = chRtSpecification.getLocalWCET();
        if (wcet != null) {
            x = sp.getValueNFP(wcet);
        }
        if (x != -1.0) {
            return x;
        }
        wcet = chRtSpecification.getWCET();
        if (wcet != null) {
            x = sp.getValueNFP(wcet);
        }
        if (x != -1.0) {
            return x;
        }
        throw new ModelError("WCET for %s is not set correctly", new Object[]{chRtSpecification.getContext().getName()});
    }

    public static boolean isAssigned2Partition(InstanceSpecification i, EList<Assign> assignments) {
        for (Assign theAssignment : assignments) {
            if (theAssignment == null) continue;
            try {
                if (!theAssignment.getFrom().contains((Object)i) || !QueryUtils.elementIsPartitionInstance((Element)theAssignment.getTo().get(0))) continue;
                return true;
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public static boolean isAssigned2Processor(InstanceSpecification i, EList<Assign> assignments) {
        for (Assign theAssignment : assignments) {
            if (theAssignment == null) continue;
            try {
                if (!theAssignment.getFrom().contains((Object)i) || !QueryUtils.elementIsProcessorInstance((Element)theAssignment.getTo().get(0))) continue;
                return true;
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public static boolean isAssigned2Core(InstanceSpecification i, Package pack, EList<Assign> assignments) {
        String packQN = pack.getQualifiedName();
        String assignedTargetQN = "";
        String assignedTargetElementName = "";
        for (Assign theAssignment : assignments) {
            Element assignmentTarget;
            block4: {
                if (theAssignment == null) continue;
                try {
                    EList assignmentSource = theAssignment.getFrom();
                    assignmentTarget = (Element)theAssignment.getTo().get(0);
                    assignedTargetQN = ((NamedElement)assignmentTarget).getQualifiedName();
                    assignedTargetElementName = ((NamedElement)assignmentTarget).getLabel();
                    if (!assignmentSource.contains((Object)i) || !QueryUtils.elementIsProcessorInstance(assignmentTarget)) continue;
                    if (theAssignment.getImpliedConstraint().isEmpty() || theAssignment.getImpliedConstraint().get(0) == null) break block4;
                    if (!(String.valueOf(packQN) + "::" + assignedTargetElementName).equals(assignedTargetQN)) continue;
                    return true;
                }
                catch (Exception exception) {}
            }
            InstanceSpecification instSpecProc = (InstanceSpecification)assignmentTarget;
            if (!QueryUtils.processorInstanceIsSingleCore(instSpecProc) || !(String.valueOf(packQN) + "::" + assignedTargetElementName).equals(assignedTargetQN)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAssigned2Core(InstanceSpecification i, EList<Assign> assignments) {
        for (Assign theAssignment : assignments) {
            block4: {
                if (theAssignment == null) continue;
                try {
                    if (!theAssignment.getFrom().contains((Object)i) || !QueryUtils.elementIsProcessorInstance((Element)theAssignment.getTo().get(0))) continue;
                    if (theAssignment.getImpliedConstraint().isEmpty() || theAssignment.getImpliedConstraint().get(0) == null) break block4;
                    return true;
                }
                catch (Exception exception) {}
            }
            Element elem = (Element)theAssignment.getTo().get(0);
            InstanceSpecification instSpecProc = (InstanceSpecification)elem;
            if (!QueryUtils.processorInstanceIsSingleCore(instSpecProc)) continue;
            return true;
        }
        return false;
    }

    public static boolean isTaskAssigned2Core(CHTask task, Package pack, EList<Assign> assignments) {
        String taskName = task.getCHRtSpecification().getContext().getName();
        String packQN = pack.getQualifiedName();
        String assignedTargetQN = "";
        String assignedTargetElementName = "";
        for (Assign theAssignment : assignments) {
            if (theAssignment == null) continue;
            try {
                String theTaskValue;
                Element assignmentSource = (Element)theAssignment.getFrom().get(0);
                Element assignmentTarget = (Element)theAssignment.getTo().get(0);
                assignedTargetQN = ((NamedElement)assignmentTarget).getQualifiedName();
                assignedTargetElementName = ((NamedElement)assignmentTarget).getLabel();
                if (!(String.valueOf(packQN) + "::" + assignedTargetElementName).equals(assignedTargetQN) || !QueryUtils.elementIsSlotInstance(assignmentSource) || theAssignment.getImpliedConstraint() == null || theAssignment.getImpliedConstraint().isEmpty() || (theTaskValue = QueryUtils.getTaskNameFromImpliedNfpConstraint(theAssignment)) == null || theTaskValue.length() <= 0 || !theTaskValue.equals(taskName)) continue;
                return true;
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public static boolean isTaskAssigned2Core(CHTask t, EList<Assign> assignments) {
        for (Assign theAssignment : assignments) {
            CHTask theTask;
            Element assignmentSource;
            if (theAssignment == null || !QueryUtils.elementIsSlotInstance(assignmentSource = (Element)theAssignment.getFrom().get(0)) || (theTask = QueryUtils.getTaskFromSlot(assignmentSource)) == null || !theTask.equals(t) || !QueryUtils.elementIsProcessorInstance((Element)theAssignment.getTo().get(0))) continue;
            return true;
        }
        return false;
    }

    public static LinkedHashSet<Object> getPartitionsAssigned2Core(CHCore core, EList<Assign> assignments) {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        InstanceSpecification processorInstance = core.getProcessorInstance();
        String theCoreName = core.getName();
        String theCoreValue = null;
        for (Assign theAssignment : assignments) {
            if (theAssignment == null) continue;
            try {
                Element assignmentSource = (Element)theAssignment.getFrom().get(0);
                if (!QueryUtils.elementIsPartitionInstance(assignmentSource) || !theAssignment.getTo().contains((Object)processorInstance)) continue;
                if (theAssignment.getImpliedConstraint() != null && !theAssignment.getImpliedConstraint().isEmpty()) {
                    theCoreValue = QueryUtils.getCoreNameFromImpliedNfpConstraint(theAssignment);
                    if (!theCoreValue.equals(theCoreName)) continue;
                    result.add(assignmentSource);
                    continue;
                }
                if (!QueryUtils.processorInstanceIsSingleCore(processorInstance)) continue;
                result.add(assignmentSource);
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public static String getCoreNameFromImpliedNfpConstraint(Assign theAssignment) {
        String coreName = null;
        try {
            NfpConstraint theImpliedNfpConstraint = (NfpConstraint)theAssignment.getImpliedConstraint().get(0);
            Constraint cnstr = theImpliedNfpConstraint.getBase_Constraint();
            ValueSpecification valueSpec = cnstr.getSpecification();
            LiteralString value = (LiteralString)valueSpec;
            coreName = value.getValue();
        }
        catch (Exception exception) {
            System.out.println("Error in getCoreNameFromImpliedNfpConstraint");
        }
        return coreName;
    }

    private static String getTaskNameFromImpliedNfpConstraint(Assign theAssignment) {
        String taskName = null;
        try {
            NfpConstraint theImpliedNfpConstraint = (NfpConstraint)theAssignment.getImpliedConstraint().get(1);
            Constraint cnstr = theImpliedNfpConstraint.getBase_Constraint();
            ValueSpecification valueSpec = cnstr.getSpecification();
            LiteralString value = (LiteralString)valueSpec;
            taskName = value.getValue();
        }
        catch (Exception exception) {
            System.out.println("Error in getTaskNameFromImpliedNfpConstraint");
        }
        return taskName;
    }

    public static boolean elementIsPartitionInstance(Element element) {
        if (!(element instanceof InstanceSpecification)) {
            return false;
        }
        InstanceSpecification is = (InstanceSpecification)element;
        return is.getQualifiedName() != null && QueryUtils.isPartitionInstance(is);
    }

    public static boolean elementIsComponentInstance(Element element) {
        if (!(element instanceof InstanceSpecification)) {
            return false;
        }
        InstanceSpecification is = (InstanceSpecification)element;
        return is.getQualifiedName() != null && QueryUtils.isComponentInstance(is);
    }

    public static boolean elementIsProcessorInstance(Element element) {
        if (!(element instanceof InstanceSpecification)) {
            return false;
        }
        InstanceSpecification is = (InstanceSpecification)element;
        return is.getQualifiedName() != null && QueryUtils.isProcessorInstance(is);
    }

    public static LinkedHashSet<Object> getComponentsAssigned2Core(CHCore core, EList<Assign> assignments) {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        InstanceSpecification processorInstance = core.getProcessorInstance();
        String theCoreName = core.getName();
        String theCoreValue = null;
        for (Assign theAssignment : assignments) {
            if (theAssignment == null) continue;
            try {
                Element assignmentSource = (Element)theAssignment.getFrom().get(0);
                if (!QueryUtils.elementIsComponentInstance(assignmentSource) || !theAssignment.getTo().contains((Object)processorInstance)) continue;
                if (theAssignment.getImpliedConstraint() != null && !theAssignment.getImpliedConstraint().isEmpty()) {
                    theCoreValue = QueryUtils.getCoreNameFromImpliedNfpConstraint(theAssignment);
                    if (!theCoreValue.equals(theCoreName)) continue;
                    result.add(assignmentSource);
                    continue;
                }
                if (!QueryUtils.processorInstanceIsSingleCore(processorInstance)) continue;
                result.add(assignmentSource);
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public static LinkedHashSet<Object> getTasksAssigned2Core(CHCore core, Package pack, EList<Assign> assignments) {
        String packQN = pack.getQualifiedName();
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        InstanceSpecification processorInstance = core.getProcessorInstance();
        String theCoreName = core.getName();
        String theCoreValue = null;
        String theTaskValue = null;
        for (Assign theAssignment : assignments) {
            if (theAssignment == null) continue;
            try {
                String theTaskName;
                if (!theAssignment.getTo().contains((Object)processorInstance)) continue;
                Element assignmentSource = (Element)theAssignment.getFrom().get(0);
                Element assignmentTarget = (Element)theAssignment.getTo().get(0);
                String assignedTargetQN = ((NamedElement)assignmentTarget).getQualifiedName();
                String assignedTargetElementName = ((NamedElement)assignmentTarget).getLabel();
                EList<CHTask> chTaskList = new EList<CHTask>();
                if (!(String.valueOf(packQN) + "::" + assignedTargetElementName).equals(assignedTargetQN) || theAssignment.getImpliedConstraint() == null || theAssignment.getImpliedConstraint().isEmpty()) continue;
                theCoreValue = QueryUtils.getCoreNameFromImpliedNfpConstraint(theAssignment);
                theTaskValue = QueryUtils.getTaskNameFromImpliedNfpConstraint(theAssignment);
                if (theCoreValue.equals(theCoreName)) {
                    if (!QueryUtils.elementIsSlotInstance(assignmentSource)) continue;
                    chTaskList = QueryUtils.getAllTasksFromSlot(assignmentSource);
                    for (CHTask theChTask : chTaskList) {
                        theTaskName = theChTask.getCHRtSpecification().getContext().getName();
                        if (theChTask == null || !theTaskName.equals(theTaskValue)) continue;
                        result.add(theChTask);
                    }
                    continue;
                }
                if (!QueryUtils.processorInstanceIsSingleCore(processorInstance) || !QueryUtils.elementIsSlotInstance(assignmentSource)) continue;
                chTaskList = QueryUtils.getAllTasksFromSlot(assignmentSource);
                for (CHTask theChTask : chTaskList) {
                    theTaskName = theChTask.getCHRtSpecification().getContext().getName();
                    if (theChTask == null || !theTaskName.equals(theTaskValue)) continue;
                    result.add(theChTask);
                }
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public static EList<Assign> getComponent2CoreAssignments(Model umlModel, String viewName) throws ModelError {
        Component rpc = QueryUtils.getResourcePlatformComponent(umlModel, viewName);
        EList all = rpc.allOwnedElements();
        BasicEList assignments = new BasicEList();
        Stereotype stereo = null;
        for (Element element : all) {
            InstanceSpecification componentInst;
            if (element.getAppliedStereotype(MARTE_ASSIGN) == null) continue;
            stereo = element.getAppliedStereotype(MARTE_ASSIGN);
            EObject eobj = element.getStereotypeApplication(stereo);
            Assign a = (Assign)eobj;
            Element assignmentSource = (Element)a.getFrom().get(0);
            Element assignmentTarget = (Element)a.getTo().get(0);
            if (!QueryUtils.elementIsProcessorInstance(assignmentTarget) || !QueryUtils.elementIsComponentInstance(assignmentSource) || !QueryUtils.isComponentInstance(componentInst = (InstanceSpecification)assignmentSource)) continue;
            assignments.add((Object)a);
        }
        return assignments;
    }

    public static EList<Assign> getComponent2PartitionAssignments(Model umlModel, String viewName) throws ModelError {
        Component rpc = QueryUtils.getResourcePlatformComponent(umlModel, viewName);
        EList all = rpc.allOwnedElements();
        BasicEList assignments = new BasicEList();
        Stereotype stereo = null;
        for (Element element : all) {
            InstanceSpecification componentInst;
            if (element.getAppliedStereotype(MARTE_ASSIGN) == null) continue;
            stereo = element.getAppliedStereotype(MARTE_ASSIGN);
            EObject eobj = element.getStereotypeApplication(stereo);
            Assign a = (Assign)eobj;
            Element assignmentSource = (Element)a.getFrom().get(0);
            Element assignmentTarget = (Element)a.getTo().get(0);
            if (!QueryUtils.elementIsPartitionInstance(assignmentTarget) || !QueryUtils.elementIsComponentInstance(assignmentSource) || !QueryUtils.isComponentInstance(componentInst = (InstanceSpecification)assignmentSource)) continue;
            assignments.add((Object)a);
        }
        return assignments;
    }

    public static EList<Assign> getPartition2CoreAssignments(Model umlModel, String viewName) throws ModelError {
        Component rpc = QueryUtils.getResourcePlatformComponent(umlModel, viewName);
        EList all = rpc.allOwnedElements();
        BasicEList assignments = new BasicEList();
        Stereotype stereo = null;
        for (Element element : all) {
            if (element.getAppliedStereotype(MARTE_ASSIGN) == null) continue;
            stereo = element.getAppliedStereotype(MARTE_ASSIGN);
            EObject eobj = element.getStereotypeApplication(stereo);
            Assign a = (Assign)eobj;
            Element assignmentSource = (Element)a.getFrom().get(0);
            Element assignmentTarget = (Element)a.getTo().get(0);
            if (!QueryUtils.elementIsPartitionInstance(assignmentSource) || !QueryUtils.elementIsProcessorInstance(assignmentTarget)) continue;
            assignments.add((Object)a);
        }
        return assignments;
    }

    public static EList<Assign> getTask2CoreAssignments(Model umlModel, String viewName) throws ModelError {
        Component rpc = QueryUtils.getResourcePlatformComponent(umlModel, viewName);
        EList all = rpc.allOwnedElements();
        BasicEList assignments = new BasicEList();
        Stereotype stereo = null;
        for (Element element : all) {
            if (element.getAppliedStereotype(MARTE_ASSIGN) == null) continue;
            stereo = element.getAppliedStereotype(MARTE_ASSIGN);
            EObject eobj = element.getStereotypeApplication(stereo);
            Assign a = (Assign)eobj;
            Element assignmentSource = (Element)a.getFrom().get(0);
            Element assignmentTarget = (Element)a.getTo().get(0);
            if (!QueryUtils.elementIsSlotInstance(assignmentSource) || !QueryUtils.elementIsProcessorInstance(assignmentTarget)) continue;
            assignments.add((Object)a);
        }
        return assignments;
    }

    public static boolean processorInstanceIsSingleCore(InstanceSpecification processorInstance) {
        Classifier processorClass = (Classifier)processorInstance.getClassifiers().get(0);
        CH_HwProcessor processorType = (CH_HwProcessor)UMLUtils.getStereotypeApplication((Element)processorClass, CH_HwProcessor.class);
        String coreNumber = null;
        coreNumber = processorType.getNbCores();
        int icoreNumber = 1;
        try {
            icoreNumber = Integer.parseInt(coreNumber);
        }
        catch (Exception exception) {
            icoreNumber = 1;
        }
        return icoreNumber == 1;
    }

    public static Package getOwnerCHGaResourcePlatformPackage(Model umlModel, InstanceSpecification theSystem) throws ModelError {
        EList<Package> packList = QueryUtils.getResourcePlatformPackages(umlModel, "DeploymentView");
        for (Package pack : packList) {
            EList packElems = pack.allOwnedElements();
            for (Element elem : packElems) {
                if (!(elem instanceof InstanceSpecification) || !((InstanceSpecification)elem).equals(theSystem)) continue;
                return pack;
            }
        }
        return null;
    }

    public static class OccKindInfo {
        public double value;
        public String type;
        public String unit;
    }
}

