/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.textedit.property.xtext.ui.contributions;

import com.google.inject.Injector;
import java.util.ArrayList;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.extensionpoints.editors.configuration.ICustomDirectEditorConfiguration;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.alf.naming.ALFIDConverter;
import org.eclipse.papyrus.uml.textedit.property.xtext.ui.contributions.UMLPropertyEditorPropertyUtil;
import org.eclipse.papyrus.uml.textedit.property.xtext.ui.internal.UmlPropertyActivator;
import org.eclipse.papyrus.uml.textedit.property.xtext.umlProperty.BoundSpecification;
import org.eclipse.papyrus.uml.textedit.property.xtext.umlProperty.ModifierSpecification;
import org.eclipse.papyrus.uml.textedit.property.xtext.umlProperty.PropertyRule;
import org.eclipse.papyrus.uml.textedit.property.xtext.umlProperty.TypeRule;
import org.eclipse.papyrus.uml.xtext.integration.DefaultXtextDirectEditorConfiguration;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.xtext.EcoreUtil2;

public class PropertyXtextDirectEditorConfiguration
extends DefaultXtextDirectEditorConfiguration
implements ICustomDirectEditorConfiguration {
    public Injector getInjector() {
        return UmlPropertyActivator.getInstance().getInjector("org.eclipse.papyrus.uml.textedit.property.xtext.UmlProperty");
    }

    public ICommand getParseCommand(EObject modelObject, EObject xtextObject) {
        Property property = (Property)modelObject;
        PropertyRule propertyRuleObject = (PropertyRule)(xtextObject = EcoreUtil2.getContainerOfType((EObject)xtextObject, PropertyRule.class));
        boolean newIsDerived = propertyRuleObject.getIsDerived() != null && propertyRuleObject.getIsDerived().equals("/");
        boolean newIsReadOnly = false;
        boolean newIsUnique = false;
        boolean newIsUnion = false;
        boolean newIsOrdered = false;
        ArrayList<Property> newRedefines = new ArrayList<Property>();
        ArrayList<Property> newSubsets = new ArrayList<Property>();
        if (propertyRuleObject.getModifiers() != null) {
            for (ModifierSpecification modifier : propertyRuleObject.getModifiers().getValues()) {
                if (modifier.getRedefines() != null || modifier.getSubsets() != null) continue;
                switch (modifier.getValue()) {
                    case ORDERED: {
                        newIsOrdered = true;
                        break;
                    }
                    case READ_ONLY: {
                        newIsReadOnly = true;
                        break;
                    }
                    case UNION: {
                        newIsUnion = true;
                        break;
                    }
                    case UNIQUE: {
                        newIsUnique = true;
                        break;
                    }
                }
            }
            for (ModifierSpecification modifier : propertyRuleObject.getModifiers().getValues()) {
                if (modifier.getRedefines() != null) {
                    newRedefines.add(modifier.getRedefines().getProperty());
                    continue;
                }
                if (modifier.getSubsets() == null) continue;
                newSubsets.add(modifier.getSubsets().getProperty());
            }
        }
        int newLowerBound = 1;
        int newUpperBound = 1;
        if (propertyRuleObject.getMultiplicity() != null) {
            String tempBound;
            if (propertyRuleObject.getMultiplicity().getBounds().size() == 1) {
                tempBound = ((BoundSpecification)propertyRuleObject.getMultiplicity().getBounds().get(0)).getValue();
                if (tempBound.equals("*")) {
                    newLowerBound = 0;
                    newUpperBound = -1;
                } else {
                    newLowerBound = new Integer(tempBound);
                    newUpperBound = new Integer(tempBound);
                }
            } else {
                tempBound = ((BoundSpecification)propertyRuleObject.getMultiplicity().getBounds().get(0)).getValue();
                newLowerBound = new Integer(tempBound);
                tempBound = ((BoundSpecification)propertyRuleObject.getMultiplicity().getBounds().get(1)).getValue();
                newUpperBound = tempBound.equals("*") ? -1 : new Integer(tempBound);
            }
        }
        String newDefault = propertyRuleObject.getDefault() != null ? propertyRuleObject.getDefault().getDefault() : null;
        String newName = ALFIDConverter.IDtoName((String)propertyRuleObject.getName());
        TypeRule typeRule = propertyRuleObject.getType();
        Classifier newType = typeRule == null ? null : typeRule.getType();
        VisibilityKind newVisibility = VisibilityKind.PUBLIC_LITERAL;
        switch (propertyRuleObject.getVisibility()) {
            case PUBLIC: {
                newVisibility = VisibilityKind.PUBLIC_LITERAL;
                break;
            }
            case PACKAGE: {
                newVisibility = VisibilityKind.PACKAGE_LITERAL;
                break;
            }
            case PRIVATE: {
                newVisibility = VisibilityKind.PRIVATE_LITERAL;
                break;
            }
            case PROTECTED: {
                newVisibility = VisibilityKind.PROTECTED_LITERAL;
                break;
            }
        }
        CompositeCommand updateCommand = new CompositeCommand("Property update");
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)property);
        SetRequest setIsDerivedRequest = new SetRequest((EObject)property, (EStructuralFeature)UMLPackage.eINSTANCE.getProperty_IsDerived(), (Object)newIsDerived);
        ICommand setIsDerivedCommand = provider.getEditCommand((IEditCommandRequest)setIsDerivedRequest);
        updateCommand.add((IUndoableOperation)setIsDerivedCommand);
        SetRequest setIsReadOnlyRequest = new SetRequest((EObject)property, (EStructuralFeature)UMLPackage.eINSTANCE.getStructuralFeature_IsReadOnly(), (Object)newIsReadOnly);
        ICommand setIsReadOnlyCommand = provider.getEditCommand((IEditCommandRequest)setIsReadOnlyRequest);
        updateCommand.add((IUndoableOperation)setIsReadOnlyCommand);
        SetRequest setIsUniqueRequest = new SetRequest((EObject)property, (EStructuralFeature)UMLPackage.eINSTANCE.getMultiplicityElement_IsUnique(), (Object)newIsUnique);
        ICommand setIsUniqueCommand = provider.getEditCommand((IEditCommandRequest)setIsUniqueRequest);
        updateCommand.add((IUndoableOperation)setIsUniqueCommand);
        SetRequest setIsDerivedUnionRequest = new SetRequest((EObject)property, (EStructuralFeature)UMLPackage.eINSTANCE.getProperty_IsDerivedUnion(), (Object)newIsUnion);
        ICommand setIsDerivedUnionCommand = provider.getEditCommand((IEditCommandRequest)setIsDerivedUnionRequest);
        updateCommand.add((IUndoableOperation)setIsDerivedUnionCommand);
        SetRequest setIsOrderedRequest = new SetRequest((EObject)property, (EStructuralFeature)UMLPackage.eINSTANCE.getMultiplicityElement_IsOrdered(), (Object)newIsOrdered);
        ICommand setIsOrderedCommand = provider.getEditCommand((IEditCommandRequest)setIsOrderedRequest);
        updateCommand.add((IUndoableOperation)setIsOrderedCommand);
        SetRequest setLowerRequest = new SetRequest((EObject)property, (EStructuralFeature)UMLPackage.eINSTANCE.getMultiplicityElement_Lower(), (Object)newLowerBound);
        ICommand setLowerCommand = provider.getEditCommand((IEditCommandRequest)setLowerRequest);
        updateCommand.add((IUndoableOperation)setLowerCommand);
        SetRequest setUpperRequest = new SetRequest((EObject)property, (EStructuralFeature)UMLPackage.eINSTANCE.getMultiplicityElement_Upper(), (Object)newUpperBound);
        ICommand setUpperCommand = provider.getEditCommand((IEditCommandRequest)setUpperRequest);
        updateCommand.add((IUndoableOperation)setUpperCommand);
        SetRequest setNameRequest = new SetRequest((EObject)property, (EStructuralFeature)UMLPackage.eINSTANCE.getNamedElement_Name(), (Object)newName);
        ICommand setNameCommand = provider.getEditCommand((IEditCommandRequest)setNameRequest);
        updateCommand.add((IUndoableOperation)setNameCommand);
        SetRequest setTypeRequest = new SetRequest((EObject)property, (EStructuralFeature)UMLPackage.eINSTANCE.getTypedElement_Type(), (Object)newType);
        ICommand setTypeCommand = provider.getEditCommand((IEditCommandRequest)setTypeRequest);
        updateCommand.add((IUndoableOperation)setTypeCommand);
        SetRequest setVisibilityRequest = new SetRequest((EObject)property, (EStructuralFeature)UMLPackage.eINSTANCE.getNamedElement_Visibility(), (Object)newVisibility);
        ICommand setVisibilityCommand = provider.getEditCommand((IEditCommandRequest)setVisibilityRequest);
        updateCommand.add((IUndoableOperation)setVisibilityCommand);
        if (newDefault == null && property.getDefaultValue() != null) {
            DestroyElementRequest destroyDefaultValueRequest = new DestroyElementRequest((EObject)property.getDefaultValue(), false);
            ICommand destroyDefaultValueCommand = provider.getEditCommand((IEditCommandRequest)destroyDefaultValueRequest);
            updateCommand.add((IUndoableOperation)destroyDefaultValueCommand);
        } else if (newDefault != null) {
            SetRequest setDefaultValueRequest = new SetRequest((EObject)property, (EStructuralFeature)UMLPackage.eINSTANCE.getProperty_Default(), (Object)newDefault);
            ICommand setDefaultValueCommand = provider.getEditCommand((IEditCommandRequest)setDefaultValueRequest);
            updateCommand.add((IUndoableOperation)setDefaultValueCommand);
        }
        SetRequest setRedefinedPropertiesRequest = new SetRequest((EObject)property, (EStructuralFeature)UMLPackage.eINSTANCE.getProperty_RedefinedProperty(), newRedefines);
        ICommand setRedefinedPropertiesCommand = provider.getEditCommand((IEditCommandRequest)setRedefinedPropertiesRequest);
        updateCommand.add((IUndoableOperation)setRedefinedPropertiesCommand);
        SetRequest setSubsettedPropertiesRequest = new SetRequest((EObject)property, (EStructuralFeature)UMLPackage.eINSTANCE.getProperty_SubsettedProperty(), newSubsets);
        ICommand setSubsettedPropertiesCommand = provider.getEditCommand((IEditCommandRequest)setSubsettedPropertiesRequest);
        updateCommand.add((IUndoableOperation)setSubsettedPropertiesCommand);
        return updateCommand;
    }

    public String getTextToEdit(Object editedObject) {
        if (editedObject instanceof Property) {
            return UMLPropertyEditorPropertyUtil.getLabel((Property)editedObject).trim();
        }
        return "not a Property";
    }
}

