/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.ui.tools.internal.interpreter;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.sirius.common.tools.api.contentassist.ContentContext;
import org.eclipse.sirius.common.tools.api.contentassist.ContentInstanceContext;
import org.eclipse.sirius.common.tools.api.contentassist.ContentProposal;
import org.eclipse.sirius.common.tools.api.contentassist.IProposalProvider;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.internal.interpreter.VariableInterpreter;

public class VariableProposalProvider
implements IProposalProvider {
    public ContentProposal getNewEmtpyExpression() {
        return new ContentProposal("var:", "var:", "New variable access expression.", "var:".length());
    }

    public List<ContentProposal> getProposals(IInterpreter interpreter, ContentContext context) {
        List<ContentProposal> proposals = context == null || !(interpreter instanceof VariableInterpreter) ? Collections.emptyList() : (context.getContents() == null || context.getContents().length() == 0 ? Collections.singletonList(this.getNewEmtpyExpression()) : this.getProposals(context.getContents(), context.getPosition(), context.getInterpreterContext().getVariables().entrySet().iterator()));
        return proposals;
    }

    public List<ContentProposal> getProposals(IInterpreter interpreter, ContentInstanceContext context) {
        List<ContentProposal> proposals;
        if (context == null || !(interpreter instanceof VariableInterpreter)) {
            proposals = Collections.emptyList();
        } else if (context.getCurrentSelected() == null) {
            proposals = Collections.singletonList(this.getNewEmtpyExpression());
        } else {
            VariableInterpreter variableInterpreter = (VariableInterpreter)interpreter;
            Iterator variablesIterator = Iterators.transform(variableInterpreter.getVariables().entrySet().iterator(), (Function)new Function<Map.Entry<String, Object>, Map.Entry<String, String>>(){

                public Map.Entry<String, String> apply(Map.Entry<String, Object> input) {
                    return Maps.immutableEntry((Object)input.getKey(), (Object)input.getValue().toString());
                }
            });
            proposals = this.getProposals(context.getTextSoFar(), context.getCursorPosition(), variablesIterator);
        }
        return proposals;
    }

    private List<ContentProposal> getProposals(String writtenExpression, int cursorPosition, Iterator<Map.Entry<String, String>> variablesIterator) {
        ArrayList<ContentProposal> proposals = new ArrayList<ContentProposal>();
        String variableNamePrefix = writtenExpression.substring(0, cursorPosition);
        if ((variableNamePrefix = variableNamePrefix.trim()).length() >= "var:".length()) {
            if ("self".startsWith(variableNamePrefix = variableNamePrefix.substring("var:".length()))) {
                proposals.add(new ContentProposal("self", "self", "self"));
            }
            while (variablesIterator.hasNext()) {
                Map.Entry<String, String> entry = variablesIterator.next();
                String variableName = entry.getKey();
                String variableType = entry.getValue();
                if (!variableName.startsWith(variableNamePrefix)) continue;
                proposals.add(new ContentProposal(variableName, String.valueOf(variableName) + ": " + variableType, variableType));
            }
        }
        return proposals;
    }
}

