/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.ui.tools.internal.contentassist;

import java.util.List;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.sirius.common.tools.api.contentassist.ContentProposal;
import org.eclipse.sirius.common.tools.api.util.StringUtil;

public class ContentProposalConverter {
    private String proposalStart;

    public ContentProposalConverter(String proposalStart) {
        this.proposalStart = proposalStart;
    }

    public IContentProposal[] convertToJFaceContentProposals(List<ContentProposal> proposals) {
        if (proposals == null) {
            return new IContentProposal[0];
        }
        IContentProposal[] contentProposals = new IContentProposal[proposals.size()];
        int i = 0;
        while (i < contentProposals.length) {
            contentProposals[i] = this.convertToJFaceContentProposal(proposals.get(i));
            ++i;
        }
        return contentProposals;
    }

    private IContentProposal convertToJFaceContentProposal(ContentProposal arg) {
        String proposal = arg.getProposal();
        int cursorPosition = arg.getCursorPosition();
        if (!StringUtil.isEmpty((String)this.proposalStart) && proposal.startsWith(this.proposalStart)) {
            proposal = proposal.substring(this.proposalStart.length());
            cursorPosition = proposal.length();
        }
        return new DefaultContentProposal(proposal, arg.getInformation(), arg.getDisplay(), cursorPosition);
    }

    private static final class DefaultContentProposal
    implements IContentProposal {
        private final String proposal;
        private final String description;
        private final String label;
        private final int cursorPosition;

        private DefaultContentProposal(String proposal, String description, String label, int cursorPosition) {
            this.proposal = proposal;
            this.description = description;
            this.label = label;
            this.cursorPosition = cursorPosition;
        }

        public String getContent() {
            return this.proposal;
        }

        public int getCursorPosition() {
            return this.cursorPosition;
        }

        public String getDescription() {
            return this.description;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

