/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.extendedtypes.providers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.service.ExecutionStrategy;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProvider;
import org.eclipse.gmf.runtime.common.core.service.Service;
import org.eclipse.gmf.runtime.common.ui.services.util.ActivityFilterProviderDescriptor;
import org.eclipse.papyrus.infra.extendedtypes.ActionConfiguration;
import org.eclipse.papyrus.infra.extendedtypes.Activator;
import org.eclipse.papyrus.infra.extendedtypes.providers.ExtentedElementTypeActionProviderConfiguration;
import org.eclipse.papyrus.infra.extendedtypes.providers.GetAllExtendedElementTypeActionProvidersOperation;
import org.eclipse.papyrus.infra.extendedtypes.providers.GetExtendedElementTypeActionProviderOperation;
import org.eclipse.papyrus.infra.extendedtypes.providers.IExtendedElementTypeActionProvider;
import org.eclipse.papyrus.infra.extendedtypes.providers.ProviderNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedElementTypeActionService
extends Service {
    protected static final ExtendedElementTypeActionService instance = new ExtendedElementTypeActionService();

    static {
        instance.configureProviders("org.eclipse.papyrus.infra.extendedtypes", "extendedElementTypeActionProvider");
    }

    protected ExtendedElementTypeActionService() {
    }

    public static synchronized ExtendedElementTypeActionService getInstance() {
        return instance;
    }

    protected Service.ProviderDescriptor newProviderDescriptor(IConfigurationElement element) {
        return new ProviderDescriptor(element);
    }

    public List<IExtendedElementTypeActionProvider> getProviders() {
        ArrayList<IExtendedElementTypeActionProvider> providers = new ArrayList<IExtendedElementTypeActionProvider>();
        this.execute(ExecutionStrategy.REVERSE, new GetAllExtendedElementTypeActionProvidersOperation(providers));
        return providers;
    }

    public IExtendedElementTypeActionProvider getProvider(ActionConfiguration actionConfiguration) {
        List providers = this.execute(ExecutionStrategy.REVERSE, new GetExtendedElementTypeActionProviderOperation(actionConfiguration));
        for (IExtendedElementTypeActionProvider aspectActionProvider : providers) {
            if (aspectActionProvider == null) continue;
            return aspectActionProvider;
        }
        return null;
    }

    public ICommand getICommand(List<? extends Object> elementsToEdit, ActionConfiguration configuration) throws ProviderNotFoundException {
        IExtendedElementTypeActionProvider provider = this.getProvider(configuration);
        if (provider != null) {
            return provider.getICommand(elementsToEdit, configuration);
        }
        throw new ProviderNotFoundException(configuration);
    }

    public ICommand getPreValidationCommand(List<? extends Object> elementsToEdit, ActionConfiguration configuration) throws ProviderNotFoundException {
        IExtendedElementTypeActionProvider provider = this.getProvider(configuration);
        if (provider != null) {
            return provider.getBeforeCreateValidationCommand(elementsToEdit, configuration);
        }
        throw new ProviderNotFoundException(configuration);
    }

    protected static class ProviderDescriptor
    extends ActivityFilterProviderDescriptor {
        protected ExtentedElementTypeActionProviderConfiguration providerConfiguration;

        public ProviderDescriptor(IConfigurationElement element) {
            super(element);
            this.providerConfiguration = ExtentedElementTypeActionProviderConfiguration.parse(element);
            Assert.isNotNull((Object)((Object)this.providerConfiguration));
        }

        public boolean provides(IOperation operation) {
            if (!super.provides(operation)) {
                return false;
            }
            if (operation instanceof GetAllExtendedElementTypeActionProvidersOperation) {
                return true;
            }
            if (operation instanceof GetExtendedElementTypeActionProviderOperation) {
                String providerConfigurationClassName = this.providerConfiguration.getConfigurationClassName();
                if (providerConfigurationClassName == null) {
                    Activator.log.error("Error during the parsing of the action configuration extension point", null);
                    return false;
                }
                String configurationClassName = ((GetExtendedElementTypeActionProviderOperation)operation).getActionConfiguration().eClass().getInstanceClassName();
                return providerConfigurationClassName.equals(configurationClassName);
            }
            return false;
        }

        public IProvider getProvider() {
            if (this.provider == null) {
                IProvider newProvider = super.getProvider();
                if (this.provider instanceof IExtendedElementTypeActionProvider) {
                    IExtendedElementTypeActionProvider defaultProvider = (IExtendedElementTypeActionProvider)newProvider;
                    defaultProvider.setConfiguration(this.getElement());
                }
                return newProvider;
            }
            return super.getProvider();
        }
    }
}

