/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.extendedtypes.invariantsemantictypeconfiguration;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.infra.extendedtypes.Activator;
import org.eclipse.papyrus.infra.extendedtypes.invariantsemantictypeconfiguration.IInvariantContainerDescriptor;
import org.eclipse.papyrus.infra.extendedtypes.invariantsemantictypeconfiguration.IInvariantCreationElementValidator;
import org.eclipse.papyrus.infra.extendedtypes.invariantsemantictypeconfiguration.IInvariantEditHelperAdvice;
import org.eclipse.papyrus.infra.extendedtypes.invariantsemantictypeconfiguration.IInvariantElementMatcher;
import org.eclipse.papyrus.infra.extendedtypes.invariantsemantictypeconfiguration.InvariantRuleConfiguration;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleConfigurationFactoryRegistry {
    private static RuleConfigurationFactoryRegistry registry;
    protected Map<String, ConfigurableClassDescriptor> configurationTypeToClassDescriptor = null;
    private static Map<String, WeakReference<Class<?>>> successLookupTable;
    private static Set<String> failureLookupTable;
    private static Map<Bundle, Set<String>> bundleToExceptionsSetMap;

    static {
        successLookupTable = new HashMap();
        failureLookupTable = new HashSet<String>();
        bundleToExceptionsSetMap = new HashMap<Bundle, Set<String>>();
    }

    public static synchronized RuleConfigurationFactoryRegistry getInstance() {
        if (registry == null) {
            registry = new RuleConfigurationFactoryRegistry();
            registry.init();
        }
        return registry;
    }

    protected void init() {
        IConfigurationElement[] elements;
        this.configurationTypeToClassDescriptor = new HashMap<String, ConfigurableClassDescriptor>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.infra.extendedtypes.invariantRule");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            String contributorName = configurationElement.getContributor().getName();
            String configurationClass = configurationElement.getAttribute("configurationClass");
            String matcherClassName = configurationElement.getAttribute("elementMatcher");
            String editHelperAdviceClassName = configurationElement.getAttribute("editHelperAdvice");
            String containerDescriptorClassName = configurationElement.getAttribute("semanticTypeDescriptor");
            String creationElementValidatorClassName = configurationElement.getAttribute("creationElementValidator");
            ConfigurableClassDescriptor configurableClassDescriptor = new ConfigurableClassDescriptor(contributorName, matcherClassName, contributorName, editHelperAdviceClassName, contributorName, containerDescriptorClassName, contributorName, creationElementValidatorClassName);
            this.configurationTypeToClassDescriptor.put(configurationClass, configurableClassDescriptor);
            ++n2;
        }
    }

    public IInvariantElementMatcher<InvariantRuleConfiguration> createMatcher(InvariantRuleConfiguration ruleConfiguration) {
        Class<IInvariantElementMatcher<InvariantRuleConfiguration>> elementMatcherClass = this.getMatcherClass(ruleConfiguration);
        if (elementMatcherClass == null) {
            return null;
        }
        try {
            IInvariantElementMatcher<InvariantRuleConfiguration> matcher = elementMatcherClass.newInstance();
            if (matcher != null) {
                matcher.init(ruleConfiguration);
            }
            return matcher;
        }
        catch (InstantiationException e) {
            Activator.log.error((Throwable)e);
        }
        catch (IllegalAccessException e) {
            Activator.log.error((Throwable)e);
        }
        return null;
    }

    public IInvariantContainerDescriptor<InvariantRuleConfiguration> createContainerDescriptor(InvariantRuleConfiguration ruleConfiguration) {
        Class<IInvariantContainerDescriptor<InvariantRuleConfiguration>> containerDescriptorClass = this.getContainerDescriptorClass(ruleConfiguration);
        if (containerDescriptorClass == null) {
            return null;
        }
        try {
            IInvariantContainerDescriptor<InvariantRuleConfiguration> containerDescriptor = containerDescriptorClass.newInstance();
            if (containerDescriptor != null) {
                containerDescriptor.init(ruleConfiguration);
            }
            return containerDescriptor;
        }
        catch (InstantiationException e) {
            Activator.log.error((Throwable)e);
        }
        catch (IllegalAccessException e) {
            Activator.log.error((Throwable)e);
        }
        return null;
    }

    public IInvariantEditHelperAdvice<InvariantRuleConfiguration> createEditHelperAdvice(InvariantRuleConfiguration ruleConfiguration) {
        Class<IInvariantEditHelperAdvice<InvariantRuleConfiguration>> editHelperAdviceClass = this.getEditHelperAdviceClass(ruleConfiguration);
        if (editHelperAdviceClass == null) {
            Activator.log.error("impossible to find the edit helper advice implementation for configuration type : " + (ruleConfiguration != null ? ruleConfiguration.eClass().getName() : "null"), null);
            return null;
        }
        try {
            IInvariantEditHelperAdvice<InvariantRuleConfiguration> editHelperAdvice = editHelperAdviceClass.newInstance();
            if (editHelperAdvice != null) {
                editHelperAdvice.init(ruleConfiguration);
            }
            return editHelperAdvice;
        }
        catch (InstantiationException e) {
            Activator.log.error((Throwable)e);
        }
        catch (IllegalAccessException e) {
            Activator.log.error((Throwable)e);
        }
        return null;
    }

    public IInvariantCreationElementValidator<InvariantRuleConfiguration> createCreationElementValidator(InvariantRuleConfiguration ruleConfiguration) {
        Class<IInvariantCreationElementValidator<InvariantRuleConfiguration>> creationElementValidatorClass = this.getCreationElementValidatorClass(ruleConfiguration);
        if (creationElementValidatorClass == null) {
            return null;
        }
        try {
            IInvariantCreationElementValidator<InvariantRuleConfiguration> creationElementValidator = creationElementValidatorClass.newInstance();
            if (creationElementValidator != null) {
                creationElementValidator.init(ruleConfiguration);
            }
            return creationElementValidator;
        }
        catch (InstantiationException e) {
            Activator.log.error((Throwable)e);
        }
        catch (IllegalAccessException e) {
            Activator.log.error((Throwable)e);
        }
        return null;
    }

    protected Class<IInvariantCreationElementValidator<InvariantRuleConfiguration>> getCreationElementValidatorClass(InvariantRuleConfiguration configuration) {
        String configurationType = configuration.eClass().getInstanceClassName();
        String className = this.configurationTypeToClassDescriptor.get(configurationType).getCreationElementValidatorClassName();
        String contributorName = this.configurationTypeToClassDescriptor.get(configurationType).getCreationElementValidatorContributorName();
        if (className != null && contributorName != null) {
            return RuleConfigurationFactoryRegistry.loadClass(className, contributorName);
        }
        return null;
    }

    protected Class<IInvariantElementMatcher<InvariantRuleConfiguration>> getMatcherClass(InvariantRuleConfiguration configuration) {
        String configurationType = configuration.eClass().getInstanceClassName();
        String className = this.configurationTypeToClassDescriptor.get(configurationType).getElementMatcherClassName();
        String contributorName = this.configurationTypeToClassDescriptor.get(configurationType).getElementMatcherContributorName();
        if (className != null && contributorName != null) {
            return RuleConfigurationFactoryRegistry.loadClass(className, contributorName);
        }
        return null;
    }

    protected Class<IInvariantEditHelperAdvice<InvariantRuleConfiguration>> getEditHelperAdviceClass(InvariantRuleConfiguration configuration) {
        String configurationType = configuration.eClass().getInstanceClassName();
        String className = this.configurationTypeToClassDescriptor.get(configurationType).getEditHelperAdviceClassName();
        String contributorName = this.configurationTypeToClassDescriptor.get(configurationType).getEditHelperAdviceContributorName();
        return RuleConfigurationFactoryRegistry.loadClass(className, contributorName);
    }

    protected Class<IInvariantContainerDescriptor<InvariantRuleConfiguration>> getContainerDescriptorClass(InvariantRuleConfiguration configuration) {
        String configurationType = configuration.eClass().getInstanceClassName();
        String className = this.configurationTypeToClassDescriptor.get(configurationType).getContainerDescriptorClassName();
        String contributorName = this.configurationTypeToClassDescriptor.get(configurationType).getContainerDescriptorContributorName();
        if (className != null && contributorName != null) {
            return RuleConfigurationFactoryRegistry.loadClass(className, contributorName);
        }
        return null;
    }

    protected static Class<?> loadClass(String className, String pluginId) {
        Class found;
        StringBuffer keyStringBuf = new StringBuffer(className.length() + pluginId.length() + 2);
        keyStringBuf.append(pluginId);
        keyStringBuf.append('.');
        keyStringBuf.append(className);
        String keyString = keyStringBuf.toString();
        WeakReference<Class<?>> ref = successLookupTable.get(keyString);
        Class clazz = found = ref != null ? (Class)ref.get() : null;
        if (found == null) {
            if (ref != null) {
                successLookupTable.remove(keyString);
            }
            if (!failureLookupTable.contains(keyString)) {
                try {
                    Bundle bundle = RuleConfigurationFactoryRegistry.basicGetPluginBundle(pluginId);
                    if (bundle != null) {
                        int state = bundle.getState();
                        if (state == 32 || RuleConfigurationFactoryRegistry.isInExceptionList(bundle, className)) {
                            found = bundle.loadClass(className);
                            successLookupTable.put(keyString, new WeakReference<Class>(found));
                            if (state == 32) {
                                bundleToExceptionsSetMap.remove(bundle);
                            }
                        }
                    } else {
                        failureLookupTable.add(keyString);
                    }
                }
                catch (ClassNotFoundException e) {
                    failureLookupTable.add(keyString);
                }
            }
        }
        return found;
    }

    protected static Bundle getPluginBundle(String pluginId) {
        Bundle bundle = RuleConfigurationFactoryRegistry.basicGetPluginBundle(pluginId);
        if (bundle != null && bundle.getState() == 32) {
            return bundle;
        }
        return null;
    }

    private static Bundle basicGetPluginBundle(String pluginId) {
        return Platform.getBundle((String)pluginId);
    }

    private static boolean isInExceptionList(Bundle bundle, String className) {
        String packageName = className.substring(0, className.lastIndexOf(46));
        Set<String> exceptionSet = bundleToExceptionsSetMap.get(bundle);
        if (exceptionSet == null) {
            Dictionary dict = bundle.getHeaders();
            String value = (String)dict.get("Eclipse-LazyStart");
            if (value != null) {
                int index = value.indexOf("exceptions");
                if (index != -1) {
                    try {
                        int start = value.indexOf(34, index + 1);
                        int end = value.indexOf(34, start + 1);
                        String exceptions = value.substring(start + 1, end);
                        exceptionSet = new HashSet<String>(2);
                        StringTokenizer tokenizer = new StringTokenizer(exceptions, ",");
                        while (tokenizer.hasMoreTokens()) {
                            exceptionSet.add(tokenizer.nextToken().trim());
                        }
                    }
                    catch (IndexOutOfBoundsException exception) {
                        exceptionSet = Collections.emptySet();
                    }
                } else {
                    exceptionSet = Collections.emptySet();
                }
            } else {
                exceptionSet = Collections.emptySet();
            }
            bundleToExceptionsSetMap.put(bundle, exceptionSet);
        }
        return exceptionSet.contains(packageName);
    }

    protected static class ConfigurableClassDescriptor {
        private final String elementMatcherContributorName;
        private final String elementMatcherClassName;
        private final String editHelperAdviceContributorName;
        private final String editHelperAdviceClassName;
        private final String containerDescriptorContributorName;
        private final String containerDescriptorClassName;
        private final String creationElementValidatorContributorName;
        private final String creationElementValidatorClassName;

        public ConfigurableClassDescriptor(String elementMatcherContributorName, String elementMatcherClassName, String editHelperAdviceContributorName, String editHelperAdviceClassName, String containerDescriptorContributorName, String containerDescriptorClassName, String creationElementValidatorContributorName, String creationElementValidatorClassName) {
            this.elementMatcherContributorName = elementMatcherContributorName;
            this.elementMatcherClassName = elementMatcherClassName;
            this.editHelperAdviceContributorName = editHelperAdviceContributorName;
            this.editHelperAdviceClassName = editHelperAdviceClassName;
            this.containerDescriptorContributorName = containerDescriptorContributorName;
            this.containerDescriptorClassName = containerDescriptorClassName;
            this.creationElementValidatorContributorName = creationElementValidatorContributorName;
            this.creationElementValidatorClassName = creationElementValidatorClassName;
        }

        public String getCreationElementValidatorContributorName() {
            return this.creationElementValidatorContributorName;
        }

        public String getCreationElementValidatorClassName() {
            return this.creationElementValidatorClassName;
        }

        public String getElementMatcherContributorName() {
            return this.elementMatcherContributorName;
        }

        public String getElementMatcherClassName() {
            return this.elementMatcherClassName;
        }

        public String getEditHelperAdviceContributorName() {
            return this.editHelperAdviceContributorName;
        }

        public String getEditHelperAdviceClassName() {
            return this.editHelperAdviceClassName;
        }

        public String getContainerDescriptorContributorName() {
            return this.containerDescriptorContributorName;
        }

        public String getContainerDescriptorClassName() {
            return this.containerDescriptorClassName;
        }
    }
}

