/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.extendedtypes.invariantcontainerconfiguration;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.papyrus.infra.extendedtypes.invariantcontainerconfiguration.HierarchyPermission;
import org.eclipse.papyrus.infra.extendedtypes.invariantcontainerconfiguration.InvariantContainerConfiguration;
import org.eclipse.papyrus.infra.extendedtypes.invariantsemantictypeconfiguration.IInvariantElementMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvariantContainerMatcher
implements IInvariantElementMatcher<InvariantContainerConfiguration> {
    protected EList<HierarchyPermission> permissions;

    public boolean matches(EObject eObject) {
        return true;
    }

    protected boolean checkForbidden(EObject container, List<String> forbiddenParents, boolean isStrict) {
        IElementType parentType;
        if (forbiddenParents != null && !forbiddenParents.isEmpty() && (parentType = ElementTypeRegistry.getInstance().getElementType(container)) != null) {
            if (forbiddenParents.contains(parentType.getId())) {
                return false;
            }
            if (!isStrict) {
                IElementType[] iElementTypeArray = parentType.getAllSuperTypes();
                int n = iElementTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IElementType superType = iElementTypeArray[n2];
                    if (forbiddenParents.contains(superType.getId())) {
                        return false;
                    }
                    ++n2;
                }
            }
        }
        return true;
    }

    protected boolean checkAllowed(EObject container, List<String> allowedParents, boolean isStrict) {
        IElementType parentType;
        boolean matches = false;
        if (allowedParents != null && !allowedParents.isEmpty() && (parentType = ElementTypeRegistry.getInstance().getElementType(container)) != null) {
            if (allowedParents.contains(parentType.getId())) {
                matches = true;
            } else if (!isStrict) {
                IElementType[] iElementTypeArray = parentType.getAllSuperTypes();
                int n = iElementTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IElementType superType = iElementTypeArray[n2];
                    if (allowedParents.contains(superType.getId())) {
                        matches = true;
                        break;
                    }
                    ++n2;
                }
            }
        }
        return matches;
    }

    @Override
    public void init(InvariantContainerConfiguration configuration) {
        this.permissions = configuration.getPermissions();
    }
}

