/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.extendedtypes.advices;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IContainerDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.IElementMatcher;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.extendedtypes.ICreationElementValidator;
import org.eclipse.papyrus.infra.extendedtypes.types.IExtendedHintedElementType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedTypesOwnerAdvice
extends AbstractEditHelperAdvice {
    public boolean approveRequest(IEditCommandRequest request) {
        if (request instanceof CreateElementRequest) {
            IElementType typeToCreate = ((CreateElementRequest)request).getElementType();
            if (typeToCreate instanceof IExtendedHintedElementType) {
                if (!this.approveCreationRequest((IExtendedHintedElementType)typeToCreate, (CreateElementRequest)request)) {
                    return false;
                }
                List<IExtendedHintedElementType> superExtendedTypes = this.getAllSuperExtendedTypes((IExtendedHintedElementType)typeToCreate);
                if (superExtendedTypes == null || superExtendedTypes.size() == 0) {
                    return super.approveRequest(request);
                }
                for (IExtendedHintedElementType superType : superExtendedTypes) {
                    if (this.approveCreationRequest(superType, (CreateElementRequest)request)) continue;
                    return false;
                }
            }
        } else if (request instanceof SetRequest) {
            EStructuralFeature feature = ((SetRequest)request).getFeature();
            if (feature instanceof EReference) {
                if (!((EReference)feature).isContainment()) {
                    return super.approveRequest(request);
                }
                Object value = ((SetRequest)request).getValue();
                if (value instanceof EObject) {
                    IElementType type = ElementTypeRegistry.getInstance().getElementType((EObject)value, request.getClientContext());
                    if (type instanceof IExtendedHintedElementType) {
                        return this.approveMoveRequest((IExtendedHintedElementType)type, (SetRequest)request);
                    }
                } else if (value instanceof List) {
                    for (Object object : (List)value) {
                        IElementType[] types;
                        if (!(object instanceof EObject)) continue;
                        IElementType[] iElementTypeArray = types = ElementTypeRegistry.getInstance().getAllTypesMatching((EObject)object, request.getClientContext());
                        int n = types.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IElementType type = iElementTypeArray[n2];
                            if (type instanceof IExtendedHintedElementType) {
                                if (!this.approveMoveRequest((IExtendedHintedElementType)type, (SetRequest)request)) {
                                    return false;
                                }
                                List<IExtendedHintedElementType> superExtendedTypes = this.getAllSuperExtendedTypes((IExtendedHintedElementType)type);
                                if (superExtendedTypes != null && superExtendedTypes.size() != 0) {
                                    for (IExtendedHintedElementType superType : superExtendedTypes) {
                                        if (this.approveMoveRequest(superType, (SetRequest)request)) continue;
                                        return false;
                                    }
                                }
                            }
                            ++n2;
                        }
                    }
                }
            }
        } else if (request instanceof MoveRequest) {
            Map objectsToMove = ((MoveRequest)request).getElementsToMove();
            if (objectsToMove == null || objectsToMove.isEmpty()) {
                return super.approveRequest(request);
            }
            for (Map.Entry movedElement : objectsToMove.entrySet()) {
                IElementType[] types;
                IElementType[] iElementTypeArray = types = ElementTypeRegistry.getInstance().getAllTypesMatching((EObject)movedElement.getKey(), request.getClientContext());
                int n = types.length;
                int n3 = 0;
                while (n3 < n) {
                    IElementType type = iElementTypeArray[n3];
                    if (type instanceof IExtendedHintedElementType) {
                        if (!this.approveMoveRequest((IExtendedHintedElementType)type, (EObject)movedElement.getKey(), (MoveRequest)request)) {
                            return false;
                        }
                        List<IExtendedHintedElementType> superExtendedTypes = this.getAllSuperExtendedTypes((IExtendedHintedElementType)type);
                        if (superExtendedTypes != null && superExtendedTypes.size() != 0) {
                            for (IExtendedHintedElementType superType : superExtendedTypes) {
                                if (this.approveMoveRequest(superType, (EObject)movedElement.getKey(), (MoveRequest)request)) continue;
                                return false;
                            }
                        }
                    }
                    ++n3;
                }
            }
            return super.approveRequest(request);
        }
        return super.approveRequest(request);
    }

    protected boolean approveCreationRequest(IExtendedHintedElementType typeToCreate, CreateElementRequest request) {
        ICreationElementValidator creationValidator;
        IContainerDescriptor containerDescriptor = typeToCreate.getEContainerDescriptor();
        EObject newContainer = request.getContainer();
        if (containerDescriptor != null && newContainer != null) {
            List<EReference> references;
            if (containerDescriptor.getContainmentFeatures() != null && containerDescriptor.getContainmentFeatures().length > 0 && !(references = Arrays.asList(containerDescriptor.getContainmentFeatures())).contains(request.getContainmentFeature())) {
                return false;
            }
            IElementMatcher containerMatcher = containerDescriptor.getMatcher();
            if (containerMatcher != null && !containerMatcher.matches(newContainer)) {
                return false;
            }
        }
        if ((creationValidator = typeToCreate.getCreationElementValidator()) != null) {
            return creationValidator.canCreate(request);
        }
        return true;
    }

    protected boolean approveMoveRequest(IExtendedHintedElementType typeToMove, SetRequest request) {
        List<EReference> references;
        IContainerDescriptor containerDescriptor = typeToMove.getEContainerDescriptor();
        EObject newContainer = request.getElementToEdit();
        if (containerDescriptor == null || newContainer == null) {
            return true;
        }
        if (containerDescriptor.getContainmentFeatures() != null && containerDescriptor.getContainmentFeatures().length > 0 && !(references = Arrays.asList(containerDescriptor.getContainmentFeatures())).contains(request.getFeature())) {
            return false;
        }
        IElementMatcher containerMatcher = containerDescriptor.getMatcher();
        if (containerMatcher != null) {
            return containerMatcher.matches(newContainer);
        }
        return true;
    }

    protected boolean approveMoveRequest(IExtendedHintedElementType typeToMove, EObject objectToMove, MoveRequest request) {
        List<EReference> references;
        IContainerDescriptor containerDescriptor = typeToMove.getEContainerDescriptor();
        EObject newContainer = request.getTargetContainer();
        if (containerDescriptor == null || newContainer == null) {
            return true;
        }
        if (containerDescriptor.getContainmentFeatures() != null && containerDescriptor.getContainmentFeatures().length > 0 && !(references = Arrays.asList(containerDescriptor.getContainmentFeatures())).contains(request.getTargetFeature(objectToMove))) {
            return false;
        }
        IElementMatcher containerMatcher = containerDescriptor.getMatcher();
        if (containerMatcher != null) {
            return containerMatcher.matches(newContainer);
        }
        return true;
    }

    public List<IExtendedHintedElementType> getAllSuperExtendedTypes(IExtendedHintedElementType type) {
        IElementType[] superTypes = type.getAllSuperTypes();
        if (superTypes.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<IExtendedHintedElementType> superExtendedTypes = new ArrayList<IExtendedHintedElementType>();
        int i = superTypes.length - 1;
        while (i >= 0) {
            if (superTypes[i] instanceof IExtendedHintedElementType) {
                superExtendedTypes.add((IExtendedHintedElementType)superTypes[i]);
            }
            --i;
        }
        return superExtendedTypes;
    }
}

