/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.extendedtypes;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.infra.extendedtypes.IConfigurableElementMatcher;
import org.eclipse.papyrus.infra.extendedtypes.IConfigurableElementMatcherFactory;
import org.eclipse.papyrus.infra.extendedtypes.MatcherConfiguration;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurableElementMatcherFactoryRegistry {
    private static ConfigurableElementMatcherFactoryRegistry registry;
    protected Map<String, IConfigurableElementMatcherFactory<MatcherConfiguration>> configurationTypeToMatcherFactory = null;
    protected List<String> configurationTypeFactoryExceptions = null;
    private static Map<String, WeakReference<Class<?>>> successLookupTable;
    private static Set<String> failureLookupTable;
    private static Map<Bundle, Set<String>> bundleToExceptionsSetMap;

    static {
        successLookupTable = new HashMap();
        failureLookupTable = new HashSet<String>();
        bundleToExceptionsSetMap = new HashMap<Bundle, Set<String>>();
    }

    public static synchronized ConfigurableElementMatcherFactoryRegistry getInstance() {
        if (registry == null) {
            registry = new ConfigurableElementMatcherFactoryRegistry();
            registry.init();
        }
        return registry;
    }

    protected void init() {
        this.configurationTypeToMatcherFactory = new HashMap<String, IConfigurableElementMatcherFactory<MatcherConfiguration>>();
    }

    public IConfigurableElementMatcher<MatcherConfiguration> createElementMatcher(MatcherConfiguration matcherConfiguration) {
        IConfigurableElementMatcher<MatcherConfiguration> elementMatcher;
        Class<IConfigurableElementMatcherFactory<MatcherConfiguration>> factoryClass;
        String configurationType = matcherConfiguration.eClass().getInstanceTypeName();
        IConfigurableElementMatcherFactory<MatcherConfiguration> factory = this.configurationTypeToMatcherFactory.get(configurationType);
        if (factory == null && this.isNotInFactoryExceptionList(configurationType) && (factoryClass = this.retrieveFactoryClassFromExtensionPoint(configurationType)) != null) {
            try {
                factory = factoryClass.newInstance();
            }
            catch (InstantiationException e) {
                if (this.configurationTypeFactoryExceptions == null) {
                    this.configurationTypeFactoryExceptions = new ArrayList<String>();
                }
                this.configurationTypeFactoryExceptions.add(configurationType);
            }
            catch (IllegalAccessException e) {
                if (this.configurationTypeFactoryExceptions == null) {
                    this.configurationTypeFactoryExceptions = new ArrayList<String>();
                }
                this.configurationTypeFactoryExceptions.add(configurationType);
            }
            this.configurationTypeToMatcherFactory.put(configurationType, factory);
        }
        if (factory != null && (elementMatcher = factory.createElementMatcher(matcherConfiguration)) != null) {
            return elementMatcher;
        }
        return null;
    }

    protected boolean isNotInFactoryExceptionList(String configurationType) {
        if (this.configurationTypeFactoryExceptions == null) {
            return true;
        }
        return !this.configurationTypeFactoryExceptions.contains(configurationType);
    }

    protected Class<IConfigurableElementMatcherFactory<MatcherConfiguration>> retrieveFactoryClassFromExtensionPoint(String configurationType) {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.infra.extendedtypes.elementMatcherConfiguration");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            String eCoreClassName = configurationElement.getAttribute("configurationClass");
            if (configurationType.equals(eCoreClassName)) {
                String factoryClassName = configurationElement.getAttribute("factoryClass");
                return ConfigurableElementMatcherFactoryRegistry.loadClass(factoryClassName, configurationElement.getContributor().getName());
            }
            ++n2;
        }
        return null;
    }

    protected static Class<?> loadClass(String className, String pluginId) {
        Class found;
        StringBuffer keyStringBuf = new StringBuffer(className.length() + pluginId.length() + 2);
        keyStringBuf.append(pluginId);
        keyStringBuf.append('.');
        keyStringBuf.append(className);
        String keyString = keyStringBuf.toString();
        WeakReference<Class<?>> ref = successLookupTable.get(keyString);
        Class clazz = found = ref != null ? (Class)ref.get() : null;
        if (found == null) {
            if (ref != null) {
                successLookupTable.remove(keyString);
            }
            if (!failureLookupTable.contains(keyString)) {
                try {
                    Bundle bundle = ConfigurableElementMatcherFactoryRegistry.basicGetPluginBundle(pluginId);
                    if (bundle != null) {
                        int state = bundle.getState();
                        if (state == 32 || ConfigurableElementMatcherFactoryRegistry.isInExceptionList(bundle, className)) {
                            found = bundle.loadClass(className);
                            successLookupTable.put(keyString, new WeakReference<Class>(found));
                            if (state == 32) {
                                bundleToExceptionsSetMap.remove(bundle);
                            }
                        }
                    } else {
                        failureLookupTable.add(keyString);
                    }
                }
                catch (ClassNotFoundException e) {
                    failureLookupTable.add(keyString);
                }
            }
        }
        return found;
    }

    protected static Bundle getPluginBundle(String pluginId) {
        Bundle bundle = ConfigurableElementMatcherFactoryRegistry.basicGetPluginBundle(pluginId);
        if (bundle != null && bundle.getState() == 32) {
            return bundle;
        }
        return null;
    }

    private static Bundle basicGetPluginBundle(String pluginId) {
        return Platform.getBundle((String)pluginId);
    }

    private static boolean isInExceptionList(Bundle bundle, String className) {
        String packageName = className.substring(0, className.lastIndexOf(46));
        Set<String> exceptionSet = bundleToExceptionsSetMap.get(bundle);
        if (exceptionSet == null) {
            Dictionary dict = bundle.getHeaders();
            String value = (String)dict.get("Eclipse-LazyStart");
            if (value != null) {
                int index = value.indexOf("exceptions");
                if (index != -1) {
                    try {
                        int start = value.indexOf(34, index + 1);
                        int end = value.indexOf(34, start + 1);
                        String exceptions = value.substring(start + 1, end);
                        exceptionSet = new HashSet<String>(2);
                        StringTokenizer tokenizer = new StringTokenizer(exceptions, ",");
                        while (tokenizer.hasMoreTokens()) {
                            exceptionSet.add(tokenizer.nextToken().trim());
                        }
                    }
                    catch (IndexOutOfBoundsException exception) {
                        exceptionSet = Collections.emptySet();
                    }
                } else {
                    exceptionSet = Collections.emptySet();
                }
            } else {
                exceptionSet = Collections.emptySet();
            }
            bundleToExceptionsSetMap.put(bundle, exceptionSet);
        }
        return exceptionSet.contains(packageName);
    }
}

