/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.modelrepair.ui;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.utils.TransactionHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResourceSet;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.services.markerlistener.dialogs.DiagnosticDialog;
import org.eclipse.papyrus.uml.modelrepair.internal.stereotypes.IRepairAction;
import org.eclipse.papyrus.uml.modelrepair.internal.stereotypes.ZombieStereotypesDescriptor;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.statushandlers.StatusManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZombieStereotypesDialog
extends TrayDialog {
    private static final int APPLY_ID = 1025;
    private final TransactionalEditingDomain editingDomain;
    private TableViewer table;
    private LabelProviderService labelProviderService;
    private final List<ZombieStereotypesDescriptor> zombieDescriptors;
    private List<MissingSchema> missingSchemas;
    private final Collection<MissingSchema> actionsToApply;
    private ProgressMonitorPart progress;

    public ZombieStereotypesDialog(Shell shell, ModelSet modelSet, Iterable<? extends ZombieStereotypesDescriptor> zombies) throws ServiceException {
        this((IShellProvider)new SameShellProvider((Control)shell), modelSet, zombies);
    }

    public ZombieStereotypesDialog(IShellProvider parentShell, ModelSet modelSet, Iterable<? extends ZombieStereotypesDescriptor> zombies) throws ServiceException {
        super(parentShell);
        this.editingDomain = modelSet.getTransactionalEditingDomain();
        this.zombieDescriptors = Lists.newArrayList(zombies);
        this.labelProviderService = (LabelProviderService)ServiceUtilsForResourceSet.getInstance().getService(LabelProviderService.class, (Object)modelSet);
        this.actionsToApply = this.createActionsToApply();
    }

    private Collection<MissingSchema> createActionsToApply() {
        return new AbstractCollection<MissingSchema>(){
            private final Predicate<MissingSchema> filter = new Predicate<MissingSchema>(){

                public boolean apply(MissingSchema input) {
                    return input.getSelectedRepairAction().kind() != IRepairAction.Kind.NO_OP;
                }
            };

            @Override
            public Iterator<MissingSchema> iterator() {
                return Iterators.filter(ZombieStereotypesDialog.this.getMissingSchemas().iterator(), this.filter);
            }

            @Override
            public boolean isEmpty() {
                return !Iterables.any(ZombieStereotypesDialog.this.getMissingSchemas(), this.filter);
            }

            @Override
            public int size() {
                return Iterators.size(this.iterator());
            }
        };
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        Composite self = new Composite(contents, 0);
        self.setLayout((Layout)new GridLayout(1, false));
        self.setLayoutData((Object)new GridData(4, 4, true, true));
        Label descriptionLabel = new Label(self, 64);
        String description = "For each missing profile definition, select an action to correct the problem. Recommended actions are selected already where appropriate.";
        descriptionLabel.setText(description);
        descriptionLabel.setLayoutData((Object)new GridData(4, 1, true, false));
        this.table = new TableViewer(self, 67584);
        Table tableControl = this.table.getTable();
        TableLayout layout = new TableLayout();
        tableControl.setLayout((Layout)layout);
        tableControl.setLayoutData((Object)new GridData(4, 4, true, true));
        tableControl.setHeaderVisible(true);
        TableColumn nameColumn = new TableColumn(tableControl, 0);
        nameColumn.setText("Resource");
        nameColumn.setToolTipText("Resource in which problems with stereotype applications were found");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(25, 250, true));
        TableColumn affectedColumn = new TableColumn(tableControl, 0);
        affectedColumn.setText("Count");
        affectedColumn.setToolTipText("Number of stereotype applications in the resource from the wrong or missing profile definition");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(5, 50, true));
        TableColumn schemaColumn = new TableColumn(tableControl, 0);
        schemaColumn.setText("Profile");
        schemaColumn.setToolTipText("A profile definition that is missing or is not the applied version");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10, 150, true));
        TableViewerColumn actionColumn = new TableViewerColumn(this.table, 0);
        actionColumn.getColumn().setText("Action");
        actionColumn.getColumn().setToolTipText("Corrective action to apply to this resource for this profile");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(15, 100, true));
        actionColumn.setEditingSupport((EditingSupport)new ActionEditingSupport((ColumnViewer)this.table));
        this.table.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.table.setLabelProvider((IBaseLabelProvider)new ZombiesLabelProvider());
        this.table.setInput(this.getMissingSchemas());
        this.progress = new ProgressMonitorPart(self, null);
        this.progress.setLayoutData((Object)new GridData(4, 16384, true, false));
        this.progress.setVisible(false);
        return contents;
    }

    protected List<MissingSchema> getMissingSchemas() {
        if (this.missingSchemas == null) {
            this.missingSchemas = Lists.newArrayList();
            for (ZombieStereotypesDescriptor next : this.zombieDescriptors) {
                for (EPackage ePackage : next.getZombiePackages()) {
                    this.missingSchemas.add(new MissingSchema(ePackage, next));
                }
            }
        }
        return this.missingSchemas;
    }

    protected void updateControls() {
        String newTitle = "Repair Stereotypes";
        if (!this.actionsToApply.isEmpty()) {
            newTitle = String.valueOf(newTitle) + " *";
        }
        this.getShell().setText(newTitle);
        this.getButton(1025).setEnabled(!this.actionsToApply.isEmpty());
        this.table.refresh();
    }

    protected void applyPressed() {
        if (this.actionsToApply.isEmpty()) {
            return;
        }
        final ArrayList repairActions = Lists.newArrayList(this.actionsToApply);
        this.editingDomain.getCommandStack().execute((Command)new RecordingCommand(this.editingDomain, "Repair stereotypes"){

            protected void doExecute() {
                BasicDiagnostic diagnostics;
                block7: {
                    diagnostics = new BasicDiagnostic("org.eclipse.papyrus.uml.modelrepair", 0, "Problems in repairing stereotypes", null);
                    IRunnableWithProgress runnable = TransactionHelper.createPrivilegedRunnableWithProgress((TransactionalEditingDomain)ZombieStereotypesDialog.this.editingDomain, (IRunnableWithProgress)new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) {
                            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)ZombieStereotypesDialog.this.actionsToApply.size());
                            Iterator iter = repairActions.iterator();
                            while (iter.hasNext()) {
                                if (((MissingSchema)iter.next()).apply((DiagnosticChain)diagnostics, (IProgressMonitor)subMonitor.newChild(1, 0))) continue;
                                iter.remove();
                            }
                            subMonitor.done();
                        }
                    });
                    Cursor waitCursor = new Cursor((Device)ZombieStereotypesDialog.this.getShell().getDisplay(), 1);
                    try {
                        try {
                            ZombieStereotypesDialog.this.getShell().setCursor(waitCursor);
                            ZombieStereotypesDialog.this.progress.setVisible(true);
                            ModalContext.run((IRunnableWithProgress)runnable, (boolean)true, (IProgressMonitor)ZombieStereotypesDialog.this.progress, (Display)ZombieStereotypesDialog.this.getShell().getDisplay());
                        }
                        catch (Exception e) {
                            ZombieStereotypesDialog.this.getShell().setCursor(null);
                            Throwable t = e;
                            if (e instanceof InvocationTargetException) {
                                t = ((InvocationTargetException)e).getTargetException();
                            }
                            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.papyrus.uml.modelrepair", "Failed to repair stereotypes.", t), 5);
                            ZombieStereotypesDialog.this.getShell().setCursor(null);
                            waitCursor.dispose();
                            ZombieStereotypesDialog.this.progress.setVisible(false);
                            break block7;
                        }
                    }
                    catch (Throwable throwable) {
                        ZombieStereotypesDialog.this.getShell().setCursor(null);
                        waitCursor.dispose();
                        ZombieStereotypesDialog.this.progress.setVisible(false);
                        throw throwable;
                    }
                    ZombieStereotypesDialog.this.getShell().setCursor(null);
                    waitCursor.dispose();
                    ZombieStereotypesDialog.this.progress.setVisible(false);
                }
                if (diagnostics.getSeverity() > 0) {
                    DiagnosticDialog dialog = new DiagnosticDialog(ZombieStereotypesDialog.this.getShell(), "Problems in Repairing Stereotypes", "Some repair actions could not be completed normally. Please review the specific details and take any corrective action that may be required.", (Diagnostic)diagnostics, 6);
                    dialog.setBlockOnOpen(true);
                    dialog.open();
                }
            }
        });
        this.getMissingSchemas().removeAll(repairActions);
        this.updateControls();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, "Apply", true);
        super.createButtonsForButtonBar(parent);
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1: {
                if (this.actionsToApply.isEmpty() || MessageDialog.openQuestion((Shell)this.getShell(), (String)"Repair Stereotypes", (String)"You have not yet applied the pending repair actions. Are you sure you want to cancel?")) break;
                return;
            }
            case 1025: {
                this.applyPressed();
                return;
            }
        }
        super.buttonPressed(buttonId);
    }

    public void create() {
        super.create();
        this.getShell().setText("Repair Stereotypes");
        this.getShell().setMinimumSize(600, 400);
        this.getShell().pack();
        this.updateControls();
    }

    protected boolean isResizable() {
        return true;
    }

    public boolean isHelpAvailable() {
        return false;
    }

    protected void okPressed() {
        this.applyPressed();
        super.okPressed();
    }

    public boolean close() {
        this.zombieDescriptors.clear();
        if (this.missingSchemas != null) {
            this.missingSchemas.clear();
        }
        return super.close();
    }

    private class ActionEditingSupport
    extends EditingSupport {
        private ComboBoxViewerCellEditor editor;

        ActionEditingSupport(ColumnViewer viewer) {
            super(viewer);
        }

        protected CellEditor getCellEditor(Object element) {
            if (this.editor == null) {
                this.editor = new ComboBoxViewerCellEditor((Composite)((Table)this.getViewer().getControl()), 2048);
                this.editor.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
                this.editor.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                    public String getText(Object element) {
                        return ((IRepairAction)element).getLabel();
                    }
                });
            }
            this.editor.setInput(((MissingSchema)element).getRepairActions());
            return this.editor;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            return ((MissingSchema)element).getSelectedRepairAction();
        }

        protected void setValue(Object element, Object value) {
            MissingSchema missing = (MissingSchema)element;
            IRepairAction action = (IRepairAction)value;
            if (missing.getSelectedRepairAction() != action) {
                missing.setSelectedRepairAction(action);
                this.editor.getControl().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        ZombieStereotypesDialog.this.updateControls();
                    }
                });
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MissingSchema {
        private final EPackage ePackage;
        private final ZombieStereotypesDescriptor descriptor;
        private IRepairAction selectedAction;

        MissingSchema(EPackage ePackage, ZombieStereotypesDescriptor descriptor) {
            this.ePackage = ePackage;
            this.descriptor = descriptor;
            this.selectedAction = descriptor.getSuggestedRepairAction(ePackage);
        }

        Resource getResource() {
            return this.descriptor.getResource();
        }

        int getAffectedCount() {
            return this.descriptor.getZombieCount(this.getSchema());
        }

        EPackage getSchema() {
            return this.ePackage;
        }

        List<IRepairAction> getRepairActions() {
            return this.descriptor.getAvailableRepairActions(this.ePackage);
        }

        IRepairAction getSelectedRepairAction() {
            return this.selectedAction;
        }

        void setSelectedRepairAction(IRepairAction action) {
            this.selectedAction = action;
        }

        boolean apply(DiagnosticChain diagnostics, IProgressMonitor monitor) {
            return this.descriptor.repair(this.getSchema(), this.getSelectedRepairAction(), diagnostics, monitor);
        }
    }

    private class ZombiesLabelProvider
    extends ColumnLabelProvider {
        public void update(ViewerCell cell) {
            switch (cell.getColumnIndex()) {
                case 0: {
                    this.updateResource(cell);
                    break;
                }
                case 1: {
                    this.updateAffected(cell);
                    break;
                }
                case 2: {
                    this.updateSchema(cell);
                    break;
                }
                case 3: {
                    this.updateAction(cell);
                }
            }
        }

        void updateResource(ViewerCell cell) {
            Resource resource = ((MissingSchema)cell.getElement()).getResource();
            cell.setText(ZombieStereotypesDialog.this.labelProviderService.getLabelProvider().getText((Object)resource));
            cell.setImage(ZombieStereotypesDialog.this.labelProviderService.getLabelProvider().getImage((Object)resource));
        }

        void updateAffected(ViewerCell cell) {
            int count = ((MissingSchema)cell.getElement()).getAffectedCount();
            cell.setText(Integer.toString(count));
        }

        void updateSchema(ViewerCell cell) {
            EPackage schema = ((MissingSchema)cell.getElement()).getSchema();
            cell.setText(ZombieStereotypesDialog.this.labelProviderService.getLabelProvider().getText((Object)schema));
            cell.setImage(ZombieStereotypesDialog.this.labelProviderService.getLabelProvider().getImage((Object)schema));
        }

        void updateAction(ViewerCell cell) {
            IRepairAction action = ((MissingSchema)cell.getElement()).getSelectedRepairAction();
            cell.setText(action.getLabel());
        }
    }
}

