/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.modelrepair.internal.stereotypes;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.resource.IModelSetSnippet;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResourceSet;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.services.labelprovider.service.impl.LabelProviderServiceImpl;
import org.eclipse.papyrus.uml.modelrepair.Activator;
import org.eclipse.papyrus.uml.modelrepair.internal.stereotypes.StereotypeRepairService;
import org.eclipse.papyrus.uml.modelrepair.internal.stereotypes.ZombieStereotypesDescriptor;
import org.eclipse.papyrus.uml.modelrepair.ui.ZombieStereotypeDialogPresenter;
import org.eclipse.ui.IEditorPart;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StereotypeApplicationRepairSnippet
implements IModelSetSnippet {
    private final UMLResourceLoadAdapter adapter = new UMLResourceLoadAdapter();
    private final Function<? super EPackage, Profile> dynamicProfileSupplier;
    private ZombieStereotypeDialogPresenter presenter;
    private LabelProviderService labelProviderService;
    private boolean localLabelProvider;

    public StereotypeApplicationRepairSnippet() {
        this(null);
    }

    protected StereotypeApplicationRepairSnippet(Function<? super EPackage, Profile> dynamicProfileSupplier) {
        this.dynamicProfileSupplier = dynamicProfileSupplier;
    }

    public static StereotypeApplicationRepairSnippet getInstance(ModelSet modelSet) {
        UMLResourceLoadAdapter adapter = (UMLResourceLoadAdapter)EcoreUtil.getExistingAdapter((Notifier)modelSet, StereotypeApplicationRepairSnippet.class);
        return adapter == null ? null : adapter.getSnippet();
    }

    public IStatus repair(ModelSet modelSet) {
        IStatus result = Status.OK_STATUS;
        if (this.presenter != null) {
            for (Resource next : ImmutableList.copyOf((Collection)modelSet.getResources())) {
                if (!next.isLoaded()) continue;
                this.handleResourceLoaded(next);
            }
            try {
                this.presenter.awaitPending(false);
                for (Resource next : ImmutableList.copyOf((Collection)modelSet.getResources())) {
                    if (!next.isLoaded() || this.getZombieStereotypes(next) == null) continue;
                    result = new Status(2, "org.eclipse.papyrus.uml.modelrepair", "Stereotype repair did not successfully repair all stereotype application problems.");
                    break;
                }
            }
            catch (InterruptedException e) {
                result = new Status(4, "org.eclipse.papyrus.uml.modelrepair", "Stereotype repair was interrupted while waiting for user input.", (Throwable)e);
            }
        }
        return result;
    }

    protected void handleResourceLoaded(Resource resource) {
        final ModelSet modelSet = (ModelSet)resource.getResourceSet();
        StereotypeRepairService.startedRepairing(modelSet);
        boolean presented = false;
        try {
            ZombieStereotypesDescriptor zombies = this.getZombieStereotypes(resource);
            if (zombies != null && this.presenter != null) {
                this.presenter.addZombies(zombies);
                this.presenter.onPendingDone(new Runnable(){

                    public void run() {
                        StereotypeRepairService.finishedRepairing(modelSet);
                    }
                });
            }
            presented = this.presenter != null && this.presenter.isPending();
        }
        finally {
            if (!presented) {
                StereotypeRepairService.finishedRepairing(modelSet);
            }
        }
    }

    protected ZombieStereotypesDescriptor getZombieStereotypes(Resource resource) {
        ZombieStereotypesDescriptor result = null;
        Element root = this.getRootUMLElement(resource);
        if (root instanceof Package && !EMFHelper.isReadOnly((Resource)resource, (EditingDomain)EMFHelper.resolveEditingDomain((EObject)root))) {
            result = this.getZombieStereotypes(resource, (Package)root);
        }
        return result;
    }

    protected Element getRootUMLElement(Resource resource) {
        return (Element)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)UMLPackage.Literals.ELEMENT);
    }

    protected ZombieStereotypesDescriptor getZombieStereotypes(Resource resource, Package root) {
        ZombieStereotypesDescriptor result = null;
        ArrayList profileApplications = Lists.newArrayList();
        TreeIterator iter = EcoreUtil.getAllProperContents(Collections.singleton(root), (boolean)false);
        while (iter.hasNext()) {
            EObject next = (EObject)iter.next();
            if (next instanceof ProfileApplication) {
                profileApplications.add((ProfileApplication)next);
                iter.prune();
                continue;
            }
            if (next instanceof Package || next instanceof Component) continue;
            iter.prune();
        }
        Set<EPackage> appliedDefinitions = this.getAppliedDefinitions(profileApplications);
        Function<? super EPackage, Profile> profileSupplier = this.dynamicProfileSupplier;
        if (profileSupplier == null) {
            profileSupplier = this.presenter.getDynamicProfileSupplier();
        }
        ZombieStereotypesDescriptor zombies = new ZombieStereotypesDescriptor(resource, root, appliedDefinitions, profileSupplier, this.getLabelProvider());
        for (EObject next : resource.getContents()) {
            if (next instanceof Element) continue;
            zombies.analyze(next);
        }
        if (zombies.hasZombies()) {
            result = zombies;
        }
        return result;
    }

    protected Set<EPackage> getAppliedDefinitions(Iterable<? extends ProfileApplication> profileApplications) {
        HashSet result = Sets.newHashSet();
        for (ProfileApplication profileApplication : profileApplications) {
            EPackage definition = profileApplication.getAppliedDefinition();
            if (definition == null || definition.eIsProxy()) continue;
            result.add(definition);
        }
        return result;
    }

    private LabelProviderService getLabelProvider() {
        if (this.labelProviderService == null) {
            try {
                this.labelProviderService = (LabelProviderService)ServiceUtilsForResourceSet.getInstance().getService(LabelProviderService.class, (Object)this.adapter.getResourceSet());
            }
            catch (Exception e) {
                this.labelProviderService = new LabelProviderServiceImpl();
                this.localLabelProvider = true;
            }
        }
        return this.labelProviderService;
    }

    public void start(ModelSet modelsManager) {
        try {
            IEditorPart editor = (IEditorPart)ServiceUtilsForResourceSet.getInstance().getService(IMultiDiagramEditor.class, (Object)modelsManager);
            if (editor != null) {
                this.presenter = new ZombieStereotypeDialogPresenter(editor.getSite().getShell(), modelsManager);
                this.adapter.adapt((Notifier)modelsManager);
            }
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
    }

    public void dispose(ModelSet modelsManager) {
        block7: {
            if (this.presenter != null) {
                this.presenter.dispose();
                this.presenter = null;
            }
            if (this.localLabelProvider) {
                try {
                    try {
                        this.labelProviderService.disposeService();
                    }
                    catch (ServiceException e) {
                        Activator.log.error((Throwable)e);
                        this.labelProviderService = null;
                        this.localLabelProvider = false;
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    this.labelProviderService = null;
                    this.localLabelProvider = false;
                    throw throwable;
                }
                this.labelProviderService = null;
                this.localLabelProvider = false;
            }
        }
        this.adapter.unadapt((Notifier)modelsManager);
    }

    private class UMLResourceLoadAdapter
    extends AdapterImpl {
        private UMLResourceLoadAdapter() {
        }

        public StereotypeApplicationRepairSnippet getSnippet() {
            return StereotypeApplicationRepairSnippet.this;
        }

        public boolean isAdapterForType(Object type) {
            return type == StereotypeApplicationRepairSnippet.class;
        }

        public void notifyChanged(Notification msg) {
            Object notifier = msg.getNotifier();
            if (notifier instanceof ResourceSet) {
                this.handleNotification((ResourceSet)notifier, msg);
            } else if (notifier instanceof Resource) {
                this.handleNotification((Resource)notifier, msg);
            }
        }

        ResourceSet getResourceSet() {
            return (ResourceSet)this.getTarget();
        }

        public void setTarget(Notifier newTarget) {
            Resource resource;
            if (newTarget == null || newTarget instanceof ResourceSet) {
                super.setTarget(newTarget);
            }
            if (newTarget instanceof ResourceSet) {
                for (Resource next : ImmutableList.copyOf((Collection)((ResourceSet)newTarget).getResources())) {
                    this.adapt((Notifier)next);
                }
            } else if (newTarget instanceof Resource && (resource = (Resource)newTarget).isLoaded()) {
                StereotypeApplicationRepairSnippet.this.handleResourceLoaded(resource);
            }
        }

        public void unsetTarget(Notifier oldTarget) {
            if (oldTarget == this.getResourceSet()) {
                for (Resource next : this.getResourceSet().getResources()) {
                    this.unadapt((Notifier)next);
                }
            }
            super.unsetTarget(oldTarget);
        }

        protected void adapt(Notifier notifier) {
            if (!notifier.eAdapters().contains((Object)this)) {
                notifier.eAdapters().add((Object)this);
            }
        }

        protected void unadapt(Notifier notifier) {
            notifier.eAdapters().remove((Object)this);
        }

        protected void handleNotification(ResourceSet rset, Notification msg) {
            block0 : switch (msg.getFeatureID(ResourceSet.class)) {
                case 0: {
                    switch (msg.getEventType()) {
                        case 3: {
                            this.adapt((Notifier)((Resource)msg.getNewValue()));
                            break block0;
                        }
                        case 5: {
                            for (Object next : (Collection)msg.getNewValue()) {
                                this.adapt((Notifier)((Resource)next));
                            }
                        }
                    }
                }
            }
        }

        protected void handleNotification(Resource resource, Notification msg) {
            switch (msg.getFeatureID(Resource.class)) {
                case 4: {
                    if (!msg.getNewBooleanValue()) break;
                    StereotypeApplicationRepairSnippet.this.handleResourceLoaded(resource);
                }
            }
        }
    }
}

