/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.wizards.pages;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.gmf.gmfgraph.Canvas;
import org.eclipse.gmf.gmfgraph.Connection;
import org.eclipse.gmf.gmfgraph.DiagramLabel;
import org.eclipse.gmf.gmfgraph.Node;
import org.eclipse.gmf.mappings.LabelMapping;
import org.eclipse.gmf.mappings.LinkMapping;
import org.eclipse.gmf.mappings.NodeMapping;

public class GraphDefLookup {
    private final Canvas myCanvas;

    public GraphDefLookup(Canvas canvas) {
        this.myCanvas = canvas;
    }

    public Node findSuitableNode(NodeMapping nm) {
        if (this.myCanvas.getNodes().isEmpty()) {
            return null;
        }
        LinkedList<Node> candidateNodes = new LinkedList<Node>();
        if (nm.getDomainMetaElement() != null) {
            String name = nm.getDomainMetaElement().getName();
            for (Node n : this.myCanvas.getNodes()) {
                if (n.getName() == null || n.getName().indexOf(name) < 0) continue;
                candidateNodes.add(n);
            }
        }
        if (candidateNodes.isEmpty()) {
            candidateNodes.addAll((Collection<Node>)this.myCanvas.getNodes());
        }
        if (candidateNodes.size() == 1) {
            return (Node)candidateNodes.getFirst();
        }
        if (nm.getLabelMappings().isEmpty()) {
            block1: for (Node n : candidateNodes) {
                for (DiagramLabel dl : this.myCanvas.getLabels()) {
                    if (n.getFigure().getAccessors().contains((Object)dl.getAccessor())) continue block1;
                }
                return n;
            }
        } else {
            Node candidateWithLessLabels = null;
            Node candidateWithMoreLabels = null;
            for (Node n : candidateNodes) {
                LinkedList<DiagramLabel> labels;
                if (n.getFigure().getAccessors().size() < nm.getLabelMappings().size() || (labels = this.collectAccessingLabels(n)).isEmpty()) continue;
                if (labels.size() == nm.getLabelMappings().size()) {
                    return n;
                }
                if (labels.size() > nm.getLabelMappings().size() && candidateWithMoreLabels == null) {
                    candidateWithMoreLabels = n;
                }
                if (labels.size() >= nm.getLabelMappings().size() || candidateWithLessLabels != null) continue;
                candidateWithLessLabels = n;
            }
            if (candidateWithMoreLabels != null) {
                return candidateWithMoreLabels;
            }
            if (candidateWithLessLabels != null && this.findFloatingLabel() != null) {
                return candidateWithLessLabels;
            }
        }
        return (Node)candidateNodes.get(0);
    }

    private LinkedList<DiagramLabel> collectAccessingLabels(Node n) {
        LinkedList<DiagramLabel> labels = new LinkedList<DiagramLabel>();
        for (DiagramLabel l : this.myCanvas.getLabels()) {
            if (l.getFigure() != n.getFigure() || !n.getFigure().getAccessors().contains((Object)l.getAccessor())) continue;
            labels.add(l);
        }
        return labels;
    }

    private DiagramLabel findFloatingLabel() {
        for (DiagramLabel dl : this.myCanvas.getLabels()) {
            if (dl.getAccessor() != null) continue;
            for (Node n : this.myCanvas.getNodes()) {
                if (n.getFigure() != dl.getFigure()) continue;
            }
            return dl;
        }
        return null;
    }

    public void assignLabels(NodeMapping nm, Node n) {
        if (n == null || n.getFigure().getAccessors().isEmpty() || nm.getLabelMappings().isEmpty()) {
            return;
        }
        LinkedList<DiagramLabel> labels = this.collectAccessingLabels(n);
        int i = 0;
        while (i < nm.getLabelMappings().size()) {
            DiagramLabel l = !labels.isEmpty() ? labels.removeFirst() : this.findFloatingLabel();
            ((LabelMapping)nm.getLabelMappings().get(i++)).setDiagramLabel(l);
            ++i;
        }
    }

    public Connection findSuitableLink(LinkMapping lm) {
        if (this.myCanvas.getConnections().isEmpty()) {
            return null;
        }
        String name = null;
        if (lm.getDomainMetaElement() != null) {
            name = lm.getDomainMetaElement().getName();
        } else if (lm.getLinkMetaFeature() != null) {
            name = lm.getLinkMetaFeature().getEContainingClass().getName();
        }
        for (Connection c : this.myCanvas.getConnections()) {
            if (c.getName() == null || c.getName().indexOf(name) < 0) continue;
            return c;
        }
        return (Connection)this.myCanvas.getConnections().get(0);
    }

    public void assignLabels(LinkMapping lm, Connection c) {
        if (c == null || lm.getLabelMappings().isEmpty()) {
            return;
        }
        DiagramLabel floating = this.findFloatingLabel();
        int i = 0;
        while (i < lm.getLabelMappings().size()) {
            ((LabelMapping)lm.getLabelMappings().get(i)).setDiagramLabel(floating);
            ++i;
        }
    }
}

