/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.palette.dialog;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.palette.PaletteCustomizer;
import org.eclipse.gmf.runtime.gef.ui.palette.customize.PaletteCustomizerDialogEx;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.papyrus.customization.palette.dialog.NewLocalPaletteWizard;
import org.eclipse.papyrus.customization.palette.dialog.UpdateExtendedPaletteWizard;
import org.eclipse.papyrus.customization.palette.dialog.UpdateLocalPaletteWizard;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.Messages;
import org.eclipse.papyrus.uml.diagram.common.part.PaletteUtil;
import org.eclipse.papyrus.uml.diagram.common.part.PapyrusPaletteCustomizer;
import org.eclipse.papyrus.uml.diagram.common.part.PapyrusPalettePreferences;
import org.eclipse.papyrus.uml.diagram.common.service.PapyrusPaletteService;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class PapyrusPaletteCustomizerDialog
extends PaletteCustomizerDialogEx
implements IEclipsePreferences.IPreferenceChangeListener {
    private static final int RESTORE_DEFAULT_PALETTE_BUTTON_ID = 23;
    private static final int DELETE_PALETTE_BUTTON_ID = 22;
    private static final int EDIT_PALETTE_BUTTON_ID = 21;
    private static final int NEW_LOCAL_PALETTE_BUTTON_ID = 20;
    private static final String NEW_LOCAL_DESC_IMAGE = "/icons/local_desc_new.gif";
    private static final String DELETE_LOCAL_DESC_IMAGE = "/icons/local_desc_destroy.gif";
    private static final String EDIT_LOCAL_DESC_IMAGE = "/icons/local_desc_edit.gif";
    private static final String RESTORE_DEFAULT_DESC_IMAGE = "/icons/obj16/eraser.gif";
    protected final String LOCAL_DESCRIPTOR = "/icons/local_desc.gif";
    protected final String PLUGIN_DESCRIPTOR = "/icons/plugin_desc.gif";
    protected final String EXTENDED_PLUGIN_DESCRIPTOR = "/icons/extended_plugin_desc.gif";
    protected TreeViewer availableToolsTreeViewer;
    protected Table availablePalettesTable;
    protected CheckboxTableViewer availablePalettesTableViewer;
    protected PaletteLabelProvider providersLabelProvider;
    private Map<Integer, Button> paletteButtonsMap = new HashMap<Integer, Button>();

    public PapyrusPaletteCustomizerDialog(Shell shell, PaletteCustomizer customizer, PaletteRoot root) {
        super(shell, customizer, root);
    }

    public int open() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.papyrus.uml.diagram.common");
        prefs.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        return super.open();
    }

    public boolean close() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.papyrus.uml.diagram.common");
        prefs.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        Composite mainComposite = this.createMainComposite(parent);
        Control availableToolsComposite = this.createAvailablePalettesViewer(mainComposite);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        availableToolsComposite.setLayoutData((Object)data);
        Label nameLabel = new Label(mainComposite, 0);
        nameLabel.setText(Messages.Palette_Viewer);
        data = new FormData();
        data.left = new FormAttachment(availableToolsComposite, 5);
        data.top = new FormAttachment(0, 0);
        nameLabel.setLayoutData((Object)data);
        Control outline = this.createOutline(mainComposite);
        data = new FormData();
        data.left = new FormAttachment(availableToolsComposite, 5);
        data.top = new FormAttachment((Control)nameLabel, 0);
        data.bottom = new FormAttachment(100, 0);
        outline.setLayoutData((Object)data);
        Control properties = this.createPropertiesPanel(mainComposite);
        data = new FormData();
        data.left = new FormAttachment(outline, 5);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        properties.setLayoutData((Object)data);
        ISelectionChangedListener listener = this.createSelectionChangedListener();
        if (listener != null) {
            this.availablePalettesTableViewer.addSelectionChangedListener(listener);
        }
        return mainComposite;
    }

    protected ISelectionChangedListener createSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selectedElement = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (selectedElement instanceof PapyrusPaletteService.ExtendedProviderDescriptor) {
                    ((Button)PapyrusPaletteCustomizerDialog.this.paletteButtonsMap.get(22)).setEnabled(false);
                    ((Button)PapyrusPaletteCustomizerDialog.this.paletteButtonsMap.get(21)).setEnabled(true);
                    ((Button)PapyrusPaletteCustomizerDialog.this.paletteButtonsMap.get(23)).setEnabled(true);
                } else if (selectedElement instanceof PapyrusPaletteService.LocalProviderDescriptor) {
                    ((Button)PapyrusPaletteCustomizerDialog.this.paletteButtonsMap.get(22)).setEnabled(true);
                    ((Button)PapyrusPaletteCustomizerDialog.this.paletteButtonsMap.get(21)).setEnabled(true);
                    ((Button)PapyrusPaletteCustomizerDialog.this.paletteButtonsMap.get(23)).setEnabled(false);
                } else {
                    ((Button)PapyrusPaletteCustomizerDialog.this.paletteButtonsMap.get(22)).setEnabled(false);
                    ((Button)PapyrusPaletteCustomizerDialog.this.paletteButtonsMap.get(21)).setEnabled(false);
                    ((Button)PapyrusPaletteCustomizerDialog.this.paletteButtonsMap.get(23)).setEnabled(false);
                }
            }
        };
    }

    protected void addEntry(MouseEvent e) {
        ISelection selection = this.availableToolsTreeViewer.getSelection();
        PaletteEntry entry = null;
        if (selection instanceof IStructuredSelection) {
            Object firstElement = ((IStructuredSelection)selection).getFirstElement();
            if (!(firstElement instanceof PaletteEntry)) {
                return;
            }
            entry = (PaletteEntry)firstElement;
        }
        this.setActiveEntry(entry);
        PaletteEntry destContainer = this.getSelectedPaletteEntry();
        ((PapyrusPaletteCustomizer)this.getCustomizer()).storePaletteState(entry);
        if (destContainer instanceof PaletteContainer) {
            PaletteContainer oldParent = entry.getParent();
            PaletteContainer stdParent = (PaletteContainer)((PapyrusPaletteCustomizer)this.getCustomizer()).getChangedParents().get(entry);
            if (stdParent == null) {
                ((PapyrusPaletteCustomizer)this.getCustomizer()).getChangedParents().put(entry, entry.getParent());
            }
            oldParent.remove(entry);
            entry.setParent((PaletteContainer)destContainer);
            ((PaletteContainer)destContainer).add(entry);
        } else {
            PaletteRoot root = (PaletteRoot)PaletteUtil.getRoot((PaletteEntry)entry);
            if (root != null) {
                PaletteContainer oldParent = entry.getParent();
                PaletteContainer stdParent = (PaletteContainer)((PapyrusPaletteCustomizer)this.getCustomizer()).getChangedParents().get(entry);
                if (stdParent == null) {
                    ((PapyrusPaletteCustomizer)this.getCustomizer()).getChangedParents().put(entry, stdParent);
                }
                oldParent.remove(entry);
                entry.setParent((PaletteContainer)root);
                root.add(entry);
            }
        }
    }

    protected Control createAvailablePalettesViewer(Composite container) {
        Composite composite = new Composite(container, 0);
        composite.setFont(container.getFont());
        GridLayout layout = new GridLayout(5, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText(Messages.Available_Palettes);
        GridData data = new GridData(4, 0x1000000, true, false);
        nameLabel.setLayoutData((Object)data);
        this.createEditionPaletteButton(composite, 20, Activator.getImage((String)NEW_LOCAL_DESC_IMAGE), Messages.Dialog_Create_Palette_Tooltip);
        this.createEditionPaletteButton(composite, 21, Activator.getImage((String)EDIT_LOCAL_DESC_IMAGE), Messages.Dialog_Edit_Palette_Tooltip);
        this.createEditionPaletteButton(composite, 22, Activator.getImage((String)DELETE_LOCAL_DESC_IMAGE), Messages.Dialog_Delete_Palette_Tooltip);
        this.createEditionPaletteButton(composite, 23, Activator.getImage((String)RESTORE_DEFAULT_DESC_IMAGE), Messages.Dialog_Restore_Palette_Tooltip);
        this.availablePalettesTable = new Table(composite, 2080);
        this.availablePalettesTable.setFont(composite.getFont());
        this.availablePalettesTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 32) {
                    TableItem item = (TableItem)e.item;
                    PapyrusPaletteCustomizerDialog.this.changeProviderVisibility((PapyrusPaletteService.ProviderDescriptor)item.getData(), item.getChecked());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        data = new GridData(1296);
        data.horizontalSpan = 5;
        data.widthHint = 185;
        data.heightHint = 200;
        this.availablePalettesTable.setLayoutData((Object)data);
        this.availablePalettesTableViewer = new CheckboxTableViewer(this.availablePalettesTable);
        AvailablePalettesCheckStateProvider availablePalettesCheckStateProvider = new AvailablePalettesCheckStateProvider();
        this.availablePalettesTableViewer.setCheckStateProvider((ICheckStateProvider)availablePalettesCheckStateProvider);
        this.availablePalettesTableViewer.setContentProvider((IContentProvider)new PalettesTableContentProvider((TableViewer)this.availablePalettesTableViewer));
        this.providersLabelProvider = new PaletteLabelProvider((TableViewer)this.availablePalettesTableViewer);
        this.availablePalettesTableViewer.setLabelProvider((IBaseLabelProvider)this.providersLabelProvider);
        this.availablePalettesTableViewer.setInput((Object)PapyrusPaletteService.getInstance());
        this.availablePalettesTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                PapyrusPaletteCustomizerDialog.this.editSelectedPalette(selection);
            }
        });
        return composite;
    }

    protected Button createEditionPaletteButton(Composite parentConposite, int id, Image icon, String toolTip) {
        Button button = new Button(parentConposite, 0);
        button.setData((Object)new Integer(id));
        button.setImage(icon);
        button.setToolTipText(toolTip);
        button.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                PapyrusPaletteCustomizerDialog.this.buttonPressed((Integer)e.widget.getData());
            }
        });
        this.paletteButtonsMap.put(new Integer(id), button);
        return button;
    }

    protected void buttonPressed(int buttonId) {
        if (this.paletteButtonsMap.containsKey(buttonId)) {
            switch (buttonId) {
                case 20: {
                    this.createNewLocalPalette();
                    break;
                }
                case 21: {
                    IStructuredSelection selection = this.getPalettesTableSelection();
                    this.editSelectedPalette(selection);
                    break;
                }
                case 22: {
                    this.deleteLocalPalette();
                    break;
                }
                case 23: {
                    this.restoreExtendedPaletteToDefault();
                    break;
                }
            }
        } else {
            super.buttonPressed(buttonId);
        }
    }

    private IStructuredSelection getPalettesTableSelection() {
        ISelection selection;
        IStructuredSelection structuredSelection = null;
        if (this.availablePalettesTableViewer != null && (selection = this.availablePalettesTableViewer.getSelection()) instanceof IStructuredSelection) {
            structuredSelection = (IStructuredSelection)selection;
        }
        return structuredSelection;
    }

    protected void setButtonLayoutData(Button button) {
        if (this.paletteButtonsMap.containsValue(button)) {
            GridData data = new GridData(0x1000000, 0x1000000, false, false);
            button.setLayoutData((Object)data);
            button.setEnabled(false);
        } else {
            super.setButtonLayoutData(button);
        }
    }

    protected void createNewLocalPalette() {
        NewLocalPaletteWizard wizard = new NewLocalPaletteWizard(this.getActiveSashPage(), this.getCustomizer());
        WizardDialog wizardDialog = new WizardDialog(new Shell(), (IWizard)wizard);
        wizardDialog.open();
    }

    protected void deleteLocalPalette() {
        IStructuredSelection selection = (IStructuredSelection)this.availablePalettesTableViewer.getSelection();
        if (selection == null || !(selection.getFirstElement() instanceof PapyrusPaletteService.LocalProviderDescriptor)) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.Dialog_Not_Local_Palette_Title, (String)Messages.Dialog_Not_Local_Palette_Message);
        } else {
            PapyrusPaletteService.LocalProviderDescriptor descriptor = (PapyrusPaletteService.LocalProviderDescriptor)selection.getFirstElement();
            String id = descriptor.getContributionID();
            PapyrusPalettePreferences.deleteLocalPalette((String)id);
        }
    }

    protected void restoreExtendedPaletteToDefault() {
        IStructuredSelection selection = (IStructuredSelection)this.availablePalettesTableViewer.getSelection();
        if (selection == null || !(selection.getFirstElement() instanceof PapyrusPaletteService.ExtendedProviderDescriptor)) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.Dialog_Not_Extended_Palette_Title, (String)Messages.Dialog_Not_Extended_Palette_Message);
        } else {
            PapyrusPaletteService.ExtendedProviderDescriptor descriptor = (PapyrusPaletteService.ExtendedProviderDescriptor)selection.getFirstElement();
            String id = descriptor.getContributionID();
            PapyrusPalettePreferences.unregisterLocalRedefinition((String)id);
        }
    }

    protected void editSelectedPalette(IStructuredSelection selection) {
        if (selection != null) {
            if (selection.getFirstElement() instanceof PapyrusPaletteService.LocalProviderDescriptor) {
                this.editLocalPalette((PapyrusPaletteService.LocalProviderDescriptor)selection.getFirstElement());
            } else if (selection.getFirstElement() instanceof PapyrusPaletteService.ExtendedProviderDescriptor) {
                this.editExtendedPalette((PapyrusPaletteService.ExtendedProviderDescriptor)selection.getFirstElement());
            }
        }
    }

    protected void editLocalPalette(PapyrusPaletteService.LocalProviderDescriptor descriptor) {
        UpdateLocalPaletteWizard wizard = new UpdateLocalPaletteWizard(this.getActiveSashPage(), descriptor, this.getCustomizer());
        WizardDialog wizardDialog = new WizardDialog(new Shell(), (IWizard)wizard);
        wizardDialog.open();
    }

    protected void editExtendedPalette(PapyrusPaletteService.ExtendedProviderDescriptor descriptor) {
        String contributionID = descriptor.getContributionID();
        String paletteRedefinition = PapyrusPalettePreferences.getPaletteRedefinition((String)contributionID);
        if (paletteRedefinition == null) {
            PapyrusPalettePreferences.createPaletteRedefinition((PapyrusPaletteService.ExtendedProviderDescriptor)descriptor);
        }
        UpdateExtendedPaletteWizard wizard = new UpdateExtendedPaletteWizard(this.getActiveSashPage(), descriptor, this.getCustomizer());
        WizardDialog wizardDialog = new WizardDialog(new Shell(), (IWizard)wizard);
        wizardDialog.open();
    }

    protected void changeProviderVisibility(PapyrusPaletteService.ProviderDescriptor descriptor, boolean isChecked) {
        PapyrusPalettePreferences.changePaletteVisibility((String)descriptor.getContributionID(), (String)this.getActiveSashPage().getClass().getName(), (boolean)isChecked);
    }

    protected Composite createMainComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        PapyrusPaletteCustomizerDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected IEditorPart getActiveSashPage() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart editorPart = page.getActiveEditor();
        assert (editorPart != null);
        ISashWindowsContainer sashWindowsContainer = (ISashWindowsContainer)editorPart.getAdapter(ISashWindowsContainer.class);
        if (sashWindowsContainer != null) {
            return sashWindowsContainer.getActiveEditor();
        }
        return null;
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        String id = event.getKey();
        if ("paletteCustomization".equals(id) || "localPaletteDefinition".equals(id)) {
            this.availablePalettesTableViewer.setInput((Object)PapyrusPaletteService.getInstance());
        }
    }

    protected class AvailablePalettesCheckStateProvider
    implements ICheckStateProvider {
        protected AvailablePalettesCheckStateProvider() {
        }

        public boolean isChecked(Object element) {
            if (element instanceof PapyrusPaletteService.ProviderDescriptor) {
                return !PapyrusPalettePreferences.getHiddenPalettes((IEditorPart)PapyrusPaletteCustomizerDialog.this.getActiveSashPage()).contains(((PapyrusPaletteService.ProviderDescriptor)element).getContributionID());
            }
            return false;
        }

        public boolean isGrayed(Object element) {
            return false;
        }
    }

    protected class PaletteLabelProvider
    implements ILabelProvider {
        private Map<ImageDescriptor, Image> imageCache = new HashMap<ImageDescriptor, Image>();

        public PaletteLabelProvider(TableViewer viewer) {
        }

        public Image getImage(Object element) {
            if (element instanceof PapyrusPaletteService.LocalProviderDescriptor) {
                return Activator.getImage((String)"/icons/local_desc.gif");
            }
            if (element instanceof PapyrusPaletteService.ExtendedProviderDescriptor) {
                return Activator.getImage((String)"/icons/extended_plugin_desc.gif");
            }
            if (element instanceof PapyrusPaletteService.ProviderDescriptor) {
                return Activator.getImage((String)"/icons/plugin_desc.gif");
            }
            return Activator.getImage((String)"icons/papyrus/PapyrusLogo16x16.gif");
        }

        public String getText(Object element) {
            if (element instanceof PapyrusPaletteService.ProviderDescriptor) {
                return ((PapyrusPaletteService.ProviderDescriptor)element).getContributionName();
            }
            return "<undefined>";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
            Iterator<Image> images = this.imageCache.values().iterator();
            while (images.hasNext()) {
                images.next().dispose();
            }
            this.imageCache = null;
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    public class PalettesTableContentProvider
    implements IStructuredContentProvider {
        private PapyrusPaletteService paletteService;
        private final TableViewer viewer;

        public PalettesTableContentProvider(TableViewer tableViewer) {
            this.viewer = tableViewer;
        }

        public void dispose() {
            this.paletteService = null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput != null) {
                this.paletteService = (PapyrusPaletteService)newInput;
            }
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof PapyrusPaletteService) {
                List providers = ((PapyrusPaletteService)inputElement).getContributingProviders(PapyrusPaletteCustomizerDialog.this.getActiveSashPage(), PapyrusPaletteCustomizerDialog.this.getPaletteRoot());
                return providers.toArray();
            }
            return null;
        }
    }
}

