/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.common.core.internal.adapters.instances;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.facet.infra.common.core.internal.CommonEmfFacetActivator;
import org.eclipse.emf.facet.infra.common.core.internal.adapters.instances.MetaclassInstances;
import org.eclipse.emf.facet.infra.common.core.internal.adapters.instances.ModelChangeListener;
import org.eclipse.emf.facet.infra.common.core.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaclassInstancesAdapter
extends AdapterImpl
implements MetaclassInstances {
    private final Resource resource;
    private Map<EClass, Set<EObject>> instancesByEClass;
    private Map<EClass, Set<EObject>> instancesByType;
    private final List<ModelChangeListener> listeners = new ArrayList<ModelChangeListener>();

    protected MetaclassInstancesAdapter(Resource resource, boolean clearCache) {
        this.resource = resource;
        if (clearCache) {
            this.clearCache();
        }
    }

    @Override
    public void clearCache() {
        this.instancesByEClass = new HashMap<EClass, Set<EObject>>();
        this.instancesByType = new HashMap<EClass, Set<EObject>>();
        TreeIterator allContents = this.resource.getAllContents();
        while (allContents.hasNext()) {
            EObject eObject = (EObject)allContents.next();
            this.addModelElement(eObject, false);
        }
    }

    protected void addModelElement(EObject element, boolean recursively) {
        element.eAdapters().remove((Object)this);
        element.eAdapters().add((Object)this);
        List<EClass> eClasses = this.getEClasses(element);
        for (EClass eClass : eClasses) {
            if (eClass == null) {
                Logger.logWarning("Element has null eClass: " + element, (Plugin)CommonEmfFacetActivator.getDefault());
                continue;
            }
            this.associateToEClass(element, eClass);
            this.associateToType(element, eClass);
            EList allSuperTypes = eClass.getEAllSuperTypes();
            for (EClass superType : allSuperTypes) {
                this.associateToType(element, superType);
            }
            if (!recursively) continue;
            EList contents = element.eContents();
            for (EObject contained : contents) {
                this.addModelElement(contained, true);
            }
        }
    }

    protected void removeModelElement(EObject element, boolean recursively) {
        element.eAdapters().remove((Object)this);
        ArrayList<EClass> eClasses = new ArrayList<EClass>();
        for (Map.Entry<EClass, Set<EObject>> entry : this.instancesByEClass.entrySet()) {
            if (!entry.getValue().contains(element)) continue;
            eClasses.add(entry.getKey());
        }
        for (EClass eClass : eClasses) {
            this.disassociateFromEClass(element, eClass);
        }
        ArrayList<EClass> types = new ArrayList<EClass>();
        for (Map.Entry<EClass, Set<EObject>> entry : this.instancesByType.entrySet()) {
            if (!entry.getValue().contains(element)) continue;
            types.add(entry.getKey());
        }
        for (EClass eClass : types) {
            this.disassociateFromType(element, eClass);
        }
        if (recursively) {
            EList contents = element.eContents();
            for (EObject contained : contents) {
                this.removeModelElement(contained, true);
            }
        }
    }

    public void notifyChanged(Notification msg) {
        this.handleChanged(msg);
        this.notifyModelChanged(msg);
    }

    protected void handleChanged(Notification msg) {
        int eventType = msg.getEventType();
        Object feature = msg.getFeature();
        Object oldValue = msg.getOldValue();
        Object newValue = msg.getNewValue();
        switch (eventType) {
            case 3: {
                EReference reference;
                if (feature instanceof EReference && !(reference = (EReference)feature).isContainment()) {
                    return;
                }
                if (!(newValue instanceof EObject)) break;
                this.addModelElement((EObject)newValue, true);
                break;
            }
            case 4: {
                EReference reference;
                if (feature instanceof EReference && !(reference = (EReference)feature).isContainment()) {
                    return;
                }
                if (!(oldValue instanceof EObject)) break;
                this.removeModelElement((EObject)oldValue, true);
                break;
            }
            case 5: {
                if (!(newValue instanceof EList)) break;
                EList eList = (EList)newValue;
                for (Object object : eList) {
                    if (!(object instanceof EObject)) continue;
                    this.addModelElement((EObject)object, true);
                }
                break;
            }
            case 6: {
                if (!(newValue instanceof EList)) break;
                EList eList = (EList)newValue;
                for (Object object : eList) {
                    if (!(object instanceof EObject)) continue;
                    this.removeModelElement((EObject)object, true);
                }
                break;
            }
            case 1: {
                EReference reference;
                if (!(feature instanceof EReference) || !(reference = (EReference)feature).isContainment()) break;
                if (newValue == null) {
                    if (!(oldValue instanceof EObject)) break;
                    this.removeModelElement((EObject)oldValue, true);
                    break;
                }
                if (!(newValue instanceof EObject)) break;
                this.addModelElement((EObject)newValue, true);
                break;
            }
            case 2: {
                EReference reference;
                if (feature instanceof EReference && !(reference = (EReference)feature).isContainment() || !(oldValue instanceof EObject)) break;
                this.removeModelElement((EObject)oldValue, true);
            }
        }
    }

    protected List<EClass> getEClasses(EObject element) {
        return Collections.singletonList(element.eClass());
    }

    protected void associateToEClass(EObject element, EClass eClass) {
        Set<EObject> instancesForEClass = this.instancesByEClass.get(eClass);
        if (instancesForEClass == null) {
            instancesForEClass = new LinkedHashSet<EObject>();
            this.instancesByEClass.put(eClass, instancesForEClass);
        }
        instancesForEClass.add(element);
    }

    protected void associateToType(EObject element, EClass eClass) {
        Set<EObject> instancesForType = this.instancesByType.get(eClass);
        if (instancesForType == null) {
            instancesForType = new LinkedHashSet<EObject>();
            this.instancesByType.put(eClass, instancesForType);
        }
        instancesForType.add(element);
    }

    protected void disassociateFromEClass(EObject element, EClass eClass) {
        Set<EObject> instancesForEClass = this.instancesByEClass.get(eClass);
        if (instancesForEClass != null) {
            instancesForEClass.remove(element);
            if (instancesForEClass.isEmpty()) {
                this.instancesByEClass.remove(eClass);
            }
        }
    }

    protected void disassociateFromType(EObject element, EClass eClass) {
        Set<EObject> instancesForType = this.instancesByType.get(eClass);
        if (instancesForType != null) {
            instancesForType.remove(element);
            if (instancesForType.isEmpty()) {
                this.instancesByType.remove(eClass);
            }
        }
    }

    public boolean isAdapterForType(Object type) {
        return type == MetaclassInstances.class;
    }

    @Override
    public Set<EObject> getInstances(EClass eClass, boolean includingSubclasses) {
        Set<EObject> set = includingSubclasses ? this.instancesByType.get(eClass) : this.instancesByEClass.get(eClass);
        if (set == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(set);
    }

    protected Map<EClass, Set<EObject>> getInstancesByEClass() {
        return this.instancesByEClass;
    }

    protected Map<EClass, Set<EObject>> getInstancesByType() {
        return this.instancesByType;
    }

    protected Resource getResource() {
        return this.resource;
    }

    @Override
    public void addListener(ModelChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeListener(ModelChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyModelChanged(Notification msg) {
        for (ModelChangeListener listener : this.listeners) {
            listener.modelChanged(msg);
        }
    }
}

