/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.utils;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.infra.widgets.Activator;

public class EMFFileUtil {
    public static String getPath(IFile file) {
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        return uri.toString();
    }

    public static IFile getIFile(String location) {
        URI uri = URI.createURI((String)location);
        IWorkspaceRoot workspace = ResourcesPlugin.getWorkspace().getRoot();
        if (uri.isPlatform()) {
            Path workspacePath = new Path(uri.toPlatformString(true));
            return workspace.getFile((IPath)workspacePath);
        }
        Path absolutePath = new Path(URI.decode((String)location));
        return workspace.getFileForLocation((IPath)absolutePath);
    }

    public static File getFile(String location) {
        IFile iFile = EMFFileUtil.getIFile(location);
        if (iFile == null || !iFile.exists()) {
            return new File(location);
        }
        return new File(iFile.getLocationURI());
    }

    public static File getWorkspaceFile(String location) {
        IWorkspaceRoot workspace = ResourcesPlugin.getWorkspace().getRoot();
        Path path = new Path(location);
        IFile currentFile = null;
        try {
            currentFile = workspace.getFile((IPath)path);
        }
        catch (IllegalArgumentException ex) {
            Activator.log.error((Throwable)ex);
            return null;
        }
        return currentFile.getLocation().toFile();
    }
}

