/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.providers.strategy;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.papyrus.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.papyrus.emf.facet.custom.ui.internal.CustomizedTreeContentProvider;
import org.eclipse.papyrus.infra.emf.Activator;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.widgets.providers.IAdaptableContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IHierarchicContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticEMFContentProvider
extends CustomizedTreeContentProvider
implements IAdaptableContentProvider,
IHierarchicContentProvider,
IStaticContentProvider {
    protected EObject[] roots;
    protected List<?> metaclasses = new LinkedList();
    protected List<?> notWantedMetaclasses = new LinkedList();
    protected EObject eObject;
    protected EStructuralFeature feature;
    protected AdapterFactory factory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);

    protected SemanticEMFContentProvider() {
        super(Activator.getDefault().getCustomizationManager());
    }

    public SemanticEMFContentProvider(EObject editedEObject, EStructuralFeature feature, EObject[] roots, ICustomizationManager customizationManager) {
        super(customizationManager);
        this.roots = roots;
        this.configureMetaclasses(feature);
        this.eObject = editedEObject;
        this.feature = feature;
    }

    public SemanticEMFContentProvider(EObject editedEObject, EStructuralFeature feature, EObject[] roots) {
        this(editedEObject, feature, roots, Activator.getDefault().getCustomizationManager());
    }

    protected void configureMetaclasses(EStructuralFeature feature) {
        if (feature != null) {
            this.setWantedMetaclasses(Collections.singletonList(feature.getEType()));
        }
    }

    public SemanticEMFContentProvider(EObject editedEObject, EStructuralFeature feature) {
        this(editedEObject, feature, SemanticEMFContentProvider.findRoots(editedEObject));
    }

    public SemanticEMFContentProvider(EObject[] roots) {
        this(null, null, roots);
    }

    public SemanticEMFContentProvider(EObject[] roots, ICustomizationManager customizationManager) {
        this(null, null, roots, customizationManager);
    }

    public SemanticEMFContentProvider(ResourceSet root) {
        this(null, null, root);
    }

    public SemanticEMFContentProvider(EObject editedEObject, EStructuralFeature feature, ResourceSet root) {
        this(editedEObject, feature, SemanticEMFContentProvider.getRoots(root));
    }

    public void dispose() {
        try {
            if (this.factory instanceof IDisposable) {
                ((IDisposable)this.factory).dispose();
            }
        }
        finally {
            super.dispose();
        }
    }

    protected static EObject[] getRoots(ResourceSet root) {
        LinkedList roots = new LinkedList();
        if (root != null) {
            for (Resource resource : root.getResources()) {
                roots.addAll(resource.getContents());
            }
        }
        return roots.toArray(new EObject[roots.size()]);
    }

    protected static EObject[] findRoots(EObject source) {
        if (source.eResource() == null) {
            while (source.eContainer() != null) {
                source = source.eContainer();
            }
            return new EObject[]{source};
        }
        if (source.eResource().getResourceSet() == null) {
            return (EObject[])source.eResource().getContents().toArray((Object[])new EObject[0]);
        }
        return SemanticEMFContentProvider.getRoots(source.eResource().getResourceSet());
    }

    public EObject[] getRootElements(Object inputElement) {
        return this.roots;
    }

    public Object getAdaptedValue(Object containerElement) {
        return EMFHelper.getEObject(containerElement);
    }

    public boolean hasChildren(Object parent) {
        Object[] children = this.getChildren(parent);
        return children != null && children.length > 0;
    }

    public boolean isValidValue(Object containerElement) {
        Object semanticObject = this.getAdaptedValue(containerElement);
        if (semanticObject instanceof EReference || semanticObject == null) {
            return false;
        }
        if (this.metaclasses != null && !this.metaclasses.isEmpty()) {
            boolean compatible = false;
            for (Object metaclass : this.metaclasses) {
                if (!this.isCompatibleMetaclass(containerElement, metaclass)) continue;
                compatible = true;
                break;
            }
            if (!compatible) {
                return false;
            }
        }
        for (Object metaclass : this.notWantedMetaclasses) {
            if (!this.isCompatibleMetaclass(containerElement, metaclass)) continue;
            return false;
        }
        return true;
    }

    protected boolean isCompatibleMetaclass(Object containerElement, Object metaclass) {
        if (metaclass instanceof EClassifier) {
            Object semanticElement = this.getAdaptedValue(containerElement);
            return ((EClassifier)metaclass).isInstance(semanticElement);
        }
        return false;
    }

    public void setWantedMetaclasses(List<?> metaclasses) {
        this.metaclasses = metaclasses;
    }

    public void setNotWantedMetaclasses(List<?> notWantedMetaclasses) {
        assert (notWantedMetaclasses != null) : "notWantedMetaclasses must be not null";
        this.notWantedMetaclasses = notWantedMetaclasses;
    }

    public Object[] getElements() {
        return super.getElements(null);
    }

    public List<?> getWantedMetaclasses() {
        return this.metaclasses;
    }

    public List<?> getNotWantedMetaclasses() {
        return this.notWantedMetaclasses;
    }
}

