/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.advice;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.utils.IPageUtils;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;

public class RemovePageHelper {
    public static ICommand getRemovePageCommand(TransactionalEditingDomain editingDomain, EObject elementToDestroy) {
        try {
            Command command;
            IPageManager pageManager = ServiceUtilsForEObject.getInstance().getIPageManager(elementToDestroy);
            if (pageManager.allPages().contains(elementToDestroy) && (command = IPageUtils.getMemoizedCloseAllPagesCommand((TransactionalEditingDomain)editingDomain, (IPageManager)pageManager, (Object)elementToDestroy)) != null) {
                return new AbstractTransactionalCommand(editingDomain, "Delete page", null){

                    public boolean canExecute() {
                        return command.canExecute();
                    }

                    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                        command.execute();
                        return CommandResult.newOKCommandResult();
                    }
                };
            }
        }
        catch (ServiceException serviceException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

