/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.common.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.common.label.AbstractLabelGenerator;
import org.eclipse.ocl.examples.common.label.ILabelGenerator;
import org.eclipse.ocl.examples.common.label.LabelGeneratorRegistry;
import org.eclipse.ocl.examples.common.utils.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreUtils {
    @NonNull
    public static ILabelGenerator.Registry SIMPLE_NAME_REGISTRY = new LabelGeneratorRegistry(ILabelGenerator.Registry.INSTANCE);
    @NonNull
    public static ILabelGenerator.Registry QUALIFIED_NAME_REGISTRY = new LabelGeneratorRegistry(ILabelGenerator.Registry.INSTANCE);

    static {
        SIMPLE_NAME_REGISTRY.install(ENamedElement.class, new AbstractLabelGenerator<ENamedElement>(ENamedElement.class){

            @Override
            public void buildLabelFor(@NonNull ILabelGenerator.Builder labelBuilder, @NonNull ENamedElement labelledObject) {
                String name = labelledObject.getName();
                if (name != null) {
                    labelBuilder.appendString(name);
                } else {
                    labelBuilder.appendString("<null-named-");
                    labelBuilder.appendString(labelledObject.getClass().getSimpleName());
                    labelBuilder.appendString(">");
                }
            }
        });
        QUALIFIED_NAME_REGISTRY.install(ENamedElement.class, new AbstractLabelGenerator<ENamedElement>(ENamedElement.class){

            @Override
            public void buildLabelFor(@NonNull ILabelGenerator.Builder labelBuilder, @NonNull ENamedElement labelledObject) {
                String name = labelledObject.getName();
                if (name != null) {
                    labelBuilder.appendString(name);
                } else {
                    labelBuilder.appendString("<null-named-");
                    labelBuilder.appendString(labelledObject.getClass().getSimpleName());
                    labelBuilder.appendString(">");
                }
            }
        });
    }

    public static <E extends EObject> E copy(E newObject) {
        return (E)EcoreUtil.copy(newObject);
    }

    @Nullable
    public static String diagnoseUnresolvedProxies(@NonNull URI contextURI, @NonNull Map<EObject, Collection<EStructuralFeature.Setting>> map) {
        if (map.isEmpty()) {
            return null;
        }
        HashMap<String, Map.Entry<EObject, Collection<EStructuralFeature.Setting>>> unresolvedURIs = new HashMap<String, Map.Entry<EObject, Collection<EStructuralFeature.Setting>>>(map.size());
        for (Map.Entry<EObject, Collection<EStructuralFeature.Setting>> entry : map.entrySet()) {
            String uriString;
            EObject key = entry.getKey();
            URI uri = EcoreUtil.getURI((EObject)key);
            if (uri == null || unresolvedURIs.containsKey(uriString = uri.toString())) continue;
            unresolvedURIs.put(uriString, entry);
        }
        StringBuilder s = new StringBuilder();
        s.append("Unresolved URIs in '" + String.valueOf(contextURI) + "' :");
        for (Map.Entry unresolvedURI : unresolvedURIs.entrySet()) {
            s.append("\n    '" + (String)unresolvedURI.getKey() + "'");
        }
        return s.toString();
    }

    @NonNull
    public static String formatMultiplicity(@Nullable ETypedElement typedElement) {
        int upper;
        if (typedElement == null) {
            return "";
        }
        int lower = typedElement.getLowerBound();
        if (lower == (upper = typedElement.getUpperBound())) {
            return Integer.toString(lower);
        }
        if (lower == 0) {
            if (upper < 0) {
                return "*";
            }
            if (upper == 1) {
                return "?";
            }
        } else if (lower == 1 && upper < 0) {
            return "+";
        }
        return String.valueOf(Integer.toString(lower)) + ".." + (upper >= 0 ? Integer.toString(upper) : "*");
    }

    @NonNull
    public static String formatOrdered(@Nullable ETypedElement typedElement) {
        boolean isOrdered = typedElement != null ? typedElement.isOrdered() && typedElement.isMany() : false;
        return isOrdered ? "{ordered}" : "";
    }

    @NonNull
    public static String formatString(@Nullable String name) {
        return name != null ? name : "<null>";
    }

    @NonNull
    public static String formatUnique(@Nullable ETypedElement typedElement) {
        boolean isOrdered = typedElement != null ? typedElement.isUnique() && typedElement.isMany() : false;
        return isOrdered ? "{unique}" : "";
    }

    @Nullable
    public static <T extends Adapter> T getAdapter(@Nullable Notifier notifier, Class<T> adapterClass) {
        if (notifier == null) {
            return null;
        }
        return EcoreUtils.getAdapter((List<Adapter>)notifier.eAdapters(), adapterClass);
    }

    public static <T extends Adapter> T getAdapter(List<Adapter> eAdapters, Class<T> adapterClass) {
        return (T)EcoreUtil.getAdapter(eAdapters, adapterClass);
    }

    public static EClassifier getEType(EObject sourceObject, @NonNull EStructuralFeature feature) {
        EGenericType targetGenericType = feature.getEGenericType();
        ETypeParameter targetTypeParameter = targetGenericType.getETypeParameter();
        if (targetTypeParameter != null && sourceObject != null) {
            EClass sourceGenericType = feature.getEContainingClass();
            EObject typeParameterContainer = targetTypeParameter.eContainer();
            EClass sourceClass = sourceObject.eClass();
            EList allSourceGenericSuperTypes = sourceClass.getEAllGenericSuperTypes();
            for (EGenericType sourceGenericSuperType : allSourceGenericSuperTypes) {
                if (sourceGenericSuperType.getERawType() != typeParameterContainer) continue;
                EList sourceTypeArguments = sourceGenericSuperType.getETypeArguments();
                int i = sourceGenericType.getETypeParameters().indexOf((Object)targetTypeParameter);
                if (i < 0 || i >= sourceTypeArguments.size()) continue;
                EGenericType sourceTypeArgument = (EGenericType)sourceTypeArguments.get(i);
                return sourceTypeArgument.getERawType();
            }
        }
        return targetGenericType.getERawType();
    }

    @Nullable
    public static EOperation getEcoreInvariant(@NonNull EClass eClass, @NonNull String name) {
        for (EOperation eOperation : eClass.getEOperations()) {
            if (!ClassUtils.equals(name, eOperation.getName()) || !EcoreUtil.isInvariant((EOperation)eOperation)) continue;
            return eOperation;
        }
        return null;
    }

    public static <T> int getFeatureID(@NonNull Notification notification, @Nullable T expectedNotifier, @NonNull Class<T> featureClass) {
        if (expectedNotifier == null) {
            return -1;
        }
        Object notifier = notification.getNotifier();
        if (notifier != expectedNotifier) {
            return -1;
        }
        T castNotifier = ClassUtils.asClassOrNull(notifier, featureClass);
        if (castNotifier == null) {
            throw new IllegalArgumentException("EcoreUtils.getFeatureID: " + featureClass.getName() + " for a " + notifier.getClass().getName());
        }
        return notification.getFeatureID(featureClass);
    }

    @Nullable
    public static <T extends ENamedElement> T getNamedElement(@Nullable Collection<T> elements, String name) {
        if (elements == null) {
            return null;
        }
        for (ENamedElement element : elements) {
            if (!ClassUtils.equals(name, element.getName())) continue;
            return (T)element;
        }
        return null;
    }

    @Nullable
    public static <T extends ENamedElement, R extends T> R getNamedElement(@Nullable Collection<T> elements, @Nullable String name, @Nullable Class<R> returnClass) {
        if (elements == null) {
            return null;
        }
        if (name == null) {
            return null;
        }
        if (returnClass == null) {
            return null;
        }
        for (ENamedElement element : elements) {
            if (!returnClass.isAssignableFrom(element.getClass()) || !ClassUtils.equals(name, element.getName())) continue;
            return (R)element;
        }
        return null;
    }

    @NonNull
    public static String qualifiedNameFor(@Nullable Object object) {
        if (object == null) {
            return "<<null>>";
        }
        HashMap options = new HashMap();
        options.put(ILabelGenerator.Builder.SHOW_QUALIFIER, "::");
        return QUALIFIED_NAME_REGISTRY.labelFor(object, options);
    }

    @NonNull
    public static String simpleNameFor(@Nullable Object object) {
        if (object == null) {
            return "<<null>>";
        }
        return SIMPLE_NAME_REGISTRY.labelFor(object);
    }
}

