/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.MARTE_Library.MeasurementUnits;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DataSizeUnitKind implements Enumerator
{
    BIT(0, "bit", "bit"),
    BYTE(1, "Byte", "Byte"),
    KB(2, "KB", "KB"),
    MB(3, "MB", "MB"),
    GB(4, "GB", "GB");

    public static final int BIT_VALUE = 0;
    public static final int BYTE_VALUE = 1;
    public static final int KB_VALUE = 2;
    public static final int MB_VALUE = 3;
    public static final int GB_VALUE = 4;
    private static final DataSizeUnitKind[] VALUES_ARRAY;
    public static final List<DataSizeUnitKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DataSizeUnitKind[]{BIT, BYTE, KB, MB, GB};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DataSizeUnitKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DataSizeUnitKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DataSizeUnitKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DataSizeUnitKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DataSizeUnitKind get(int value) {
        switch (value) {
            case 0: {
                return BIT;
            }
            case 1: {
                return BYTE;
            }
            case 2: {
                return KB;
            }
            case 3: {
                return MB;
            }
            case 4: {
                return GB;
            }
        }
        return null;
    }

    private DataSizeUnitKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

