/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.MARTE.MARTE_Foundations.NFPs;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ConstraintKind implements Enumerator
{
    REQUIRED(0, "required", "required"),
    OFFERED(1, "offered", "offered"),
    CONTRACT(2, "contract", "contract");

    public static final int REQUIRED_VALUE = 0;
    public static final int OFFERED_VALUE = 1;
    public static final int CONTRACT_VALUE = 2;
    private static final ConstraintKind[] VALUES_ARRAY;
    public static final List<ConstraintKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ConstraintKind[]{REQUIRED, OFFERED, CONTRACT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ConstraintKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConstraintKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ConstraintKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConstraintKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ConstraintKind get(int value) {
        switch (value) {
            case 0: {
                return REQUIRED;
            }
            case 1: {
                return OFFERED;
            }
            case 2: {
                return CONTRACT;
            }
        }
        return null;
    }

    private ConstraintKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

