/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.MARTE.MARTE_Foundations.Alloc;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum AllocationKind implements Enumerator
{
    STRUCTURAL(0, "structural", "structural"),
    BEHAVIORAL(1, "behavioral", "behavioral"),
    HYBRID(2, "hybrid", "hybrid");

    public static final int STRUCTURAL_VALUE = 0;
    public static final int BEHAVIORAL_VALUE = 1;
    public static final int HYBRID_VALUE = 2;
    private static final AllocationKind[] VALUES_ARRAY;
    public static final List<AllocationKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AllocationKind[]{STRUCTURAL, BEHAVIORAL, HYBRID};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AllocationKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AllocationKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AllocationKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AllocationKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AllocationKind get(int value) {
        switch (value) {
            case 0: {
                return STRUCTURAL;
            }
            case 1: {
                return BEHAVIORAL;
            }
            case 2: {
                return HYBRID;
            }
        }
        return null;
    }

    private AllocationKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

