/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.MARTE.MARTE_DesignModel.SRM.SW_Interaction;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum MessageResourceKind implements Enumerator
{
    MESSAGE_QUEUE(0, "MessageQueue", "MessageQueue"),
    PIPE(1, "Pipe", "Pipe"),
    BLACKBOARD(2, "Blackboard", "Blackboard"),
    UNDEF(3, "Undef", "Undef"),
    OTHER(4, "Other", "Other");

    public static final int MESSAGE_QUEUE_VALUE = 0;
    public static final int PIPE_VALUE = 1;
    public static final int BLACKBOARD_VALUE = 2;
    public static final int UNDEF_VALUE = 3;
    public static final int OTHER_VALUE = 4;
    private static final MessageResourceKind[] VALUES_ARRAY;
    public static final List<MessageResourceKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new MessageResourceKind[]{MESSAGE_QUEUE, PIPE, BLACKBOARD, UNDEF, OTHER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static MessageResourceKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MessageResourceKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MessageResourceKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MessageResourceKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MessageResourceKind get(int value) {
        switch (value) {
            case 0: {
                return MESSAGE_QUEUE;
            }
            case 1: {
                return PIPE;
            }
            case 2: {
                return BLACKBOARD;
            }
            case 3: {
                return UNDEF;
            }
            case 4: {
                return OTHER;
            }
        }
        return null;
    }

    private MessageResourceKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

