/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.Iterator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;

public abstract class AbstractPointListShape
extends Shape {
    PointList points = new PointList();

    public boolean containsPoint(int x, int y) {
        if (!super.containsPoint(x, y)) {
            return false;
        }
        return this.shapeContainsPoint(x, y) || this.childrenContainsPoint(x, y);
    }

    protected boolean childrenContainsPoint(int x, int y) {
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            IFigure nextChild = (IFigure)it.next();
            if (!nextChild.containsPoint(x, y)) continue;
            return true;
        }
        return false;
    }

    protected abstract boolean shapeContainsPoint(int var1, int var2);

    public void addPoint(Point pt) {
        this.points.addPoint(pt);
        this.repaint();
    }

    public Point getStart() {
        return this.points.getFirstPoint();
    }

    public Point getEnd() {
        return this.points.getLastPoint();
    }

    public PointList getPoints() {
        return this.points;
    }

    public void insertPoint(Point pt, int index) {
        this.points.insertPoint(pt, index);
        this.repaint();
    }

    public void removeAllPoints() {
        this.erase();
        this.points.removeAllPoints();
    }

    public void removePoint(int index) {
        this.erase();
        this.points.removePoint(index);
        this.repaint();
    }

    public void setStart(Point start) {
        if (this.points.size() == 0) {
            this.addPoint(start);
        } else {
            this.setPoint(start, 0);
        }
    }

    public void setEnd(Point end) {
        if (this.points.size() < 2) {
            this.addPoint(end);
        } else {
            this.setPoint(end, this.points.size() - 1);
        }
    }

    public void setEndpoints(Point start, Point end) {
        this.setStart(start);
        this.setEnd(end);
    }

    public void setPoint(Point pt, int index) {
        this.erase();
        this.points.setPoint(pt, index);
        this.repaint();
    }

    public void setPoints(PointList points) {
        this.erase();
        this.points = points;
        this.repaint();
    }
}

