/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.evm.specific.event;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.scope.IBaseIndex;
import org.eclipse.incquery.runtime.api.scope.IInstanceObserver;
import org.eclipse.incquery.runtime.evm.notification.AttributeMonitor;

public class LightweightAttributeMonitor<MatchType extends IPatternMatch>
extends AttributeMonitor<MatchType> {
    private IInstanceObserver observer;
    private Multimap<Object, MatchType> observedMultimap;
    private IBaseIndex index;

    public LightweightAttributeMonitor(IBaseIndex index) {
        this.index = index;
        this.observer = new IInstanceObserver(){

            public void notifyBinaryChanged(Object sourceElement, Object edgeType) {
                Collection matches = LightweightAttributeMonitor.this.observedMultimap.get(sourceElement);
                for (IPatternMatch matchType : matches) {
                    LightweightAttributeMonitor.this.notifyListeners(matchType);
                }
            }

            public void notifyTernaryChanged(Object sourceElement, Object edgeType) {
                Collection matches = LightweightAttributeMonitor.this.observedMultimap.get(sourceElement);
                for (IPatternMatch matchType : matches) {
                    LightweightAttributeMonitor.this.notifyListeners(matchType);
                }
            }
        };
        this.observedMultimap = HashMultimap.create();
    }

    @Override
    public void registerFor(MatchType atom) {
        Collection<Object> allObjects = this.findAllObjects(atom);
        for (Object object : allObjects) {
            this.index.addInstanceObserver(this.observer, object);
            this.observedMultimap.put(object, atom);
        }
    }

    @Override
    public void unregisterForAll() {
        for (Object eobj : this.observedMultimap.keySet()) {
            this.index.removeInstanceObserver(this.observer, eobj);
        }
    }

    @Override
    public void unregisterFor(MatchType atom) {
        Collection<Object> allObjects = this.findAllObjects(atom);
        for (Object object : allObjects) {
            this.index.removeInstanceObserver(this.observer, object);
            this.observedMultimap.remove(object, atom);
        }
    }

    private Collection<Object> findAllObjects(MatchType atom) {
        ArrayList objs = Lists.newArrayList();
        for (String param : atom.parameterNames()) {
            Object location = atom.get(param);
            objs.add(location);
        }
        return objs;
    }
}

