/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.modelexplorer.handler;

import com.google.common.base.Optional;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.papyrus.infra.core.utils.AdapterUtils;
import org.eclipse.papyrus.infra.widgets.util.IRevealSemanticElement;
import org.eclipse.papyrus.infra.widgets.util.NavigationTarget;
import org.eclipse.papyrus.infra.widgets.util.RevealSemanticElementWrapper;
import org.eclipse.papyrus.uml.modelexplorer.util.ModelExplorerUtils;
import org.eclipse.papyrus.uml.service.types.handlers.AbstractUmlCreateCommandHandler;
import org.eclipse.papyrus.uml.service.types.utils.ICommandContext;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.uml2.uml.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUmlModelExplorerCreateCommandHandler
extends AbstractUmlCreateCommandHandler {
    protected ICommandContext getCommandContext() {
        return ModelExplorerUtils.getSelectionCommandContext();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object result = super.execute(event);
        if (result instanceof Element) {
            this.handleElementsCreated(Collections.singleton((Element)result), event);
        } else if (result instanceof Collection) {
            this.handleElementsCreated((Collection)result, event);
        }
        return result;
    }

    protected void handleElementsCreated(Collection<?> elements, ExecutionEvent event) {
        if (elements.isEmpty()) {
            return;
        }
        NavigationTarget target = this.getNavigationTarget(event);
        if (target == null) {
            return;
        }
        target.revealElement(elements);
    }

    protected NavigationTarget getNavigationTarget(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart == null) {
            return null;
        }
        Optional navigationTarget = AdapterUtils.adapt((Object)activePart, NavigationTarget.class);
        if (navigationTarget.isPresent()) {
            return (NavigationTarget)navigationTarget.get();
        }
        Optional revealSemantic = AdapterUtils.adapt((Object)activePart, IRevealSemanticElement.class);
        if (revealSemantic.isPresent()) {
            return new RevealSemanticElementWrapper((IRevealSemanticElement)revealSemantic.get());
        }
        return null;
    }
}

