/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.clazz.custom.command;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.clazz.custom.edit.part.CContainmentCircleEditPart;
import org.eclipse.papyrus.uml.diagram.clazz.custom.helper.ContainmentHelper;
import org.eclipse.papyrus.uml.diagram.clazz.edit.parts.ClassEditPart;
import org.eclipse.papyrus.uml.diagram.clazz.edit.parts.ContainmentSubLinkEditPart;
import org.eclipse.papyrus.uml.diagram.clazz.edit.parts.PackageEditPart;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.PackageableElement;

public class ContainmentLinkReorientCommand
extends AbstractTransactionalCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;
    private EditPart myTargetEditPart;
    private EObject oldEndVisualParent;

    public ContainmentLinkReorientCommand(ReorientReferenceRelationshipRequest req, EditPart editPartTarget) {
        super(req.getEditingDomain(), req.getLabel(), null);
        View oldEndView;
        this.myTargetEditPart = editPartTarget;
        this.reorientDirection = req.getDirection();
        if (this.reorientDirection == 1) {
            oldEndView = ((Edge)req.getParameter("connection_view")).getSource();
        } else if (this.reorientDirection == 2) {
            oldEndView = ((Edge)req.getParameter("connection_view")).getTarget();
        } else {
            throw new IllegalStateException();
        }
        this.oldEndVisualParent = ((View)oldEndView.eContainer()).getElement();
        this.oldEnd = req.getOldRelationshipEnd();
        this.newEnd = req.getNewRelationshipEnd();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    public boolean canExecute() {
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        return false;
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof PackageableElement) || !(this.newEnd instanceof PackageableElement)) {
            return false;
        }
        if (this.getNewTarget().equals(this.getOldTarget().getOwner())) {
            return false;
        }
        if (EcoreUtil.isAncestor((EObject)this.getNewTarget(), (EObject)this.getOldTarget())) {
            return false;
        }
        return this.newEnd != null;
    }

    protected CommandResult reorientSource() throws ExecutionException {
        throw new ExecutionException("Cannot reorient a source of Containment link");
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        Element source = this.getOldTarget().getOwner();
        EObject moveOldTargetTo = this.getOldTargetOwner();
        Element moveNewTargetTo = source;
        ContainmentHelper helper = new ContainmentHelper(this.getEditingDomain());
        helper.move((EObject)this.getOldTarget(), moveOldTargetTo);
        helper.move((EObject)this.getNewTarget(), (EObject)moveNewTargetTo);
        this.deleteOldLinkEditPart();
        return CommandResult.newOKCommandResult();
    }

    private boolean deleteOldLinkEditPart() {
        if (this.myTargetEditPart instanceof ClassEditPart || this.myTargetEditPart instanceof PackageEditPart) {
            CompoundCommand cc = new CompoundCommand();
            for (Object currentLink : ((AbstractGraphicalEditPart)this.myTargetEditPart).getTargetConnections()) {
                ContainmentSubLinkEditPart addedLinkEP;
                if (!(currentLink instanceof ContainmentSubLinkEditPart) || !((addedLinkEP = (ContainmentSubLinkEditPart)((Object)currentLink)).getSource() instanceof CContainmentCircleEditPart)) continue;
                if (((CContainmentCircleEditPart)addedLinkEP.getSource()).getSourceConnections().size() == 1) {
                    cc.add((Command)new ICommandProxy((ICommand)new DeleteCommand(this.getEditingDomain(), (View)addedLinkEP.getSource().getModel())));
                }
                cc.add((Command)new ICommandProxy((ICommand)new DeleteCommand(this.getEditingDomain(), addedLinkEP.getNotationView())));
            }
            cc.execute();
        }
        return true;
    }

    private PackageableElement getOldTarget() {
        return (PackageableElement)this.oldEnd;
    }

    private PackageableElement getNewTarget() {
        return (PackageableElement)this.newEnd;
    }

    private EObject getOldTargetOwner() {
        return this.oldEndVisualParent;
    }
}

