/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.clazz.custom.command;

import java.util.HashSet;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.clazz.custom.command.AbstractCustomCommand;
import org.eclipse.papyrus.uml.diagram.clazz.custom.helper.NamedElementHelper;
import org.eclipse.papyrus.uml.diagram.clazz.custom.ui.AssociationSelectionDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;

public class AttachInstanceSpecifcationCommand
extends AbstractCustomCommand {
    protected IAdaptable viewAdapter;
    protected CreateConnectionViewRequest req;
    protected InstanceSpecification source;
    protected InstanceSpecification target;
    protected HashSet<Association> commonAssociations = new HashSet();

    public AttachInstanceSpecifcationCommand(TransactionalEditingDomain domain, CreateConnectionViewRequest req, IAdaptable viewAdapter, EditPartViewer viewer) {
        super(domain, "attach instance", null);
        this.viewAdapter = viewAdapter;
        this.viewer = viewer;
        this.req = req;
    }

    public boolean canExecute() {
        if (this.req.getSourceEditPart() == null && this.req.getTargetEditPart() != null) {
            InstanceSpecification instance;
            this.target = (InstanceSpecification)((View)this.req.getTargetEditPart().getModel()).getElement();
            if (((View)this.req.getTargetEditPart().getModel()).getElement() instanceof InstanceSpecification && (instance = (InstanceSpecification)((View)this.req.getTargetEditPart().getModel()).getElement()).getClassifiers().size() > 0) {
                HashSet assoSource = new HashSet();
                for (Classifier classifier : this.target.getClassifiers()) {
                    assoSource.addAll(classifier.getAssociations());
                }
                if (assoSource.size() > 0) {
                    return true;
                }
            }
            return false;
        }
        if (this.req.getSourceEditPart() != null && this.req.getTargetEditPart() != null) {
            if (!(((View)this.req.getSourceEditPart().getModel()).getElement() instanceof InstanceSpecification)) {
                return false;
            }
            if (!(((View)this.req.getTargetEditPart().getModel()).getElement() instanceof InstanceSpecification)) {
                return false;
            }
            this.source = (InstanceSpecification)((View)this.req.getSourceEditPart().getModel()).getElement();
            this.target = (InstanceSpecification)((View)this.req.getTargetEditPart().getModel()).getElement();
            if (this.source.getClassifiers().size() == 0 || this.target.getClassifiers().size() == 0) {
                return false;
            }
            HashSet assoSource = new HashSet();
            for (Classifier classifier : this.source.getClassifiers()) {
                assoSource.addAll(classifier.getAssociations());
            }
            HashSet assoTarget = new HashSet();
            for (Classifier classifier : this.target.getClassifiers()) {
                assoTarget.addAll(classifier.getAssociations());
            }
            assoSource.retainAll(assoTarget);
            this.commonAssociations = new HashSet();
            this.commonAssociations.addAll(assoSource);
            return this.commonAssociations.size() > 0;
        }
        return false;
    }

    @Override
    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        View view = (View)this.viewAdapter.getAdapter(View.class);
        Association selectedAssociation = null;
        if (this.source.getClassifiers().size() > 0 && this.target.getClassifiers().size() > 0) {
            AssociationSelectionDialog associationSelectionDialog = new AssociationSelectionDialog(new Shell(), 8, this.commonAssociations);
            associationSelectionDialog.open();
            selectedAssociation = associationSelectionDialog.getSelectedAssociation();
            if (view != null && view.eContainer() != null) {
                View parent = (View)view.eContainer();
                InstanceSpecification instanceSpecification = UMLFactory.eINSTANCE.createInstanceSpecification();
                if (parent.getElement() instanceof Package) {
                    ((Package)parent.getElement()).getPackagedElements().add((Object)instanceSpecification);
                }
                instanceSpecification.setName(NamedElementHelper.EINSTANCE.getNewUMLElementName(instanceSpecification.getOwner(), instanceSpecification.eClass()));
                instanceSpecification.getClassifiers().add((Object)selectedAssociation);
                view.setElement((EObject)instanceSpecification);
                for (Property property : selectedAssociation.getMemberEnds()) {
                    Slot slot = UMLFactory.eINSTANCE.createSlot();
                    slot.setDefiningFeature((StructuralFeature)property);
                    if (this.source.getClassifiers().contains((Object)property.getOwner())) {
                        this.source.getSlots().add((Object)slot);
                        this.associateValue(this.target, slot, property.getType());
                        continue;
                    }
                    if (this.target.getClassifiers().contains((Object)property.getOwner())) {
                        this.target.getSlots().add((Object)slot);
                        this.associateValue(this.source, slot, property.getType());
                        continue;
                    }
                    instanceSpecification.getSlots().add((Object)slot);
                    if (this.source.getClassifiers().contains((Object)property.getType())) {
                        this.associateValue(this.source, slot, property.getType());
                        continue;
                    }
                    this.associateValue(this.target, slot, property.getType());
                }
            }
        }
        return null;
    }

    protected InstanceValue associateValue(InstanceSpecification instanceSpecification, Slot owner, Type type) {
        InstanceValue iv = UMLFactory.eINSTANCE.createInstanceValue();
        iv.setName(NamedElementHelper.EINSTANCE.getNewUMLElementName((Element)owner, iv.eClass()));
        iv.setType(type);
        iv.setInstance(this.target);
        owner.getValues().add((Object)iv);
        return iv;
    }
}

