/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.lpg;

import java.util.ArrayList;
import lpg.runtime.ErrorToken;
import lpg.runtime.ILexStream;
import lpg.runtime.IToken;
import lpg.runtime.PrsStream;
import org.eclipse.ocl.lpg.BasicEnvironment;

public class DerivedPrsStream
extends PrsStream {
    private BasicEnvironment environment;

    public DerivedPrsStream(BasicEnvironment env, ILexStream iLexStream) {
        super(iLexStream);
        this.environment = env;
    }

    public ErrorToken getErrorTokenAtCharacter(int offset) {
        ErrorToken bestToken = null;
        int i = this.getSize();
        while (--i >= 0) {
            IToken token = this.getTokenAt(i);
            if (!(token instanceof ErrorToken)) break;
            IToken errorToken = ((ErrorToken)token).getErrorToken();
            if (offset < errorToken.getStartOffset() || offset > errorToken.getEndOffset() || bestToken != null && (bestToken.getStartOffset() > errorToken.getStartOffset() || token.getEndOffset() > errorToken.getEndOffset())) continue;
            bestToken = (ErrorToken)token;
        }
        return bestToken;
    }

    public int getErrorTokens() {
        return this.getTokens().size() - this.getStreamLength();
    }

    public int getTokenIndexAtCharacter(int offset) {
        int low = 0;
        int high = this.getSize();
        while (high > low) {
            IToken highToken = this.getTokenAt(high - 1);
            if (!(highToken instanceof ErrorToken)) break;
            --high;
        }
        while (high > low) {
            int mid = (high + low) / 2;
            IToken mid_element = this.getTokenAt(mid);
            if (offset >= mid_element.getStartOffset() && offset <= mid_element.getEndOffset()) {
                return mid;
            }
            if (offset < mid_element.getStartOffset()) {
                high = mid;
                continue;
            }
            low = mid + 1;
        }
        return -(low - 1);
    }

    public int makeErrorToken(int firsttok, int lasttok, int errortok, int kind) {
        ArrayList tokens = this.getTokens();
        int index = tokens.size();
        ErrorToken token = new ErrorToken(this.getIToken(firsttok), this.getIToken(lasttok), this.getIToken(errortok), this.getStartOffset(firsttok), this.getEndOffset(lasttok), kind){

            public String toString() {
                if (this.getIPrsStream() == null) {
                    return "<toString>";
                }
                int startOffset = this.getStartOffset();
                int length = this.getEndOffset() + 1 - startOffset;
                if (length < 0) {
                    length = -length - 1;
                    startOffset = this.getEndOffset();
                }
                if (startOffset + length > this.getIPrsStream().getInputChars().length) {
                    return String.valueOf('\uffff');
                }
                return new String(this.getIPrsStream().getInputChars(), startOffset, length);
            }
        };
        token.setTokenIndex(index);
        tokens.add(token);
        token.setAdjunctIndex(this.getAdjuncts().size());
        return index;
    }

    public void reportError(int errorCode, int leftToken, int errorToken, int rightToken, String[] errorInfo) {
        if (this.environment == null) {
            super.reportError(errorCode, leftToken, errorToken, rightToken, errorInfo);
        } else {
            String tokenText;
            String string = tokenText = errorInfo.length > 0 ? errorInfo[0] : "";
            if (errorCode == 6 || errorCode == 8) {
                tokenText = "";
            }
            this.environment.parserError(errorCode, leftToken, rightToken, tokenText);
        }
    }

    public final void reportErrorTokenMessage(int error_token, String msg) {
        int lasttok;
        int firsttok = super.getFirstRealToken(error_token);
        if (firsttok > (lasttok = super.getLastRealToken(error_token))) {
            this.reportError(3, lasttok, lasttok, msg);
        } else {
            this.reportError(5, firsttok, lasttok, msg);
        }
    }
}

