/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dsml.validation.wizard;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.papyrus.customization.plugin.PluginEditor;
import org.eclipse.papyrus.dsml.validation.model.elements.impl.ValidationRuleImpl;
import org.eclipse.papyrus.dsml.validation.model.elements.interfaces.Category;
import org.eclipse.papyrus.dsml.validation.model.elements.interfaces.IConstraintProvider;
import org.eclipse.papyrus.dsml.validation.model.elements.interfaces.IConstraintsCategory;
import org.eclipse.papyrus.dsml.validation.model.elements.interfaces.IConstraintsManager;
import org.eclipse.papyrus.dsml.validation.model.elements.interfaces.IValidationRule;
import org.eclipse.papyrus.dsml.validation.model.profilenames.Utils;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Stereotype;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ValidationPluginGenerator {
    private static final String XML_CONSTRAINT_TARGET = "target";
    private static final String XML_CONSTRAINT_MESSAGE = "message";
    private static final String XML_CONSTRAINT_CLASS = "class";
    private static final String XML_CONSTRAINT_IS_ENABLED_BY_DEFAULT = "isEnabledByDefault";
    private static final String JAVA_LANGUAGE = "Java";
    private static final String OCL_LANGUAGE = "OCL";
    private static final String XML_CONSTRAINT_MODE = "mode";
    private static final String XML_CONSTRAINT_SEVERITY = "severity";
    private static final String XML_CONSTRAINT_STATUS_CODE = "statusCode";
    private static final String XML_CONSTRAINT_LANG = "lang";
    private static final String XML_CONSTRAINT_NAME = "name";
    private static final String SEPARATOR = ".";
    private static final String EMF_VALIDATION_CONSTRAINT_CHILD = "constraint";
    private static final String ID = "id";
    private static final String EMF_VALIDATION_CONSTRAINT_PROVIDERS_EXTENSIONPOINT = "org.eclipse.emf.validation.constraintProviders";
    private static final String EMF_VALIDATION_CONSTRAINT_BINDINGS_EXTENSIONPOINT = "org.eclipse.emf.validation.constraintBindings";
    private static final String UML_PLUGIN = "org.eclipse.uml2.uml";
    private static final String EMF_VALIDATION_PLUGIN = "org.eclipse.emf.validation";
    private static final String UML_URL = "http://www.eclipse.org/uml2/5.0.0/UML";
    public static ValidationPluginGenerator instance = new ValidationPluginGenerator();
    private static final String PLUGIN_NATURE_ID = "org.eclipse.pde.PluginNature";
    private IConstraintsManager constraintsManager;

    public void generate(IProject project, IConstraintsManager constraintsManager, EPackage definition) throws CoreException, IOException, SAXException, ParserConfigurationException {
        this.constraintsManager = constraintsManager;
        PluginEditor editor = new PluginEditor(project);
        String pluginID = editor.getSymbolicBundleName();
        if (editor.getBundleName() == null) {
            editor.setBundleName(pluginID);
        }
        editor.setSingleton(true);
        editor.getBuildEditor().addToBuild("plugin.xml");
        HashSet<String> natures = new HashSet<String>();
        natures.add(PLUGIN_NATURE_ID);
        editor.addNatures(natures);
        editor.getManifestEditor().addDependency(EMF_VALIDATION_PLUGIN);
        editor.getManifestEditor().addDependency(UML_PLUGIN);
        Element constraintProviderExtension = this.createOrCleanExtension(editor, EMF_VALIDATION_CONSTRAINT_PROVIDERS_EXTENSIONPOINT);
        this.createHierarchyOfCategories(pluginID, this.constraintsManager.getPrimeCategory(), constraintProviderExtension, editor);
        for (IConstraintProvider constraintProvider : constraintsManager.getConstraintsProviders()) {
            Element extElForConstraintsProvider = this.createExtensionForConstraintsProvider(constraintProvider, constraintProviderExtension, editor, definition);
            for (IConstraintsCategory constraintCategory : constraintProvider.getConstraintsCategories()) {
                Element extElForConstraintsCategory = this.createExtensionForConstraintsCategory(pluginID, constraintCategory, extElForConstraintsProvider, editor, constraintsManager);
                for (IValidationRule constraint : constraintCategory.getConstraints()) {
                    if (Utils.hasSpecificationForJava((Constraint)constraint.getConstraint()).booleanValue()) {
                        this.createExtensionForConstraint(pluginID, constraint, extElForConstraintsCategory, editor);
                    }
                    if (!Utils.hasSpecificationForOCL((Constraint)constraint.getConstraint()).booleanValue()) continue;
                    this.createOCLExtensionForConstraint(constraint, extElForConstraintsCategory, editor);
                }
            }
        }
        this.generateBindings(pluginID, editor, this.constraintsManager);
        editor.getProject().refreshLocal(0, null);
        try {
            editor.save();
        }
        finally {
            return;
        }
    }

    private Element createExtensionForConstraint(String pluginID, IValidationRule constraint, Element parentElement, PluginEditor editor) {
        Element message;
        Element extElForConstraint = editor.getPluginEditor().addChild(parentElement, EMF_VALIDATION_CONSTRAINT_CHILD);
        extElForConstraint.setAttribute(ID, constraint.getID());
        extElForConstraint.setAttribute(XML_CONSTRAINT_NAME, constraint.getName());
        extElForConstraint.setAttribute(XML_CONSTRAINT_LANG, JAVA_LANGUAGE);
        extElForConstraint.setAttribute(XML_CONSTRAINT_STATUS_CODE, constraint.getStatusCode().toString());
        extElForConstraint.setAttribute(XML_CONSTRAINT_SEVERITY, constraint.getSeverity().name());
        extElForConstraint.setAttribute(XML_CONSTRAINT_CLASS, String.valueOf(pluginID) + SEPARATOR + constraint.getImplementingClass());
        extElForConstraint.setAttribute(XML_CONSTRAINT_MODE, constraint.getMode().name());
        extElForConstraint.setAttribute(XML_CONSTRAINT_IS_ENABLED_BY_DEFAULT, String.valueOf(constraint.isEnabledByDefault()));
        if (constraint.getTargets() != null) {
            for (String target : constraint.getTargets()) {
                Element targetExtension = editor.addChild(extElForConstraint, XML_CONSTRAINT_TARGET);
                targetExtension.setAttribute(XML_CONSTRAINT_CLASS, target);
            }
        }
        if (constraint.getMessage() != null) {
            message = editor.addChild(extElForConstraint, XML_CONSTRAINT_MESSAGE);
            message.setTextContent(constraint.getMessage());
        } else {
            message = editor.addChild(extElForConstraint, XML_CONSTRAINT_MESSAGE);
            message.setTextContent(String.valueOf(constraint.getName()) + " not validated");
        }
        if (constraint.getDescription() != null) {
            Element description = editor.addChild(extElForConstraint, "description");
            description.setTextContent(constraint.getDescription());
        }
        return extElForConstraint;
    }

    private Element createOCLExtensionForConstraint(IValidationRule validation, Element parentElement, PluginEditor editor) {
        Element extElForConstraint = editor.getPluginEditor().addChild(parentElement, EMF_VALIDATION_CONSTRAINT_CHILD);
        extElForConstraint.setAttribute(ID, validation.getID());
        extElForConstraint.setAttribute(XML_CONSTRAINT_NAME, validation.getName());
        extElForConstraint.setAttribute(XML_CONSTRAINT_LANG, OCL_LANGUAGE);
        extElForConstraint.setAttribute(XML_CONSTRAINT_STATUS_CODE, validation.getStatusCode().toString());
        extElForConstraint.setAttribute(XML_CONSTRAINT_SEVERITY, validation.getSeverity().name());
        extElForConstraint.setAttribute(XML_CONSTRAINT_MODE, validation.getMode().name());
        extElForConstraint.setAttribute(XML_CONSTRAINT_IS_ENABLED_BY_DEFAULT, String.valueOf(validation.isEnabledByDefault()));
        if (validation.getTargets() != null) {
            for (String target : validation.getTargets()) {
                Element targetExtension = editor.addChild(extElForConstraint, XML_CONSTRAINT_TARGET);
                targetExtension.setAttribute(XML_CONSTRAINT_CLASS, target);
            }
        }
        if (validation.getMessage() != null) {
            Element message = editor.addChild(extElForConstraint, XML_CONSTRAINT_MESSAGE);
            message.setTextContent(validation.getMessage());
        }
        if (validation.getDescription() != null) {
            Element description = editor.addChild(extElForConstraint, "description");
            description.setTextContent(validation.getDescription());
        }
        if (Utils.getOCLConstraintBody((Constraint)validation.getConstraint()) != null) {
            Document doc = editor.getDocument();
            CDATASection cdata = doc.createCDATASection(Utils.getOCLConstraintBody((Constraint)validation.getConstraint()));
            extElForConstraint.appendChild(cdata);
        }
        parentElement.appendChild(extElForConstraint);
        return extElForConstraint;
    }

    public static Document parseXmlFile(String filename, boolean validating) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(validating);
            Document doc = factory.newDocumentBuilder().parse(new File(filename));
            return doc;
        }
        catch (SAXException sAXException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private Element createExtensionForCategory(String pluginID, Category category, Element parentElement, PluginEditor editor) {
        Element extElForCategory = editor.getPluginEditor().addChild(parentElement, "category");
        extElForCategory.setAttribute(ID, String.valueOf(pluginID) + SEPARATOR + category.getID());
        extElForCategory.setAttribute(XML_CONSTRAINT_NAME, String.valueOf(pluginID) + SEPARATOR + category.getName());
        extElForCategory.setAttribute("mandatory", String.valueOf(category.isMandatory()));
        return extElForCategory;
    }

    private Element createExtensionForConstraintsProvider(IConstraintProvider constraintProvider, Element parentElement, PluginEditor editor, EPackage definition) {
        Element extElForConstraintsProvider = editor.getPluginEditor().addChild(parentElement, "constraintProvider");
        extElForConstraintsProvider.setAttribute(XML_CONSTRAINT_MODE, constraintProvider.getMode().name());
        extElForConstraintsProvider.setAttribute("cache", String.valueOf(constraintProvider.getCache()));
        Element pcg = editor.addChild(extElForConstraintsProvider, "package");
        if (constraintProvider.getEPackage() == null) {
            pcg.setAttribute("namespaceUri", UML_URL);
        } else {
            pcg.setAttribute("namespaceUri", constraintProvider.getEPackage().getNsURI());
        }
        return extElForConstraintsProvider;
    }

    private Element createExtensionForConstraintsCategory(String pluginID, IConstraintsCategory constraintsCategory, Element parentElement, PluginEditor editor, IConstraintsManager constraintManager) {
        Element extElForConstraintsCategory = editor.getPluginEditor().addChild(parentElement, "constraints");
        extElForConstraintsCategory.setAttribute("categories", String.valueOf(pluginID) + SEPARATOR + constraintManager.getPrimeCategory().getName());
        return extElForConstraintsCategory;
    }

    private void generateBindings(String pluginID, PluginEditor editor, IConstraintsManager constraintsManager) {
        Element extension = this.createOrCleanExtension(editor, EMF_VALIDATION_CONSTRAINT_BINDINGS_EXTENSIONPOINT);
        Set constrainedStereotype = constraintsManager.getConstraintsOfStereotype().keySet();
        for (Stereotype stereotype : constrainedStereotype) {
            Element clientContextElement = editor.getPluginEditor().addChild(extension, "clientContext");
            clientContextElement.setAttribute(ID, String.valueOf(stereotype.getName()) + "ClientContext");
            Element selectorElement = editor.addChild(clientContextElement, "selector");
            selectorElement.setAttribute(XML_CONSTRAINT_CLASS, String.valueOf(pluginID) + ".selectors." + stereotype.getName() + "ClientSelector");
            List constraints = (List)constraintsManager.getConstraintsOfStereotype().get(stereotype);
            Element bindingelement = editor.getPluginEditor().addChild(extension, "binding");
            bindingelement.setAttribute("context", String.valueOf(stereotype.getName()) + "ClientContext");
            for (Constraint constraint : constraints) {
                ((ValidationRuleImpl)constraintsManager.getValidationRuleMap().get(constraint)).getID();
                Element constraintElement = editor.addChild(bindingelement, EMF_VALIDATION_CONSTRAINT_CHILD);
                constraintElement.setAttribute("ref", String.valueOf(pluginID) + SEPARATOR + ((ValidationRuleImpl)constraintsManager.getValidationRuleMap().get(constraint)).getID());
            }
        }
    }

    protected Element createOrCleanExtension(PluginEditor editor, String extensionName) {
        List existingExtensions = editor.getPluginEditor().getExtensions(extensionName);
        if (existingExtensions.size() > 0 && existingExtensions.get(0) instanceof Element) {
            Node child;
            Element extension = (Element)existingExtensions.get(0);
            while ((child = extension.getFirstChild()) != null) {
                extension.removeChild(child);
            }
            return extension;
        }
        return editor.getPluginEditor().addExtension(extensionName);
    }

    private void createHierarchyOfCategories(String projectName, Category category, Element parentElement, PluginEditor editor) {
        this.createExtensionForCategory(projectName, category, parentElement, editor);
    }

    public static String getContextprefix() {
        return "";
    }
}

