/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dsml.validation.wizard;

import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.papyrus.dsml.validation.model.elements.interfaces.IConstraintsManager;
import org.eclipse.papyrus.dsml.validation.wizard.JavaContentGenerator;
import org.eclipse.papyrus.dsml.validation.wizard.ValidationPluginGenerator;
import org.eclipse.pde.internal.ui.wizards.plugin.NewPluginProjectWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Profile;

public class CreateEMFValidationProject
extends NewPluginProjectWizard {
    private static final String GENERATION_MESSAGE = "Generation of EMF Validation Plugin";
    private IConstraintsManager constraintsManager;
    private JavaContentGenerator generateAllJava;
    private Profile selectedProfile;
    private EPackage definition = null;

    public CreateEMFValidationProject(Profile selectedProfile, IConstraintsManager constraintsExtractor, EPackage definition) {
        this.setWindowTitle(GENERATION_MESSAGE);
        this.constraintsManager = constraintsExtractor;
        this.selectedProfile = selectedProfile;
        this.definition = definition;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.fContentPage) {
            return null;
        }
        return super.getNextPage(page);
    }

    public void addPages() {
        super.addPages();
    }

    public void openDialog() {
        Shell frame = new Shell(1264);
        WizardDialog dialog = new WizardDialog(frame, (IWizard)this);
        dialog.open();
    }

    public boolean performFinish() {
        boolean result = super.performFinish();
        if (result) {
            IProject project = this.fMainPage.getProjectHandle();
            try {
                this.generateAllJava = new JavaContentGenerator(project, this.selectedProfile);
                this.generateAllJava.run();
                ValidationPluginGenerator.instance.generate(project, this.constraintsManager, this.definition);
                project.refreshLocal(2, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }
}

