/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.common.library.connector.ILibrary;
import org.eclipse.acceleo.common.utils.CompactLinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AcceleoLibraryConnectorsRegistry {
    public static final AcceleoLibraryConnectorsRegistry INSTANCE = new AcceleoLibraryConnectorsRegistry();
    private final Set<Class<ILibrary>> registeredLibraryConnectors = new CompactLinkedHashSet<Class<ILibrary>>();
    private final Map<String, Class<?>> connectorByFileExtension = new HashMap();

    private AcceleoLibraryConnectorsRegistry() {
    }

    public void addLibraryConnector(Class<ILibrary> connector, String fileExtension) {
        this.registeredLibraryConnectors.add(connector);
        this.connectorByFileExtension.put(fileExtension, connector);
    }

    public void removeLibraryConnector(String attribute) {
        for (Class<ILibrary> connector : this.registeredLibraryConnectors) {
            if (!attribute.equals(connector.getName())) continue;
            this.registeredLibraryConnectors.remove(connector);
            Iterator<Map.Entry<String, Class<?>>> it = this.connectorByFileExtension.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Class<?>> entry = it.next();
                if (!entry.getValue().equals(connector)) continue;
                it.remove();
            }
        }
    }

    public Set<Class<ILibrary>> getAllRegisteredLibraryConnector() {
        return this.registeredLibraryConnectors;
    }

    public Class<ILibrary> getConnectorForResource(String resource) {
        Class<?> ret = null;
        int idx = resource.lastIndexOf(46);
        if (idx > 0 && idx < resource.length()) {
            String fileExtension = resource.substring(idx + 1, resource.length());
            ret = this.connectorByFileExtension.get(fileExtension);
        }
        return ret;
    }

    public void clearRegistry() {
        this.registeredLibraryConnectors.clear();
        this.connectorByFileExtension.clear();
    }
}

