/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.configuration.providers;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.emf.providers.EMFLabelProvider;
import org.eclipse.papyrus.infra.gmfdiag.CSSRuntimeModule;
import org.eclipse.papyrus.infra.gmfdiag.css.Ruleset;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.EmbeddedStyleSheet;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheetReference;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xtext.serializer.ISerializer;

public class StylesheetLabelProvider
extends EMFLabelProvider {
    @Inject
    private ISerializer serializer;

    public StylesheetLabelProvider() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new CSSRuntimeModule()});
        injector.injectMembers((Object)this);
    }

    public String getText(Object element) {
        if (element instanceof Ruleset) {
            return this.getText((Ruleset)element);
        }
        if (element instanceof StyleSheetReference) {
            return this.getText((StyleSheetReference)element);
        }
        if (element instanceof EmbeddedStyleSheet) {
            return this.getText((EmbeddedStyleSheet)element);
        }
        return super.getText(element);
    }

    public String getText(Ruleset ruleset) {
        String label = "";
        if (!ruleset.getSelectors().isEmpty()) {
            label = String.valueOf(label) + this.serializer.serialize((EObject)ruleset.getSelectors().get(0));
            int i = 1;
            while (i < ruleset.getSelectors().size()) {
                label = String.valueOf(label) + ", " + this.serializer.serialize((EObject)ruleset.getSelectors().get(i));
                ++i;
            }
            label = label.trim().replaceAll("\\s+", " ");
        }
        return label;
    }

    public String getText(StyleSheetReference stylesheet) {
        return stylesheet.getPath();
    }

    public String getText(EmbeddedStyleSheet stylesheet) {
        return stylesheet.getLabel();
    }

    public Color getForeground(Object element) {
        if (!(element instanceof Ruleset)) {
            return Display.getCurrent().getSystemColor(16);
        }
        return super.getForeground(element);
    }

    public Image getImage(Object element) {
        return null;
    }
}

