/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.configuration.providers;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.gmfdiag.css.Content;
import org.eclipse.papyrus.infra.gmfdiag.css.Ruleset;
import org.eclipse.papyrus.infra.gmfdiag.css.Stylesheet;
import org.eclipse.papyrus.infra.gmfdiag.css.configuration.helper.XtextStylesheetHelper;
import org.eclipse.papyrus.infra.gmfdiag.css.notation.CSSDiagram;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.EmbeddedStyleSheet;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheet;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheetReference;
import org.eclipse.papyrus.infra.widgets.providers.IHierarchicContentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExistingStyleContentProvider
implements IHierarchicContentProvider {
    protected Map<StyleSheet, Stylesheet> stylesheets;
    protected final View context;

    public ExistingStyleContentProvider(View context) {
        this.context = context;
    }

    public Object[] getElements(Object inputElement) {
        Collection<StyleSheet> stylesheets = this.getStyleSheets();
        if (stylesheets.isEmpty()) {
            return new Object[]{"No stylesheet available"};
        }
        return stylesheets.toArray();
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof StyleSheet) {
            Stylesheet xtextStylesheet = this.stylesheets.get(parentElement);
            LinkedList<Ruleset> result = new LinkedList<Ruleset>();
            for (Content stylesheetElement : xtextStylesheet.getContents()) {
                if (!(stylesheetElement instanceof Ruleset)) continue;
                result.add((Ruleset)stylesheetElement);
            }
            return result.toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof Stylesheet) {
            return null;
        }
        if (element instanceof Ruleset) {
            return ((Ruleset)element).eContainer();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public boolean isValidValue(Object element) {
        return element instanceof Ruleset;
    }

    protected Collection<StyleSheet> getStyleSheets() {
        if (this.stylesheets == null) {
            this.stylesheets = new LinkedHashMap<StyleSheet, Stylesheet>();
            if (this.context.getDiagram() instanceof CSSDiagram) {
                CSSDiagram diagram = (CSSDiagram)this.context.getDiagram();
                this.parseStyleSheets(diagram.getStyleSheets());
            }
        }
        return this.stylesheets.keySet();
    }

    protected void parseStyleSheets(List<StyleSheet> appliedStylesheets) {
        for (StyleSheet stylesheet : appliedStylesheets) {
            if (stylesheet instanceof StyleSheetReference) {
                this.parseStyleSheet((StyleSheetReference)stylesheet);
                continue;
            }
            boolean cfr_ignored_0 = stylesheet instanceof EmbeddedStyleSheet;
        }
    }

    protected void parseStyleSheet(StyleSheetReference stylesheet) {
        Resource resource = XtextStylesheetHelper.loadStylesheet(stylesheet, null, this.context, null);
        if (resource.getContents().isEmpty()) {
            return;
        }
        for (EObject rootElement : resource.getContents()) {
            if (!(rootElement instanceof Stylesheet)) continue;
            this.stylesheets.put((StyleSheet)stylesheet, (Stylesheet)rootElement);
        }
    }
}

