/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.configuration.handler;

import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.gmfdiag.css.Attribute;
import org.eclipse.papyrus.infra.gmfdiag.css.Declaration;
import org.eclipse.papyrus.infra.gmfdiag.css.configuration.handler.AbstractStyleDialog;
import org.eclipse.papyrus.infra.gmfdiag.css.properties.provider.CSSStyleSheetContentProvider;
import org.eclipse.papyrus.infra.gmfdiag.css.properties.provider.CSSStyleSheetLabelProvider;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.EmbeddedStyleSheet;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheet;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheetReference;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StylesheetsFactory;
import org.eclipse.papyrus.infra.widgets.editors.AbstractEditor;
import org.eclipse.papyrus.infra.widgets.editors.ICommitListener;
import org.eclipse.papyrus.infra.widgets.editors.ReferenceDialog;
import org.eclipse.papyrus.infra.widgets.editors.StringEditor;
import org.eclipse.papyrus.infra.widgets.editors.StringFileSelector;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleCreationDialog
extends AbstractStyleDialog {
    private StringFileSelector externalStylesheetEditor;
    private StringEditor embeddedStylesheetEditor;
    private ReferenceDialog appliedStylesheetEditor;
    private boolean ignoreEvents = false;
    private AbstractEditor stylesheetSource;
    private StyleSheet stylesheet;

    public StyleCreationDialog(Shell shell, Map<Attribute, Boolean> conditions, Map<Declaration, Boolean> declarations, String selectorName, View context) {
        super(shell, conditions, declarations, selectorName, context);
    }

    @Override
    public void create() {
        super.create();
        Composite parent = this.getDialogArea();
        CTabItem stylesheetTab = new CTabItem(this.tabFolder, 0);
        stylesheetTab.setText("Stylesheet");
        Composite stylesheetContainer = new Composite((Composite)this.tabFolder, 0);
        stylesheetContainer.setLayoutData((Object)new GridData(1, 1, true, true));
        stylesheetContainer.setBackground(parent.getDisplay().getSystemColor(1));
        stylesheetContainer.setBackgroundMode(1);
        stylesheetTab.setControl((Control)stylesheetContainer);
        this.createStylesheet(stylesheetContainer);
        this.getShell().setText("Create a new style");
    }

    @Override
    protected boolean isValid() {
        boolean result = true;
        if (this.getStyleSheet() == null) {
            this.setError("You must select a Stylesheet");
            result = false;
        }
        if (this.getStyleSheet() instanceof EmbeddedStyleSheet) {
            this.setError("Edition of embedded stylesheets is not yet supported. Please select an external stylesheet");
            result = false;
        }
        return super.isValid() && result;
    }

    protected void createStylesheet(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.externalStylesheetEditor = new StringFileSelector(parent, 0);
        this.externalStylesheetEditor.setFilters(new String[]{"*.css", "*"}, new String[]{"CSS Stylesheets (*.css)", "All (*)"});
        this.externalStylesheetEditor.setAllowFileSystem(false);
        this.externalStylesheetEditor.setLabel("External stylesheet:");
        this.externalStylesheetEditor.setToolTipText("Create or use an existing external CSS Stylesheet");
        this.externalStylesheetEditor.setLayoutData((Object)new GridData(4, 1, true, false));
        this.externalStylesheetEditor.addCommitListener(new ICommitListener(){

            public void commit(AbstractEditor editor) {
                String path = (String)((StringEditor)editor).getValue();
                if (path != null && !"".equals(path) || StyleCreationDialog.this.stylesheetSource == StyleCreationDialog.this.externalStylesheetEditor) {
                    StyleSheetReference stylesheetReference = null;
                    if (path != null && !"".equals(path)) {
                        stylesheetReference = StylesheetsFactory.eINSTANCE.createStyleSheetReference();
                        stylesheetReference.setPath(path);
                    }
                    StyleCreationDialog.this.stylesheet = stylesheetReference;
                    StyleCreationDialog.this.resetStylesheetEditors((AbstractEditor)StyleCreationDialog.this.externalStylesheetEditor);
                    StyleCreationDialog.this.updateButtons();
                }
            }
        });
        Label orLabel = new Label(parent, 0);
        orLabel.setText("-- OR --");
        this.embeddedStylesheetEditor = new StringEditor(parent, 0);
        this.embeddedStylesheetEditor.setLabel("New local stylesheet:");
        this.embeddedStylesheetEditor.setToolTipText("Enter the new local stylesheet's name");
        this.embeddedStylesheetEditor.setReadOnly(true);
        this.embeddedStylesheetEditor.setLayoutData((Object)new GridData(4, 1, true, false));
        this.embeddedStylesheetEditor.addCommitListener(new ICommitListener(){

            public void commit(AbstractEditor editor) {
                String name = (String)((StringEditor)editor).getValue();
                EmbeddedStyleSheet embeddedStylesheet = StylesheetsFactory.eINSTANCE.createEmbeddedStyleSheet();
                embeddedStylesheet.setLabel(name);
                StyleCreationDialog.this.stylesheet = (StyleSheet)embeddedStylesheet;
                StyleCreationDialog.this.resetStylesheetEditors((AbstractEditor)StyleCreationDialog.this.embeddedStylesheetEditor);
                StyleCreationDialog.this.updateButtons();
            }
        });
        orLabel = new Label(parent, 0);
        orLabel.setText("-- OR --");
        this.appliedStylesheetEditor = new ReferenceDialog(parent, 0);
        this.appliedStylesheetEditor.setLabel("Applied stylesheet:");
        this.appliedStylesheetEditor.setToolTipText("Use an existing stylesheet, from the stylesheets applied to the current model");
        this.appliedStylesheetEditor.setLayoutData((Object)new GridData(4, 1, true, false));
        this.appliedStylesheetEditor.setContentProvider((IStaticContentProvider)new CSSStyleSheetContentProvider((EObject)this.contextView));
        this.appliedStylesheetEditor.setLabelProvider((ILabelProvider)new CSSStyleSheetLabelProvider());
        this.appliedStylesheetEditor.addCommitListener(new ICommitListener(){

            public void commit(AbstractEditor editor) {
                StyleSheet value = (StyleSheet)((ReferenceDialog)editor).getValue();
                if (!StyleCreationDialog.this.ignoreEvents || value != null) {
                    StyleCreationDialog.this.stylesheet = value;
                    StyleCreationDialog.this.resetStylesheetEditors((AbstractEditor)StyleCreationDialog.this.appliedStylesheetEditor);
                }
                StyleCreationDialog.this.updateButtons();
            }
        });
    }

    private void resetStylesheetEditors(AbstractEditor stylesheetSource) {
        if (this.ignoreEvents) {
            return;
        }
        this.ignoreEvents = true;
        if (stylesheetSource != this.externalStylesheetEditor) {
            this.externalStylesheetEditor.setValue(null);
        }
        if (stylesheetSource != this.embeddedStylesheetEditor) {
            this.embeddedStylesheetEditor.setValue(null);
        }
        if (stylesheetSource != this.appliedStylesheetEditor) {
            this.appliedStylesheetEditor.setValue(null);
        }
        this.stylesheetSource = stylesheetSource;
        this.ignoreEvents = false;
    }

    public StyleSheet getStyleSheet() {
        return this.stylesheet;
    }
}

