/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.evaluator;

import java.util.Map;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.evaluator.IOCLVMEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.evaluator.OCLVMRootEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.vm.UnitLocation;
import org.eclipse.ocl.examples.debug.vm.evaluator.IVMEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.vm.evaluator.VMNestedEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.vm.utils.ASTBindingHelper;
import org.eclipse.ocl.examples.debug.vm.utils.VMRuntimeException;
import org.eclipse.ocl.examples.debug.vm.utils.VMStackTraceBuilder;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Variable;

public class OCLVMNestedEvaluationEnvironment
extends VMNestedEvaluationEnvironment<ExpressionInOCL>
implements IOCLVMEvaluationEnvironment {
    @NonNull
    private Element myCurrentIP;
    @NonNull
    private NamedElement myOperation;
    private final int myStackDepth;
    private final long id;

    public OCLVMNestedEvaluationEnvironment(@NonNull IOCLVMEvaluationEnvironment evaluationEnvironment, long id, @NonNull NamedElement operation) {
        super((IVMEvaluationEnvironment)evaluationEnvironment);
        this.myStackDepth = evaluationEnvironment.getDepth() + 1;
        this.id = id;
        this.myOperation = operation;
        this.myCurrentIP = operation;
    }

    @Override
    @NonNull
    public IOCLVMEvaluationEnvironment createClonedEvaluationEnvironment() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public Element getCurrentIP() {
        return this.myCurrentIP;
    }

    @NonNull
    public UnitLocation getCurrentLocation() {
        int startPosition = ASTBindingHelper.getStartPosition((Element)this.myCurrentIP);
        int endPosition = ASTBindingHelper.getEndPosition((Element)this.myCurrentIP);
        return new UnitLocation(startPosition, endPosition, (IVMEvaluationEnvironment)this, this.myCurrentIP);
    }

    public int getDepth() {
        return this.myStackDepth;
    }

    public long getID() {
        return this.id;
    }

    @NonNull
    public Map<String, Resource> getModelParameterVariables() {
        return this.getRootEvaluationEnvironment().getModelParameterVariables();
    }

    @NonNull
    public NamedElement getOperation() {
        return this.myOperation;
    }

    @NonNull
    public Variable getPCVariable() {
        return this.rootEvaluationEnvironment.getPCVariable();
    }

    @Override
    @Nullable
    public IOCLVMEvaluationEnvironment getParentEvaluationEnvironment() {
        return (IOCLVMEvaluationEnvironment)super.getParentEvaluationEnvironment();
    }

    @Override
    @NonNull
    public OCLVMRootEvaluationEnvironment getRootEvaluationEnvironment() {
        return (OCLVMRootEvaluationEnvironment)this.rootEvaluationEnvironment;
    }

    public boolean isDeferredExecution() {
        return this.getRootEvaluationEnvironment().isDeferredExecution();
    }

    public void processDeferredTasks() {
        this.getRootEvaluationEnvironment().processDeferredTasks();
    }

    @NonNull
    public Element setCurrentIP(@NonNull Element element) {
        Element prevValue = this.myCurrentIP;
        this.myCurrentIP = element;
        return prevValue;
    }

    public void setOperation(@NonNull NamedElement operation) {
        this.myCurrentIP = operation;
        this.myOperation = operation;
    }

    public void throwVMException(@NonNull VMRuntimeException exception) throws VMRuntimeException {
        try {
            this.getRootEvaluationEnvironment().saveThrownException(exception);
            exception.setStackVMTrace(new VMStackTraceBuilder((IVMEvaluationEnvironment)this).buildStackTrace());
        }
        catch (Exception e) {
            this.getDebugCore().error("Failed to build VM stack trace", (Throwable)e);
        }
        throw exception;
    }
}

