/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.evaluator;

import java.util.regex.Pattern;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.evaluator.IOCLVMEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.evaluator.IOCLVMEvaluationVisitor;
import org.eclipse.ocl.examples.debug.evaluator.OCLVMEnvironment;
import org.eclipse.ocl.examples.debug.evaluator.OCLVMNestedEvaluationVisitor;
import org.eclipse.ocl.examples.debug.evaluator.OCLVMRootEvaluationVisitor;
import org.eclipse.ocl.examples.debug.vm.VMVirtualMachine;
import org.eclipse.ocl.examples.debug.vm.evaluator.IVMEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.vm.utils.VMInterruptedExecutionException;
import org.eclipse.ocl.examples.domain.elements.DomainExpression;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.domain.evaluation.DomainLogger;
import org.eclipse.ocl.examples.domain.evaluation.DomainModelManager;
import org.eclipse.ocl.examples.domain.types.IdResolver;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Environment;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitorImpl;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.util.AbstractWrappingVisitor;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.ocl.examples.pivot.util.Visitor;

public abstract class OCLVMEvaluationVisitor
extends AbstractWrappingVisitor<Object, Object, IOCLVMEvaluationVisitor, Element>
implements IOCLVMEvaluationVisitor {
    protected OCLVMEvaluationVisitor(@NonNull IOCLVMEvaluationVisitor nestedEvaluationVisitor) {
        super((Visitor)nestedEvaluationVisitor, new Object());
        ((IOCLVMEvaluationVisitor)this.delegate).setUndecoratedVisitor((EvaluationVisitor)this);
    }

    @NonNull
    public EvaluationVisitor getClonedEvaluator() {
        IOCLVMEvaluationEnvironment oldEvaluationEnvironment = this.getEvaluationEnvironment();
        IOCLVMEvaluationEnvironment clonedEvaluationEnvironment = oldEvaluationEnvironment.createClonedEvaluationEnvironment();
        return new EvaluationVisitorImpl((Environment)this.getEnvironment(), (EvaluationEnvironment)clonedEvaluationEnvironment, this.getModelManager());
    }

    public abstract int getDepth();

    @NonNull
    public OCLVMEnvironment getEnvironment() {
        return (OCLVMEnvironment)((IOCLVMEvaluationVisitor)this.delegate).getEnvironment();
    }

    @NonNull
    public IOCLVMEvaluationEnvironment getEvaluationEnvironment() {
        return (IOCLVMEvaluationEnvironment)((IOCLVMEvaluationVisitor)this.delegate).getEvaluationEnvironment();
    }

    @NonNull
    public String getPluginId() {
        return "org.eclipse.ocl.examples.debug";
    }

    protected void processDeferredTasks() {
    }

    @Nullable
    protected Object badVisit(@NonNull Visitable visitable, @Nullable Element preState, @NonNull Throwable e) throws RuntimeException {
        if (e instanceof VMInterruptedExecutionException) {
            throw (VMInterruptedExecutionException)e;
        }
        Element element = (Element)visitable;
        IOCLVMEvaluationEnvironment evalEnv = this.getEvaluationEnvironment();
        Object result = this.badVisit(evalEnv, element, preState, e);
        if (VMVirtualMachine.POST_VISIT.isActive()) {
            VMVirtualMachine.POST_VISIT.println("[" + Thread.currentThread().getName() + "] " + element.eClass().getName() + ": " + element.toString());
        }
        return result;
    }

    @Nullable
    protected abstract Object badVisit(@NonNull IVMEvaluationEnvironment<?> var1, @NonNull Element var2, Object var3, @NonNull Throwable var4);

    protected void superProcessDeferredTasks() {
        IOCLVMEvaluationEnvironment evalEnv = this.getEvaluationEnvironment();
        evalEnv.processDeferredTasks();
    }

    protected Object postVisit(@NonNull Visitable visitable, @Nullable Element prologue, @Nullable Object result) {
        Element element = (Element)visitable;
        if (VMVirtualMachine.POST_VISIT.isActive()) {
            VMVirtualMachine.POST_VISIT.println("[" + Thread.currentThread().getName() + "] " + element.eClass().getName() + ": " + element.toString() + " => " + result);
        }
        IOCLVMEvaluationEnvironment evalEnv = this.getEvaluationEnvironment();
        this.postVisit(evalEnv, element, result);
        return result;
    }

    protected abstract void postVisit(@NonNull IVMEvaluationEnvironment<?> var1, @NonNull Element var2, @Nullable Object var3);

    @Nullable
    protected Element preVisit(@NonNull Visitable visitable) {
        Element element = (Element)visitable;
        if (VMVirtualMachine.PRE_VISIT.isActive()) {
            VMVirtualMachine.PRE_VISIT.println("[" + Thread.currentThread().getName() + "] " + element.eClass().getName() + ": " + element.toString());
        }
        Element previousIP = this.setCurrentEnvInstructionPointer(null);
        IOCLVMEvaluationEnvironment evalEnv = this.getEvaluationEnvironment();
        this.preVisit(evalEnv, element);
        return previousIP;
    }

    protected abstract Object preVisit(@NonNull IVMEvaluationEnvironment<?> var1, @NonNull Element var2);

    protected Element setCurrentEnvInstructionPointer(Element element) {
        IOCLVMEvaluationEnvironment evalEnv = this.getEvaluationEnvironment();
        if (element != null) {
            return evalEnv.setCurrentIP(element);
        }
        return evalEnv.getCurrentIP();
    }

    public Object visitVariable(@NonNull Variable vd) {
        Object result = super.visitVariable(vd);
        Type declaredType = vd.getType();
        IOCLVMEvaluationEnvironment env = this.getEvaluationEnvironment();
        env.replace((DomainTypedElement)vd, declaredType);
        return result;
    }

    @Override
    @NonNull
    public IOCLVMEvaluationVisitor createNestedEvaluator() {
        return new OCLVMNestedEvaluationVisitor(this, ((IOCLVMEvaluationVisitor)this.delegate).createNestedEvaluator());
    }

    @Nullable
    public Object evaluate(@NonNull DomainExpression body) {
        return ((IOCLVMEvaluationVisitor)this.delegate).evaluate(body);
    }

    @Nullable
    public Object evaluate(@NonNull ExpressionInOCL expressionInOCL) {
        return ((IOCLVMEvaluationVisitor)this.delegate).evaluate(expressionInOCL);
    }

    @NonNull
    public EvaluationVisitor getEvaluator() {
        return ((IOCLVMEvaluationVisitor)this.delegate).getEvaluator();
    }

    @NonNull
    public DomainModelManager getModelManager() {
        return ((IOCLVMEvaluationVisitor)this.delegate).getModelManager();
    }

    @NonNull
    public MetaModelManager getMetaModelManager() {
        return ((IOCLVMEvaluationVisitor)this.delegate).getMetaModelManager();
    }

    @NonNull
    public DomainStandardLibrary getStandardLibrary() {
        return ((IOCLVMEvaluationVisitor)this.delegate).getStandardLibrary();
    }

    public void setUndecoratedVisitor(@NonNull EvaluationVisitor evaluationVisitor) {
        ((IOCLVMEvaluationVisitor)this.delegate).setUndecoratedVisitor(evaluationVisitor);
    }

    @NonNull
    public IdResolver getIdResolver() {
        return ((IOCLVMEvaluationVisitor)this.delegate).getIdResolver();
    }

    @Nullable
    public DomainLogger getLogger() {
        return ((IOCLVMEvaluationVisitor)this.delegate).getLogger();
    }

    @Nullable
    public Monitor getMonitor() {
        return ((IOCLVMEvaluationVisitor)this.delegate).getMonitor();
    }

    @NonNull
    public Pattern getRegexPattern(@NonNull String regex) {
        return ((IOCLVMEvaluationVisitor)this.delegate).getRegexPattern(regex);
    }

    @NonNull
    public abstract OCLVMRootEvaluationVisitor getRootEvaluationVisitor();

    @NonNull
    public DomainType getStaticTypeOf(@Nullable Object value) {
        return ((IOCLVMEvaluationVisitor)this.delegate).getStaticTypeOf(value);
    }

    @NonNull
    public DomainType getStaticTypeOf(@Nullable Object value, Object ... values) {
        return ((IOCLVMEvaluationVisitor)this.delegate).getStaticTypeOf(value, values);
    }

    @NonNull
    public DomainType getStaticTypeOf(@Nullable Object value, @NonNull Iterable<?> values) {
        return ((IOCLVMEvaluationVisitor)this.delegate).getStaticTypeOf(value, values);
    }

    public boolean isCanceled() {
        return ((IOCLVMEvaluationVisitor)this.delegate).isCanceled();
    }

    public void setCanceled(boolean isCanceled) {
        ((IOCLVMEvaluationVisitor)this.delegate).setCanceled(isCanceled);
    }

    public void setLogger(@Nullable DomainLogger logger) {
        ((IOCLVMEvaluationVisitor)this.delegate).setLogger(logger);
    }

    public void setMonitor(@Nullable Monitor monitor) {
        ((IOCLVMEvaluationVisitor)this.delegate).setMonitor(monitor);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "(" + this.getDepth() + ")";
    }
}

