/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceFilter;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.internal.p2.discovery.model.Tag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTagFilter
extends MarketplaceFilter {
    public static final String PROP_SELECTED = "selected";
    public static final String PROP_CHOICES = "choices";
    private List<Tag> choices;
    private Set<Tag> selected = new HashSet<Tag>();
    private boolean selectAllOnNoSelection;
    private Object tagClassification;

    @Override
    public final boolean select(CatalogItem item) {
        if (this.selectAllOnNoSelection && this.selected.isEmpty()) {
            return true;
        }
        return this.hasSelectedTag(item);
    }

    protected boolean hasSelectedTag(CatalogItem item) {
        Set tags = item.getTags();
        if (tags != null) {
            for (Tag selectedTag : this.selected) {
                if (!tags.contains(selectedTag)) continue;
                return true;
            }
        }
        return false;
    }

    public List<Tag> getChoices() {
        return this.choices;
    }

    public void setChoices(List<Tag> choices) {
        List<Tag> previousChoices = this.choices;
        this.choices = choices;
        if (!(previousChoices == choices || choices != null && choices.equals(previousChoices))) {
            this.choicesChanged(choices, previousChoices);
        }
    }

    protected void choicesChanged(List<Tag> choices, List<Tag> previousChoices) {
        this.firePropertyChange(PROP_CHOICES, previousChoices, choices);
    }

    public Set<Tag> getSelected() {
        return this.selected;
    }

    public void setSelected(Set<Tag> selected) {
        this.selected = selected;
    }

    public boolean isSelectAllOnNoSelection() {
        return this.selectAllOnNoSelection;
    }

    public void setSelectAllOnNoSelection(boolean selectAllOnNoSelection) {
        this.selectAllOnNoSelection = selectAllOnNoSelection;
    }

    protected void selectionUpdated() {
        this.firePropertyChange(PROP_SELECTED, null, this.getSelected());
    }

    protected void updateUi() {
    }

    @Override
    public void catalogUpdated(boolean wasCancelled) {
    }

    public Object getTagClassification() {
        return this.tagClassification;
    }

    public void setTagClassification(Object tagClassification) {
        this.tagClassification = tagClassification;
    }
}

