/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.catalog;

import java.net.URL;
import java.util.EnumSet;
import java.util.Set;
import org.eclipse.epp.mpc.core.model.INode;
import org.eclipse.epp.mpc.ui.Operation;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarketplaceNodeCatalogItem
extends CatalogItem {
    private URL marketplaceUrl;
    private Boolean updateAvailable;

    public INode getData() {
        return (INode)super.getData();
    }

    public URL getMarketplaceUrl() {
        return this.marketplaceUrl;
    }

    public void setMarketplaceUrl(URL marketplaceUrl) {
        this.marketplaceUrl = marketplaceUrl;
    }

    public Boolean getUpdateAvailable() {
        return this.updateAvailable;
    }

    public void setUpdateAvailable(Boolean updateAvailable) {
        this.updateAvailable = updateAvailable;
    }

    public Set<Operation> getAvailableOperations() {
        EnumSet<Operation> available = EnumSet.noneOf(Operation.class);
        MarketplaceNodeCatalogItem catalogItem = (MarketplaceNodeCatalogItem)this.getData();
        if (!catalogItem.getInstallableUnits().isEmpty()) {
            if (this.isInstalled()) {
                available.add(Operation.UNINSTALL);
                if (this.maybeUpdateAvailable()) {
                    available.add(Operation.UPDATE);
                }
            } else if (this.maybeAvailable()) {
                available.add(Operation.INSTALL);
            }
        }
        return available;
    }

    private boolean maybeAvailable() {
        Boolean available = this.getAvailable();
        return available == null || Boolean.TRUE.equals(available);
    }

    private boolean maybeUpdateAvailable() {
        Boolean updateAvailable = this.getUpdateAvailable();
        return updateAvailable == null || Boolean.TRUE.equals(updateAvailable);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        MarketplaceNodeCatalogItem other = (MarketplaceNodeCatalogItem)((Object)obj);
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

