/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.marte.vsl.extensions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.marte.vsl.extensions.VSLContextUtil;
import org.eclipse.papyrus.marte.vsl.vSL.AdditiveExpression;
import org.eclipse.papyrus.marte.vsl.vSL.AndOrXorExpression;
import org.eclipse.papyrus.marte.vsl.vSL.BooleanLiteralRule;
import org.eclipse.papyrus.marte.vsl.vSL.CollectionOrTuple;
import org.eclipse.papyrus.marte.vsl.vSL.ConditionalExpression;
import org.eclipse.papyrus.marte.vsl.vSL.DateTimeLiteralRule;
import org.eclipse.papyrus.marte.vsl.vSL.DefaultLiteralRule;
import org.eclipse.papyrus.marte.vsl.vSL.DurationObsExpression;
import org.eclipse.papyrus.marte.vsl.vSL.EqualityExpression;
import org.eclipse.papyrus.marte.vsl.vSL.Expression;
import org.eclipse.papyrus.marte.vsl.vSL.InstantObsExpression;
import org.eclipse.papyrus.marte.vsl.vSL.IntegerLiteralRule;
import org.eclipse.papyrus.marte.vsl.vSL.Interval;
import org.eclipse.papyrus.marte.vsl.vSL.JitterExp;
import org.eclipse.papyrus.marte.vsl.vSL.Literal;
import org.eclipse.papyrus.marte.vsl.vSL.MultiplicativeExpression;
import org.eclipse.papyrus.marte.vsl.vSL.NameOrChoiceOrBehaviorCall;
import org.eclipse.papyrus.marte.vsl.vSL.NullLiteralRule;
import org.eclipse.papyrus.marte.vsl.vSL.OperationCallExpression;
import org.eclipse.papyrus.marte.vsl.vSL.PrimaryExpression;
import org.eclipse.papyrus.marte.vsl.vSL.PropertyCallExpression;
import org.eclipse.papyrus.marte.vsl.vSL.RealLiteralRule;
import org.eclipse.papyrus.marte.vsl.vSL.RelationalExpression;
import org.eclipse.papyrus.marte.vsl.vSL.StringLiteralRule;
import org.eclipse.papyrus.marte.vsl.vSL.SuffixExpression;
import org.eclipse.papyrus.marte.vsl.vSL.TimeExpression;
import org.eclipse.papyrus.marte.vsl.vSL.Tuple;
import org.eclipse.papyrus.marte.vsl.vSL.UnaryExpression;
import org.eclipse.papyrus.marte.vsl.vSL.UnlimitedLiteralRule;
import org.eclipse.papyrus.marte.vsl.vSL.ValueNamePair;
import org.eclipse.papyrus.marte.vsl.vSL.ValueSpecification;
import org.eclipse.papyrus.marte.vsl.vSL.VariableDeclaration;
import org.eclipse.papyrus.marte.vsl.validation.VSLJavaValidator;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;

public class VSLTypeInferenceUtil {
    private Type expectedType;
    private VSLTypeInferenceUtil self;

    public VSLTypeInferenceUtil(Type expectedType) {
        this.expectedType = expectedType;
        this.self = this;
    }

    public Type typeOfExpression(Expression exp) {
        Type inferedType = this.typeOfAndOrXorExpression(exp.getExp());
        return inferedType;
    }

    private Type typeOfAndOrXorExpression(AndOrXorExpression exp) {
        if (exp.getExp().size() > 1) {
            Type firstOperandType = this.typeOfEqualityExpression((EqualityExpression)exp.getExp().get(0));
            int i = 1;
            while (i < exp.getExp().size()) {
                Type secondOperandType = this.typeOfEqualityExpression((EqualityExpression)exp.getExp().get(i));
                firstOperandType = VSLJavaValidator.opSignatures.get(String.valueOf((String)exp.getOp().get(i - 1)) + "(" + (firstOperandType != null ? firstOperandType.getName() : "null") + "," + (secondOperandType != null ? secondOperandType.getName() : "null") + ")");
                ++i;
            }
            return firstOperandType;
        }
        return this.typeOfEqualityExpression((EqualityExpression)exp.getExp().get(0));
    }

    private Type typeOfEqualityExpression(EqualityExpression exp) {
        if (exp.getExp().size() > 1) {
            Type firstOperandType = this.typeOfRelationalExpression((RelationalExpression)exp.getExp().get(0));
            int i = 1;
            while (i < exp.getExp().size()) {
                Type secondOperandType = this.typeOfRelationalExpression((RelationalExpression)exp.getExp().get(i));
                firstOperandType = VSLJavaValidator.opSignatures.get(String.valueOf((String)exp.getOp().get(i - 1)) + "(" + (firstOperandType != null ? firstOperandType.getName() : "null") + "," + (secondOperandType != null ? secondOperandType.getName() : "null") + ")");
                ++i;
            }
            return firstOperandType;
        }
        return this.typeOfRelationalExpression((RelationalExpression)exp.getExp().get(0));
    }

    private Type typeOfRelationalExpression(RelationalExpression exp) {
        if (exp.getExp().size() > 1) {
            Type firstOperandType = this.typeOfConditionalExpression((ConditionalExpression)exp.getExp().get(0));
            int i = 1;
            while (i < exp.getExp().size()) {
                Type secondOperandType = this.typeOfConditionalExpression((ConditionalExpression)exp.getExp().get(i));
                firstOperandType = VSLJavaValidator.opSignatures.get(String.valueOf((String)exp.getOp().get(i - 1)) + "(" + (firstOperandType != null ? firstOperandType.getName() : "null") + "," + (secondOperandType != null ? secondOperandType.getName() : "null") + ")");
                ++i;
            }
            return firstOperandType;
        }
        return this.typeOfConditionalExpression((ConditionalExpression)exp.getExp().get(0));
    }

    private Type typeOfConditionalExpression(ConditionalExpression exp) {
        if (exp.getExp().size() == 3) {
            Classifier elseOperandType;
            Classifier thenOperandType = exp.getExp().get(1) != null ? (Classifier)this.typeOfAdditiveExpression((AdditiveExpression)exp.getExp().get(1)) : null;
            Classifier classifier = elseOperandType = exp.getExp().get(2) != null ? (Classifier)this.typeOfAdditiveExpression((AdditiveExpression)exp.getExp().get(2)) : null;
            if (thenOperandType == elseOperandType) {
                return thenOperandType;
            }
            if (thenOperandType != null && this.areTypesCompatible((Type)thenOperandType, (Type)elseOperandType)) {
                return elseOperandType;
            }
            if (elseOperandType != null && this.areTypesCompatible((Type)elseOperandType, (Type)thenOperandType)) {
                return thenOperandType;
            }
            return null;
        }
        if (exp.getExp().size() == 2) {
            return null;
        }
        return this.typeOfAdditiveExpression((AdditiveExpression)exp.getExp().get(0));
    }

    public Type typeOfAdditiveExpression(AdditiveExpression exp) {
        if (exp.getExp().size() > 1) {
            Type firstOperandType = this.typeOfMultiplicativeExpression((MultiplicativeExpression)exp.getExp().get(0));
            int i = 1;
            while (i < exp.getExp().size()) {
                Type secondOperandType = this.typeOfMultiplicativeExpression((MultiplicativeExpression)exp.getExp().get(i));
                firstOperandType = VSLJavaValidator.opSignatures.get(String.valueOf((String)exp.getOp().get(i - 1)) + "(" + (firstOperandType != null ? firstOperandType.getName() : "null") + "," + (secondOperandType != null ? secondOperandType.getName() : "null") + ")");
                ++i;
            }
            return firstOperandType;
        }
        return this.typeOfMultiplicativeExpression((MultiplicativeExpression)exp.getExp().get(0));
    }

    private Type typeOfMultiplicativeExpression(MultiplicativeExpression exp) {
        if (exp.getExp().size() > 1) {
            Type firstOperandType = this.typeOfUnaryExpression((UnaryExpression)exp.getExp().get(0));
            int i = 1;
            while (i < exp.getExp().size()) {
                Type secondOperandType = this.typeOfUnaryExpression((UnaryExpression)exp.getExp().get(i));
                firstOperandType = VSLJavaValidator.opSignatures.get(String.valueOf((String)exp.getOp().get(i - 1)) + "(" + (firstOperandType != null ? firstOperandType.getName() : "null") + "," + (secondOperandType != null ? secondOperandType.getName() : "null") + ")");
                ++i;
            }
            return firstOperandType;
        }
        return exp.getExp().size() > 0 ? this.typeOfUnaryExpression((UnaryExpression)exp.getExp().get(0)) : null;
    }

    private Type typeOfUnaryExpression(UnaryExpression exp) {
        if (exp.getOp() != null) {
            Type typeOfUnary = this.typeOfUnaryExpression(exp.getUnary());
            return VSLJavaValidator.opSignatures.get(String.valueOf(exp.getOp()) + "(" + (typeOfUnary != null ? typeOfUnary.getName() : "null") + ")");
        }
        if (exp.getExp() != null) {
            return this.typeOfPrimaryExpression(exp.getExp());
        }
        return null;
    }

    private Type typeOfPrimaryExpression(PrimaryExpression exp) {
        if (exp.getSuffix() != null) {
            return this.typeOfSuffixPression(exp.getSuffix());
        }
        return this.typeOfValueSpecification(exp.getPrefix());
    }

    private Type typeOfSuffixPression(SuffixExpression exp) {
        if (exp instanceof OperationCallExpression) {
            return this.typeOfOperationCallExpression((OperationCallExpression)exp);
        }
        return this.typeOfPropertyCallExpression((PropertyCallExpression)exp);
    }

    private Type typeOfOperationCallExpression(OperationCallExpression exp) {
        if (exp.getSuffix() != null) {
            return this.typeOfSuffixPression(exp.getSuffix());
        }
        return exp.getOperation() != null ? exp.getOperation().getType() : null;
    }

    private Type typeOfPropertyCallExpression(PropertyCallExpression exp) {
        if (exp.getSuffix() != null) {
            return this.typeOfSuffixPression(exp.getSuffix());
        }
        return exp.getProperty() != null ? exp.getProperty().getType() : null;
    }

    public Type typeOfValueSpecification(ValueSpecification value) {
        if (value instanceof Literal) {
            return this.typeOfLiteral((Literal)value);
        }
        if (value instanceof NameOrChoiceOrBehaviorCall) {
            return this.typeOfNameOrChoiceOrBehaviorCall((NameOrChoiceOrBehaviorCall)value);
        }
        if (value instanceof TimeExpression) {
            return this.typeOfTimeExpression((TimeExpression)value);
        }
        if (value instanceof VariableDeclaration) {
            return this.typeOfVariableDeclaration((VariableDeclaration)value);
        }
        if (value instanceof Expression) {
            return this.typeOfExpression((Expression)value);
        }
        if (value instanceof Interval) {
            return this.typeOfInterval((Interval)value);
        }
        if (value instanceof Tuple) {
            return this.typeOfTuple((Tuple)value);
        }
        if (value instanceof CollectionOrTuple) {
            return this.typeOfCollectionOrTuple((CollectionOrTuple)value);
        }
        return null;
    }

    private Type typeOfLiteral(Literal literal) {
        if (literal instanceof IntegerLiteralRule) {
            return VSLJavaValidator._integer;
        }
        if (literal instanceof UnlimitedLiteralRule) {
            return VSLJavaValidator._unlimitedNatural;
        }
        if (literal instanceof RealLiteralRule) {
            return VSLJavaValidator._real;
        }
        if (literal instanceof DateTimeLiteralRule) {
            return VSLJavaValidator._datetime;
        }
        if (literal instanceof BooleanLiteralRule) {
            return VSLJavaValidator._boolean;
        }
        if (literal instanceof NullLiteralRule) {
            Type locallyExpected = VSLContextUtil.getExpectedType(literal);
            return locallyExpected;
        }
        if (literal instanceof DefaultLiteralRule) {
            Type locallyExpected = VSLContextUtil.getExpectedType(literal);
            return locallyExpected;
        }
        if (literal instanceof StringLiteralRule) {
            return VSLJavaValidator._string;
        }
        return null;
    }

    private Type typeOfNameOrChoiceOrBehaviorCall(NameOrChoiceOrBehaviorCall name) {
        if (name.getId() != null) {
            if (name.getId() instanceof EnumerationLiteral) {
                return ((EnumerationLiteral)name.getId()).getEnumeration();
            }
            if (name.getId() instanceof Property) {
                if (name.getId().getNamespace().getAppliedStereotype("MARTE::MARTE_Annexes::VSL::DataTypes::ChoiceType") != null) {
                    return (Type)name.getId().getNamespace();
                }
                return ((Property)name.getId()).getType();
            }
            if (name.getId() instanceof Behavior) {
                for (Parameter p : ((Behavior)name.getId()).getOwnedParameters()) {
                    if (p.getDirection() != ParameterDirectionKind.RETURN_LITERAL) continue;
                    return p.getType();
                }
            }
            return null;
        }
        return null;
    }

    private Type typeOfTimeExpression(TimeExpression timeExpression) {
        if (timeExpression instanceof InstantObsExpression) {
            return VSLJavaValidator._datetime;
        }
        if (timeExpression instanceof DurationObsExpression) {
            return VSLJavaValidator._real;
        }
        if (timeExpression instanceof JitterExp) {
            return VSLJavaValidator._real;
        }
        return null;
    }

    private Type typeOfVariableDeclaration(VariableDeclaration variableDeclaration) {
        if (variableDeclaration.getType() != null) {
            return variableDeclaration.getType().getType();
        }
        if (variableDeclaration.getInitValue() != null) {
            return this.typeOfExpression(variableDeclaration.getInitValue());
        }
        return null;
    }

    private Type typeOfInterval(Interval interval) {
        final class IntervalTypeProposal {
            private Type boundsType = null;

            public IntervalTypeProposal(Interval interval) {
                VSLTypeInferenceUtil localTypeChecker = VSLTypeInferenceUtil.this.self;
                if (VSLTypeInferenceUtil.this.expectedType.getAppliedStereotype("MARTE::MARTE_Annexes::VSL::DataTypes::IntervalType") != null) {
                    EStructuralFeature intervalAttrib;
                    Stereotype intervalStereotype = VSLTypeInferenceUtil.this.expectedType.getAppliedStereotype("MARTE::MARTE_Annexes::VSL::DataTypes::IntervalType");
                    EObject stereotypeApplication = VSLTypeInferenceUtil.this.expectedType.getStereotypeApplication(intervalStereotype);
                    Property intervalProperty = (Property)stereotypeApplication.eGet(intervalAttrib = stereotypeApplication.eClass().getEStructuralFeature("intervalAttrib"));
                    Type expectedBoundType = intervalProperty.getType();
                    if (expectedBoundType.getAppliedStereotype("MARTE::MARTE_Annexes::VSL::DataTypes::TupleType") != null || expectedBoundType.getAppliedStereotype("MARTE::MARTE_Foundations::NFPs::NfpType") != null || expectedBoundType.getAppliedStereotype("MARTE::MARTE_Annexes::VSL::DataTypes::CollectionType") != null || expectedBoundType.getAppliedStereotype("MARTE::MARTE_Annexes::VSL::DataTypes::IntervalType") != null || expectedBoundType.getAppliedStereotype("MARTE::MARTE_Annexes::VSL::DataTypes::ChoiceType") != null) {
                        localTypeChecker = new VSLTypeInferenceUtil(expectedBoundType);
                    }
                }
                if (interval.getLower() != null && interval.getUpper() != null) {
                    Type typeOfLower = localTypeChecker.typeOfExpression(interval.getLower());
                    Type typeOfUpper = localTypeChecker.typeOfExpression(interval.getUpper());
                    if (typeOfLower != null && typeOfUpper != null && (VSLTypeInferenceUtil.this.areTypesCompatible(typeOfLower, typeOfUpper) || VSLTypeInferenceUtil.this.areTypesCompatible(typeOfUpper, typeOfLower))) {
                        this.boundsType = VSLTypeInferenceUtil.this.areTypesCompatible(typeOfLower, typeOfUpper) ? typeOfUpper : typeOfLower;
                    }
                }
            }

            public boolean matchesExpectedType(Type expectedType) {
                EStructuralFeature intervalAttrib;
                EObject stereotypeApplication;
                Property intervalProperty;
                if (this.boundsType == null) {
                    return false;
                }
                Stereotype intervalStereotype = expectedType.getAppliedStereotype("MARTE::MARTE_Annexes::VSL::DataTypes::IntervalType");
                return intervalStereotype != null && VSLTypeInferenceUtil.this.areTypesCompatible(this.boundsType, (intervalProperty = (Property)(stereotypeApplication = expectedType.getStereotypeApplication(intervalStereotype)).eGet(intervalAttrib = stereotypeApplication.eClass().getEStructuralFeature("intervalAttrib"))).getType());
            }

            public Type makeTypeProsal() {
                return null;
            }
        }
        IntervalTypeProposal proposal = new IntervalTypeProposal(interval);
        if (proposal.matchesExpectedType(this.expectedType)) {
            return this.expectedType;
        }
        return proposal.makeTypeProsal();
    }

    private Type typeOfTuple(Tuple tuple) {
        final class TupleTypeProposal {
            private List<Property> tupleAttribs = new ArrayList<Property>();

            public TupleTypeProposal(Tuple tuple) {
                for (ValueNamePair v : tuple.getListOfValueNamePairs().getValueNamePairs()) {
                    if (v.getProperty() == null) continue;
                    this.tupleAttribs.add(v.getProperty());
                }
            }

            public boolean matchesExpectedType(Type expectedType) {
                Stereotype tupleStereotype = expectedType.getAppliedStereotype("MARTE::MARTE_Annexes::VSL::DataTypes::TupleType");
                if (tupleStereotype == null) {
                    tupleStereotype = expectedType.getAppliedStereotype("MARTE::MARTE_Foundations::NFPs::NfpType");
                }
                if (tupleStereotype != null) {
                    EStructuralFeature tupleAttrib;
                    EObject stereotypeApplication = expectedType.getStereotypeApplication(tupleStereotype);
                    List tupleProperty = (List)stereotypeApplication.eGet(tupleAttrib = stereotypeApplication.eClass().getEStructuralFeature("tupleAttrib"));
                    if (tupleProperty.isEmpty()) {
                        return ((DataType)expectedType).getAllAttributes().containsAll(this.tupleAttribs);
                    }
                    return tupleProperty.containsAll(this.tupleAttribs);
                }
                return false;
            }

            public Type makeTypeProposal() {
                return null;
            }
        }
        TupleTypeProposal proposal = new TupleTypeProposal(tuple);
        if (proposal.matchesExpectedType(this.expectedType)) {
            return this.expectedType;
        }
        return proposal.makeTypeProposal();
    }

    private Type typeOfCollectionOrTuple(CollectionOrTuple collOrtuple) {
        final class CollectionOrTupleTypeProposal {
            private List<Type> collectionOrTupleElemTypes = new ArrayList<Type>();

            public CollectionOrTupleTypeProposal(CollectionOrTuple collOrTuple) {
                VSLTypeInferenceUtil localTypeChecker = VSLTypeInferenceUtil.this.self;
                ArrayList<VSLTypeInferenceUtil> localListOfTypeCheckers = new ArrayList<VSLTypeInferenceUtil>();
                if (VSLTypeInferenceUtil.this.expectedType.getAppliedStereotype("MARTE::MARTE_Annexes::VSL::DataTypes::CollectionType") != null) {
                    EStructuralFeature collectionAttrib;
                    Stereotype collectionStereotype = VSLTypeInferenceUtil.this.expectedType.getAppliedStereotype("MARTE::MARTE_Annexes::VSL::DataTypes::CollectionType");
                    EObject stereotypeApplication = VSLTypeInferenceUtil.this.expectedType.getStereotypeApplication(collectionStereotype);
                    Property collectionProperty = (Property)stereotypeApplication.eGet(collectionAttrib = stereotypeApplication.eClass().getEStructuralFeature("collectionAttrib"));
                    Type expectedElementType = collectionProperty.getType();
                    if (expectedElementType.getAppliedStereotype("MARTE::MARTE_Annexes::VSL::DataTypes::TupleType") != null || expectedElementType.getAppliedStereotype("MARTE::MARTE_Foundations::NFPs::NfpType") != null || expectedElementType.getAppliedStereotype("MARTE::MARTE_Annexes::VSL::DataTypes::CollectionType") != null || expectedElementType.getAppliedStereotype("MARTE::MARTE_Annexes::VSL::DataTypes::IntervalType") != null || expectedElementType.getAppliedStereotype("MARTE::MARTE_Annexes::VSL::DataTypes::ChoiceType") != null) {
                        localTypeChecker = new VSLTypeInferenceUtil(expectedElementType);
                    }
                } else if (VSLTypeInferenceUtil.this.expectedType.getAppliedStereotype("MARTE::MARTE_Annexes::VSL::DataTypes::TupleType") != null || VSLTypeInferenceUtil.this.expectedType.getAppliedStereotype("MARTE::MARTE_Foundations::NFPs::NfpType") != null) {
                    EList collectionProperty = new ArrayList();
                    collectionProperty.addAll(((Classifier)VSLTypeInferenceUtil.this.expectedType).getAllAttributes());
                    if (collectionProperty.isEmpty()) {
                        collectionProperty = ((Classifier)VSLTypeInferenceUtil.this.expectedType).getAllAttributes();
                    }
                    int i = 0;
                    while (i < collOrTuple.getListOfValues().getValues().size()) {
                        Type expectedElementType;
                        Type type = expectedElementType = i < collectionProperty.size() ? ((Property)collectionProperty.get(i)).getType() : null;
                        if (expectedElementType != null && (expectedElementType.getAppliedStereotype("MARTE::MARTE_Annexes::VSL::DataTypes::TupleType") != null || expectedElementType.getAppliedStereotype("MARTE::MARTE_Foundations::NFPs::NfpType") != null || expectedElementType.getAppliedStereotype("MARTE::MARTE_Annexes::VSL::DataTypes::CollectionType") != null || expectedElementType.getAppliedStereotype("MARTE::MARTE_Annexes::VSL::DataTypes::IntervalType") != null || expectedElementType.getAppliedStereotype("MARTE::MARTE_Annexes::VSL::DataTypes::ChoiceType") != null)) {
                            localListOfTypeCheckers.add(new VSLTypeInferenceUtil(expectedElementType));
                        } else {
                            localListOfTypeCheckers.add(VSLTypeInferenceUtil.this.self);
                        }
                        ++i;
                    }
                }
                int i = 0;
                while (i < collOrTuple.getListOfValues().getValues().size()) {
                    Expression exp = (Expression)collOrTuple.getListOfValues().getValues().get(i);
                    Type typeOfExp = (VSLTypeInferenceUtil.this.expectedType.getAppliedStereotype("MARTE::MARTE_Annexes::VSL::DataTypes::TupleType") != null || VSLTypeInferenceUtil.this.expectedType.getAppliedStereotype("MARTE::MARTE_Foundations::NFPs::NfpType") != null ? (VSLTypeInferenceUtil)localListOfTypeCheckers.get(i) : localTypeChecker).typeOfExpression(exp);
                    this.collectionOrTupleElemTypes.add(typeOfExp);
                    ++i;
                }
            }

            public boolean matchesExpectedType(Type expectedType) {
                Stereotype tupleStereotype = expectedType.getAppliedStereotype("MARTE::MARTE_Annexes::VSL::DataTypes::TupleType");
                tupleStereotype = expectedType.getAppliedStereotype("MARTE::MARTE_Foundations::NFPs::NfpType");
                Stereotype collectionStereotype = expectedType.getAppliedStereotype("MARTE::MARTE_Annexes::VSL::DataTypes::CollectionType");
                if (collectionStereotype != null) {
                    EStructuralFeature collectionAttrib;
                    EObject stereotypeApplication = expectedType.getStereotypeApplication(collectionStereotype);
                    Property collectionProperty = (Property)stereotypeApplication.eGet(collectionAttrib = stereotypeApplication.eClass().getEStructuralFeature("collectionAttrib"));
                    if (collectionProperty.getType() != null) {
                        if (this.collectionOrTupleElemTypes.isEmpty()) {
                            return false;
                        }
                        for (Type t : this.collectionOrTupleElemTypes) {
                            if (VSLTypeInferenceUtil.this.areTypesCompatible(t, collectionProperty.getType())) continue;
                            return false;
                        }
                        return true;
                    }
                } else if (tupleStereotype != null) {
                    ArrayList tupleProperty = new ArrayList();
                    tupleProperty.addAll(((Classifier)expectedType).getAllAttributes());
                    if (tupleProperty.isEmpty()) {
                        int numberOfElementsToTest = Math.min(((DataType)expectedType).getAllAttributes().size(), this.collectionOrTupleElemTypes.size());
                        int i = 0;
                        while (i < numberOfElementsToTest) {
                            if (this.collectionOrTupleElemTypes.get(i) != null && ((DataType)expectedType).getAllAttributes().get(i) != null && ((Property)((DataType)expectedType).getAllAttributes().get(i)).getType() != null) {
                                if (!VSLTypeInferenceUtil.this.areTypesCompatible(this.collectionOrTupleElemTypes.get(i), ((Property)((DataType)expectedType).getAllAttributes().get(i)).getType())) {
                                    return false;
                                }
                            } else {
                                return false;
                            }
                            ++i;
                        }
                        return true;
                    }
                    int numberOfElementsToTest = Math.min(((DataType)expectedType).getAllAttributes().size(), this.collectionOrTupleElemTypes.size());
                    int i = 0;
                    while (i < numberOfElementsToTest) {
                        if (this.collectionOrTupleElemTypes.get(i) != null && tupleProperty.get(i) != null && ((Property)tupleProperty.get(i)).getType() != null) {
                            if (!VSLTypeInferenceUtil.this.areTypesCompatible(this.collectionOrTupleElemTypes.get(i), ((Property)tupleProperty.get(i)).getType())) {
                                return false;
                            }
                        } else {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
                return false;
            }

            public Type makeTypeProposal() {
                return null;
            }
        }
        CollectionOrTupleTypeProposal proposal = new CollectionOrTupleTypeProposal(collOrtuple);
        if (proposal.matchesExpectedType(this.expectedType)) {
            return this.expectedType;
        }
        return proposal.makeTypeProposal();
    }

    public boolean areTypesCompatible(Type found, Type expected) {
        if (found == null) {
            return false;
        }
        if (found == VSLJavaValidator._integer && expected == VSLJavaValidator._unlimitedNatural) {
            return true;
        }
        return found.conformsTo(expected);
    }
}

