/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.internal.interpreter;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterContext;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterProvider;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterStatus;
import org.eclipse.sirius.common.tools.internal.interpreter.IService;
import org.eclipse.sirius.common.tools.internal.interpreter.MonomorphicService;
import org.eclipse.sirius.common.tools.internal.interpreter.PolymorphicService;
import org.eclipse.sirius.common.tools.internal.interpreter.VariableInterpreter;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.osgi.framework.Bundle;

public class ServiceInterpreter
extends VariableInterpreter
implements IInterpreter,
IInterpreterProvider {
    public static final String PREFIX = "service:";
    public static final String RECEIVER_SEPARATOR = ".";
    private static final String EOBJECT_CLASS_NAME = EObject.class.getCanonicalName();
    private final Map<Object, Object> properties = Maps.newHashMap();
    private final Set<Bundle> bundles = Sets.newLinkedHashSet();
    private final Set<String> imports = Sets.newLinkedHashSet();
    private final Map<String, PolymorphicService> services = Maps.newHashMap();
    private Function<String, String> file2bundleName = new Function<String, String>(){

        public String apply(String file) {
            String[] segments = file.split(Pattern.quote("/"));
            if (segments != null && segments.length > 1) {
                return segments[1];
            }
            return null;
        }
    };

    public static Option<String> getReceiverVariableName(String expression) {
        int indexOfServiceName = expression.indexOf(RECEIVER_SEPARATOR);
        if (indexOfServiceName != -1) {
            String receiverVariableName = expression.substring(0, indexOfServiceName);
            return Options.newSome((Object)receiverVariableName);
        }
        return Options.newNone();
    }

    @Override
    public IInterpreter createInterpreter() {
        return new ServiceInterpreter();
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public Object evaluate(EObject target, String expression) throws EvaluationException {
        Object evaluation = null;
        if (target != null && expression != null && expression.startsWith(PREFIX)) {
            int indexOfParenthesis;
            String serviceCall = expression.substring(PREFIX.length()).trim();
            Option<String> receiverVariableName = ServiceInterpreter.getReceiverVariableName(serviceCall);
            EObject receiver = target;
            String serviceName = serviceCall;
            if (receiverVariableName.some()) {
                serviceCall = serviceCall.substring(((String)receiverVariableName.get()).length() + 1);
                Object objectReceiver = this.evaluateVariable(target, ((String)receiverVariableName.get()).trim());
                if (objectReceiver instanceof EObject) {
                    receiver = (EObject)objectReceiver;
                } else {
                    throw new EvaluationException("The receiver of the service call " + serviceCall + " is not an EObject.");
                }
            }
            serviceName = serviceCall.substring(0, (indexOfParenthesis = serviceCall.indexOf("(")) == -1 ? serviceCall.length() : indexOfParenthesis);
            Object[] parameters = new Object[]{receiver};
            if (indexOfParenthesis != -1) {
                String[] values = serviceCall.split("[(,)]");
                parameters = new Object[values.length];
                parameters[0] = receiver;
                int i = 1;
                while (i < values.length) {
                    parameters[i] = this.evaluateVariable(target, values[i].trim());
                    ++i;
                }
            }
            evaluation = this.callService(parameters, serviceName);
        }
        return evaluation;
    }

    private Object callService(Object[] target, String serviceName) throws EvaluationException {
        if (this.services.containsKey(serviceName)) {
            IService service = this.services.get(serviceName);
            return service.call(target);
        }
        throw new EvaluationException("Unknown service \"" + serviceName + "\"");
    }

    @Override
    public void addImport(String dependency) {
        Class<?> klass = this.loadClassFromBundlePath(dependency);
        if (klass != null) {
            this.registerServiceClass(klass);
        }
    }

    private void registerServiceClass(Class<?> klass) {
        Object serviceInstance = null;
        try {
            serviceInstance = klass.newInstance();
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        if (serviceInstance == null) {
            return;
        }
        Method[] methodArray = klass.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (ServiceInterpreter.isValidServiceMethod(m)) {
                this.registerService(new MonomorphicService(serviceInstance, m));
            }
            ++n2;
        }
        this.imports.add(klass.getCanonicalName());
    }

    private void registerService(MonomorphicService service) {
        String name = service.getName();
        if (!this.services.containsKey(name)) {
            this.services.put(name, new PolymorphicService(name));
        }
        this.services.get(name).addImplementer(service);
    }

    public static boolean isValidServiceMethod(Method m) {
        int mods = m.getModifiers();
        Class<?>[] parameterTypes = m.getParameterTypes();
        if (!Modifier.isPublic(mods) || parameterTypes.length < 1) {
            return false;
        }
        boolean result = false;
        try {
            ClassLoader classLoader = m.getDeclaringClass().getClassLoader();
            if (classLoader != null) {
                Class<?> eobjectClass = classLoader.loadClass(EOBJECT_CLASS_NAME);
                result = eobjectClass.isAssignableFrom(parameterTypes[0]);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            result = false;
        }
        return result;
    }

    @Override
    public Collection<String> getImports() {
        return Sets.newHashSet(this.imports);
    }

    @Override
    public void removeImport(String dependency) {
        this.imports.remove(dependency);
    }

    @Override
    public void clearImports() {
        this.imports.clear();
        this.services.clear();
    }

    private Class<?> loadClassFromBundlePath(String className) {
        for (Bundle bundle : this.bundles) {
            try {
                return bundle.loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return null;
    }

    @Override
    public void setProperty(Object key, Object value) {
        this.properties.put(key, value);
        if ("files".equals(key) && value instanceof List) {
            this.updateBundlePath(Iterables.filter((Iterable)((List)value), String.class));
            this.services.clear();
        }
    }

    private void updateBundlePath(Iterable<String> files) {
        this.bundles.clear();
        for (String name : Iterables.filter((Iterable)Iterables.transform(files, this.file2bundleName), (Predicate)Predicates.notNull())) {
            Bundle bundle = Platform.getBundle((String)name);
            if (bundle == null) continue;
            this.bundles.add(bundle);
        }
    }

    public Map<String, IService> getServices() {
        return new HashMap<String, IService>(this.services);
    }

    @Override
    public boolean supportsValidation() {
        return false;
    }

    @Override
    public Collection<IInterpreterStatus> validateExpression(IInterpreterContext context, String expression) {
        ArrayList<IInterpreterStatus> interpreterStatus = new ArrayList<IInterpreterStatus>();
        return interpreterStatus;
    }
}

